/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    final int[] hb;
    final int offset;
    boolean isReadOnly;

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract int get();

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        int n4 = this.limit() - 1;
        while (n4 >= n3) {
            n2 = 31 * n2 + this.get(n4);
            --n4;
        }
        return n2;
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final int[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public abstract int get(int var1);

    IntBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    IntBuffer(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = nArray;
        this.offset = n6;
    }

    public int compareTo(Object object) {
        IntBuffer intBuffer = (IntBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), intBuffer.remaining());
        int n3 = this.position();
        int n4 = intBuffer.position();
        while (n3 < n2) {
            int n5;
            int n6 = this.get(n3);
            if (n6 != (n5 = intBuffer.get(n4)) && (n6 == n6 || n5 == n5)) {
                if (n6 < n5) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - intBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntBuffer)) {
            return false;
        }
        IntBuffer intBuffer = (IntBuffer)object;
        if (this.remaining() != intBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = intBuffer.limit() - 1;
        while (n3 >= n2) {
            int n5;
            int n6 = this.get(n3);
            if (n6 != (n5 = intBuffer.get(n4)) && (n6 == n6 || n5 == n5)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteOrder order();

    public abstract IntBuffer asReadOnlyBuffer();

    public abstract IntBuffer compact();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer slice();

    public static IntBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapIntBuffer(n2, n2);
    }

    public abstract IntBuffer put(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public static IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public IntBuffer get(int[] nArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, nArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            nArray[n5] = this.get();
            ++n5;
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, nArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            this.put(nArray[n5]);
            ++n5;
        }
        return this;
    }

    public static IntBuffer wrap(int[] nArray, int n2, int n3) {
        try {
            return new HeapIntBuffer(nArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = intBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = 0;
        while (n3 < n2) {
            this.put(intBuffer.get());
            ++n3;
        }
        return this;
    }
}

