/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import sun.security.action.GetBooleanAction;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private transient int mask;
    private String actions;
    private transient String hostname;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private static boolean trustProxy;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("trustProxy"));
        trustProxy = bl2;
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            this.cname = this.init_with_ip ? this.addresses[0].getHostName(false).toLowerCase() : InetAddress.getByName(this.addresses[0].getHostAddress()).getHostName(false).toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int n2;
            String string = this.getName().charAt(0) == '[' ? this.getName().substring(1, this.getName().indexOf(93)) : ((n2 = this.getName().indexOf(":")) == -1 ? this.getName() : this.getName().substring(0, n2));
            this.addresses = new InetAddress[]{InetAddress.getAllByName0(string, false)[0]};
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.invalid = true;
            throw new UnknownHostException(this.getName());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (this.mask != socketPermission.mask) {
            return false;
        }
        if (this.portrange[0] != socketPermission.portrange[0] || this.portrange[1] != socketPermission.portrange[1]) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(socketPermission.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            socketPermission.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.invalid || socketPermission.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
            stringBuffer.append("connect");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("listen");
        }
        if ((n2 & 4) == 4) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("accept");
        }
        if ((n2 & 8) == 8) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("resolve");
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        if (var0 == null) {
            throw new NullPointerException("action can't be null");
        }
        if (var0.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl44
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 6 || var2_2[var3_3 - 6] != 'c' && var2_2[var3_3 - 6] != 'C' || var2_2[var3_3 - 5] != 'o' && var2_2[var3_3 - 5] != 'O' || var2_2[var3_3 - 4] != 'n' && var2_2[var3_3 - 4] != 'N' || var2_2[var3_3 - 3] != 'n' && var2_2[var3_3 - 3] != 'N' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'c' && var2_2[var3_3 - 1] != 'C' || var2_2[var3_3] != 't' && var2_2[var3_3] != 'T')) {
                    var5_5 = 7;
                    var1_1 |= 1;
                } else if (!(var3_3 < 6 || var2_2[var3_3 - 6] != 'r' && var2_2[var3_3 - 6] != 'R' || var2_2[var3_3 - 5] != 'e' && var2_2[var3_3 - 5] != 'E' || var2_2[var3_3 - 4] != 's' && var2_2[var3_3 - 4] != 'S' || var2_2[var3_3 - 3] != 'o' && var2_2[var3_3 - 3] != 'O' || var2_2[var3_3 - 2] != 'l' && var2_2[var3_3 - 2] != 'L' || var2_2[var3_3 - 1] != 'v' && var2_2[var3_3 - 1] != 'V' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 7;
                    var1_1 |= 8;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'l' && var2_2[var3_3 - 5] != 'L' || var2_2[var3_3 - 4] != 'i' && var2_2[var3_3 - 4] != 'I' || var2_2[var3_3 - 3] != 's' && var2_2[var3_3 - 3] != 'S' || var2_2[var3_3 - 2] != 't' && var2_2[var3_3 - 2] != 'T' || var2_2[var3_3 - 1] != 'e' && var2_2[var3_3 - 1] != 'E' || var2_2[var3_3] != 'n' && var2_2[var3_3] != 'N')) {
                    var5_5 = 6;
                    var1_1 |= 2;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'a' && var2_2[var3_3 - 5] != 'A' || var2_2[var3_3 - 4] != 'c' && var2_2[var3_3 - 4] != 'C' || var2_2[var3_3 - 3] != 'c' && var2_2[var3_3 - 3] != 'C' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'p' && var2_2[var3_3 - 1] != 'P' || var2_2[var3_3] != 't' && var2_2[var3_3] != 'T')) {
                    var5_5 = 6;
                    var1_1 |= 4;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl44:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    private int[] parsePort(String string) throws Exception {
        if (string == null || string.equals("") || string.equals("*")) {
            return new int[]{0, 65535};
        }
        int n2 = string.indexOf(45);
        if (n2 == -1) {
            int n3 = Integer.parseInt(string);
            return new int[]{n3, n3};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        int n4 = string2.equals("") ? 0 : Integer.parseInt(string2);
        int n5 = string3.equals("") ? 65535 : Integer.parseInt(string3);
        if (n4 < 0 || n5 < 0 || n5 < n4) {
            throw new IllegalArgumentException("invalid port range");
        }
        return new int[]{n4, n5};
    }

    SocketPermission(String string, int n2) {
        super(SocketPermission.getHost(string));
        this.init(string, n2);
    }

    private void init(String string, int n2) {
        block20: {
            char c2;
            if (string == null) {
                throw new NullPointerException("host can't be null");
            }
            string = SocketPermission.getHost(string);
            if ((n2 & 0xF) != n2) {
                throw new IllegalArgumentException("invalid actions mask");
            }
            this.mask = n2 | 8;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            String string2 = string;
            if (string.charAt(0) == '[') {
                n4 = 1;
                n3 = string.indexOf(93);
                if (n3 == -1) {
                    throw new IllegalArgumentException("invalid host/port: " + string);
                }
                string = string.substring(n4, n3);
                n6 = string.indexOf(58, n3 + 1);
            } else {
                n4 = 0;
                n5 = n6 = string.indexOf(58, n3);
                if (n6 != -1) {
                    string = string.substring(n4, n5);
                }
            }
            if (n6 != -1) {
                String string3 = string2.substring(n6 + 1);
                try {
                    this.portrange = this.parsePort(string3);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid port range: " + string3);
                }
            } else {
                this.portrange = new int[]{0, 65535};
            }
            this.hostname = string;
            if (string.lastIndexOf(42) > 0) {
                throw new IllegalArgumentException("invalid host wildcard specification");
            }
            if (string.startsWith("*")) {
                this.wildcard = true;
                if (string.equals("*")) {
                    this.cname = "";
                } else if (string.startsWith("*.")) {
                    this.cname = string.substring(1).toLowerCase();
                } else {
                    throw new IllegalArgumentException("invalid host wildcard specification");
                }
                return;
            }
            if (string.length() <= 0 || (c2 = string.charAt(0)) != ':' && Character.digit(c2, 16) == -1) break block20;
            byte[] byArray = Inet4Address.textToNumericFormat(string);
            if (byArray == null) {
                byArray = Inet6Address.textToNumericFormat(string);
            }
            if (byArray != null) {
                try {
                    this.addresses = new InetAddress[]{InetAddress.getByAddress(byArray)};
                    this.init_with_ip = true;
                }
                catch (UnknownHostException unknownHostException) {
                    this.invalid = true;
                }
            }
        }
    }

    boolean impliesIgnoreMask(SocketPermission socketPermission) {
        if ((socketPermission.mask & 8) != socketPermission.mask && (socketPermission.portrange[0] < this.portrange[0] || socketPermission.portrange[1] > this.portrange[1])) {
            return false;
        }
        if (this.wildcard && "".equals(this.cname)) {
            return true;
        }
        if (this.invalid || socketPermission.invalid) {
            return trustProxy ? this.inProxyWeTrust(socketPermission) : false;
        }
        try {
            if (this.init_with_ip) {
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.init_with_ip) {
                    return this.addresses[0].equals(socketPermission.addresses[0]);
                }
                if (socketPermission.addresses == null) {
                    socketPermission.getIP();
                }
                int n2 = 0;
                while (n2 < socketPermission.addresses.length) {
                    if (this.addresses[0].equals(socketPermission.addresses[n2])) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (this.wildcard || socketPermission.wildcard) {
                if (this.wildcard && socketPermission.wildcard) {
                    return socketPermission.cname.endsWith(this.cname);
                }
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return socketPermission.cname.endsWith(this.cname);
            }
            if (this.addresses == null) {
                this.getIP();
            }
            if (socketPermission.addresses == null) {
                socketPermission.getIP();
            }
            int n3 = 0;
            while (n3 < this.addresses.length) {
                int n4 = 0;
                while (n4 < socketPermission.addresses.length) {
                    if (this.addresses[n3].equals(socketPermission.addresses[n4])) {
                        return true;
                    }
                    ++n4;
                }
                ++n3;
            }
            if (this.cname == null) {
                this.getCanonName();
            }
            if (socketPermission.cname == null) {
                socketPermission.getCanonName();
            }
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        catch (UnknownHostException unknownHostException) {
            if (trustProxy) {
                return this.inProxyWeTrust(socketPermission);
            }
            return false;
        }
    }

    private boolean inProxyWeTrust(SocketPermission socketPermission) {
        String string = this.hostname;
        String string2 = socketPermission.hostname;
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        return (this.mask & socketPermission.mask) == socketPermission.mask && this.impliesIgnoreMask(socketPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private static String getHost(String string) {
        int n2;
        if (string.equals("")) {
            return "localhost";
        }
        if (string.charAt(0) != '[' && (n2 = string.indexOf(58)) != string.lastIndexOf(58)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n3 = stringTokenizer.countTokens();
            if (n3 == 9) {
                n2 = string.lastIndexOf(58);
                string = "[" + string.substring(0, n2) + "]" + string.substring(n2);
            } else if (n3 == 8 && string.indexOf("::") == -1) {
                string = "[" + string + "]";
            } else {
                throw new IllegalArgumentException("Ambiguous hostport part");
            }
        }
        return string;
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.getHost(string));
        this.init(string, SocketPermission.getMask(string2));
    }
}

