/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue;
    private static Finalizer unfinalized;
    private static Object lock;
    private Finalizer next = null;
    private Finalizer prev = null;

    static {
        ThreadGroup threadGroup;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        FinalizerThread finalizerThread = new FinalizerThread(threadGroup);
        finalizerThread.setPriority(8);
        finalizerThread.setDaemon(true);
        finalizerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Finalizer finalizer;
                    Object object = Finalizer.access$200();
                    synchronized (object) {
                        finalizer = Finalizer.access$300();
                        if (finalizer == null) {
                            break;
                        }
                        Finalizer.access$302(Finalizer.access$400(finalizer));
                    }
                    Finalizer.access$100(finalizer);
                }
            }
        });
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){

            public void run() {
                Finalizer finalizer;
                while ((finalizer = (Finalizer)Finalizer.access$000().poll()) != null) {
                    Finalizer.access$100(finalizer);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            Object object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    static Object access$200() {
        return lock;
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    static void register(Object object) {
        new Finalizer(object);
    }

    private static void forkSecondaryFinalizer(Runnable runnable) {
        PrivilegedAction privilegedAction = new PrivilegedAction(runnable){
            private final Runnable val$proc;

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                Thread thread = new Thread(threadGroup, this.val$proc, "Secondary finalizer");
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
            {
                this.val$proc = runnable;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    static Finalizer access$300() {
        return unfinalized;
    }

    static void access$100(Finalizer finalizer) {
        finalizer.runFinalizer();
    }

    static ReferenceQueue access$000() {
        return queue;
    }

    static Finalizer access$302(Finalizer finalizer) {
        unfinalized = finalizer;
        return unfinalized;
    }

    static Finalizer access$400(Finalizer finalizer) {
        return finalizer.next;
    }

    private static class FinalizerThread
    extends Thread {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)Finalizer.access$000().remove();
                        Finalizer.access$100(finalizer);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }
    }
}

