/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public class Package {
    private static Map pkgs = new HashMap(31);
    private static Map urls = new HashMap(10);
    private static Map mans = new HashMap(10);
    private String pkgName;
    private String specTitle;
    private String specVersion;
    private String specVendor;
    private String implTitle;
    private String implVersion;
    private String implVendor;
    private URL sealBase;

    public int hashCode() {
        return this.pkgName.hashCode();
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public static Package[] getPackages() {
        ClassLoader classLoader = ClassLoader.getCallerClassLoader();
        if (classLoader != null) {
            return classLoader.getPackages();
        }
        return Package.getSystemPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package[] getSystemPackages() {
        String[] stringArray = Package.getSystemPackages0();
        Map map = pkgs;
        synchronized (map) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                Package.defineSystemPackage(stringArray[n2], Package.getSystemPackage0(stringArray[n2]));
                ++n2;
            }
            return (Package[])pkgs.values().toArray(new Package[pkgs.size()]);
        }
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getName() {
        return this.pkgName;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String toString() {
        String string = this.specTitle;
        String string2 = this.specVersion;
        string = string != null && string.length() > 0 ? ", " + string : "";
        string2 = string2 != null && string2.length() > 0 ? ", version " + string2 : "";
        return "package " + this.pkgName + string + string2;
    }

    private static native String[] getSystemPackages0();

    public boolean isCompatibleWith(String string) throws NumberFormatException {
        if (this.specVersion == null || this.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.specVersion, ".", true);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            int n3 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            if (n3 < n2) {
                return false;
            }
            if (n3 > n2) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealBase);
    }

    static Map access$000() {
        return urls;
    }

    static Map access$200() {
        return mans;
    }

    static Map access$400() {
        return pkgs;
    }

    static Package getPackage(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(0, n2);
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.getPackage(string);
            }
            return Package.getSystemPackage(string);
        }
        return null;
    }

    public static Package getPackage(String string) {
        ClassLoader classLoader = ClassLoader.getCallerClassLoader();
        if (classLoader != null) {
            return classLoader.getPackage(string);
        }
        return Package.getSystemPackage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package getSystemPackage(String string) {
        Map map = pkgs;
        synchronized (map) {
            String string2;
            Package package_ = (Package)pkgs.get(string);
            if (package_ == null && (string2 = Package.getSystemPackage0(string = string.replace('.', '/').concat("/"))) != null) {
                package_ = Package.defineSystemPackage(string, string2);
            }
            return package_;
        }
    }

    private static native String getSystemPackage0(String var0);

    static Manifest access$100(String string) {
        return Package.loadManifest(string);
    }

    private static Manifest loadManifest(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            JarInputStream jarInputStream = new JarInputStream((InputStream)fileInputStream, false);
            Manifest manifest = jarInputStream.getManifest();
            jarInputStream.close();
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Package defineSystemPackage(String string, String string2) {
        return (Package)AccessController.doPrivileged(new PrivilegedAction(string, string2){
            private final String val$iname;
            private final String val$fn;

            public Object run() {
                Object object;
                String string = this.val$iname;
                URL uRL = (URL)Package.access$000().get(this.val$fn);
                if (uRL == null) {
                    object = new File(this.val$fn);
                    try {
                        uRL = ParseUtil.fileToEncodedURL((File)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL != null) {
                        Package.access$000().put(this.val$fn, uRL);
                        if (((File)object).isFile()) {
                            Package.access$200().put(this.val$fn, Package.access$100(this.val$fn));
                        }
                    }
                }
                string = string.substring(0, string.length() - 1).replace('/', '.');
                Manifest manifest = (Manifest)Package.access$200().get(this.val$fn);
                object = manifest != null ? new Package(string, manifest, uRL, null) : new Package(string, null, null, null, null, null, null, null);
                Package.access$400().put(string, object);
                return object;
            }
            {
                this.val$iname = string;
                this.val$fn = string2;
            }
        });
    }

    private Package(String string, Manifest manifest, URL uRL) {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (this.specTitle == null) {
                this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (this.specVersion == null) {
                this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (this.specVendor == null) {
                this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (this.implTitle == null) {
                this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (this.implVersion == null) {
                this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (this.implVendor == null) {
                this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string3)) {
            this.sealBase = uRL;
        }
        this.pkgName = string;
    }

    Package(String string, Manifest manifest, URL uRL, 1 var4_4) {
        this(string, manifest, uRL);
    }

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        this.pkgName = string;
        this.implTitle = string5;
        this.implVersion = string6;
        this.implVendor = string7;
        this.specTitle = string2;
        this.specVersion = string3;
        this.specVendor = string4;
        this.sealBase = uRL;
    }
}

