/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public final int size() {
        return this.written;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    private void incCount(int n2) {
        int n3 = this.written + n2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        this.written = n3;
    }

    public synchronized void write(int n2) throws IOException {
        this.out.write(n2);
        this.incCount(1);
    }

    public final void writeByte(int n2) throws IOException {
        this.out.write(n2);
        this.incCount(1);
    }

    public final void writeChar(int n2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int n2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n2 >>> 24 & 0xFF);
        outputStream.write(n2 >>> 16 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 >>> 0 & 0xFF);
        this.incCount(4);
    }

    public final void writeShort(int n2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeLong(long l2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l2 >>> 56) & 0xFF);
        outputStream.write((int)(l2 >>> 48) & 0xFF);
        outputStream.write((int)(l2 >>> 40) & 0xFF);
        outputStream.write((int)(l2 >>> 32) & 0xFF);
        outputStream.write((int)(l2 >>> 24) & 0xFF);
        outputStream.write((int)(l2 >>> 16) & 0xFF);
        outputStream.write((int)(l2 >>> 8) & 0xFF);
        outputStream.write((int)(l2 >>> 0) & 0xFF);
        this.incCount(8);
    }

    public final void writeBoolean(boolean bl2) throws IOException {
        this.out.write(bl2 ? 1 : 0);
        this.incCount(1);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.incCount(n3);
    }

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public final void writeBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            outputStream.write((byte)string.charAt(n3));
            ++n3;
        }
        this.incCount(n2);
    }

    public final void writeChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            outputStream.write(c2 >>> 8 & 0xFF);
            outputStream.write(c2 >>> 0 & 0xFF);
            ++n3;
        }
        this.incCount(n2 * 2);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        int n4 = 0;
        string.getChars(0, n2, cArray, 0);
        int n5 = 0;
        while (n5 < n2) {
            c2 = cArray[n5];
            n3 = c2 >= '\u0001' && c2 <= '\u007f' ? ++n3 : (c2 > '\u07ff' ? (n3 += 3) : (n3 += 2));
            ++n5;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n3 + 2];
        byArray[n4++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n4++] = (byte)(n3 >>> 0 & 0xFF);
        int n6 = 0;
        while (n6 < n2) {
            c2 = cArray[n6];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++n6;
        }
        dataOutput.write(byArray);
        return n3 + 2;
    }
}

