/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this.cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return this.cb[this.nextChar++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n2;
        int n3;
        if (this.markedChar <= -1) {
            n3 = 0;
        } else {
            n2 = this.nextChar - this.markedChar;
            if (n2 >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n3 = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, n2);
                    this.markedChar = 0;
                    n3 = n2;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, cArray, 0, n2);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n3 = n2;
                }
                this.nextChar = this.nChars = n2;
            }
        }
        while ((n2 = this.in.read(this.cb, n3, this.cb.length - n3)) == 0) {
        }
        if (n2 > 0) {
            this.nChars = n3 + n2;
            this.nextChar = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = n2;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            long l3 = l2;
            while (l3 > 0L) {
                long l4;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (l3 <= (l4 = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + l3);
                    l3 = 0L;
                    break;
                }
                l3 -= l4;
                this.nextChar = this.nChars;
            }
            return l2 - l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(char[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = this.lock;
        synchronized (var4_4) {
            this.ensureOpen();
            if (var2_2 < 0 || var2_2 > var1_1.length || var3_3 < 0 || var2_2 + var3_3 > var1_1.length || var2_2 + var3_3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (var3_3 == 0) {
                return 0;
            }
            var5_5 = this.read1(var1_1, var2_2, var3_3);
            if (var5_5 > 0) ** GOTO lbl14
            return var5_5;
            while ((var6_6 = this.read1(var1_1, var2_2 + var5_5, var3_3 - var5_5)) > 0) {
                var5_5 += var6_6;
lbl14:
                // 2 sources

                if (var5_5 < var3_3 && this.in.ready()) continue;
            }
            return var5_5;
        }
    }

    private int read1(char[] cArray, int n2, int n3) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (n3 >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cArray, n2, n3);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n4 = Math.min(n3, this.nChars - this.nextChar);
        System.arraycopy(this.cb, this.nextChar, cArray, n2, n4);
        this.nextChar += n4;
        return n4;
    }

    public BufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    public BufferedReader(Reader reader, int n2) {
        super(reader);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.cb = new char[n2];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    String readLine(boolean bl2) throws IOException {
        StringBuffer stringBuffer = null;
        boolean bl3 = bl2 || this.skipLF;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (stringBuffer != null && stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    return null;
                }
                boolean bl4 = false;
                char c2 = '\u0000';
                if (!bl3 || this.cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                bl3 = false;
                int n2 = ++this.nextChar;
                while (n2 < this.nChars) {
                    c2 = this.cb[n2];
                    if (c2 == '\n' || c2 == '\r') {
                        bl4 = true;
                        break;
                    }
                    ++n2;
                }
                int n3 = this.nextChar;
                this.nextChar = n2;
                if (bl4) {
                    String string;
                    if (stringBuffer == null) {
                        string = new String(this.cb, n3, n2 - n3);
                    } else {
                        stringBuffer.append(this.cb, n3, n2 - n3);
                        string = stringBuffer.toString();
                    }
                    ++this.nextChar;
                    if (c2 == '\r') {
                        this.skipLF = true;
                    }
                    return string;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(defaultExpectedLineLength);
                }
                stringBuffer.append(this.cb, n3, n2 - n3);
            }
        }
    }
}

