/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Enumeration;
import java.util.Vector;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    RenderableImage rdblImage;
    RenderContext rc;
    Vector ics = new Vector();

    public void run() {
        ImageConsumer imageConsumer;
        RenderedImage renderedImage = this.rc != null ? this.rdblImage.createRendering(this.rc) : this.rdblImage.createDefaultRendering();
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = renderedImage.getData();
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        Enumeration enumeration = this.ics.elements();
        while (enumeration.hasMoreElements()) {
            imageConsumer = (ImageConsumer)enumeration.nextElement();
            imageConsumer.setDimensions(n4, n5);
            imageConsumer.setHints(30);
        }
        int[] nArray = new int[n4];
        int n6 = sampleModel.getNumBands();
        int[] nArray2 = new int[n6];
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            while (n8 < n4) {
                sampleModel.getPixel(n8, n7, nArray2, dataBuffer);
                nArray[n8] = colorModel.getDataElement(nArray2, 0);
                ++n8;
            }
            enumeration = this.ics.elements();
            while (enumeration.hasMoreElements()) {
                imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setPixels(0, n7, n4, 1, colorModel, nArray, 0, n4);
            }
            ++n7;
        }
        enumeration = this.ics.elements();
        while (enumeration.hasMoreElements()) {
            imageConsumer = (ImageConsumer)enumeration.nextElement();
            imageConsumer.imageComplete(3);
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (!this.ics.contains(imageConsumer)) {
            this.ics.addElement(imageConsumer);
        }
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.ics.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        Thread thread = new Thread(this, "RenderableImageProducer Thread");
        thread.start();
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ics.contains(imageConsumer);
    }

    public synchronized void setRenderContext(RenderContext renderContext) {
        this.rc = renderContext;
    }

    public RenderableImageProducer(RenderableImage renderableImage, RenderContext renderContext) {
        this.rdblImage = renderableImage;
        this.rc = renderContext;
    }
}

