/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    public final int getDataType() {
        return this.dataType;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public int getTransferType() {
        return this.dataType;
    }

    public final int getWidth() {
        return this.width;
    }

    static {
        ColorModel.loadLibraries();
        SampleModel.initIDs();
    }

    private static native void initIDs();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);

    public SampleModel(int n2, int n3, int n4, int n5) {
        float f2 = (float)n3 * (float)n4;
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Width (" + n3 + ") and height (" + n4 + ") must be > 0");
        }
        if (f2 >= 2.1474836E9f) {
            throw new IllegalArgumentException("Dimensions (width=" + n3 + " height=" + n4 + ") are too large");
        }
        if (n2 < 0 || n2 > 5 && n2 != 32) {
            throw new IllegalArgumentException("Unsupported dataType: " + n2);
        }
        if (n5 <= 0) {
            throw new IllegalArgumentException("Number of bands must be > 0");
        }
        this.dataType = n2;
        this.width = n3;
        this.height = n4;
        this.numBands = n5;
    }

    public abstract DataBuffer createDataBuffer();

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        int n5 = (int)d2;
        this.setSample(n2, n3, n4, n5, dataBuffer);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        int n5 = (int)f2;
        this.setSample(n2, n3, n4, n5, dataBuffer);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray, DataBuffer dataBuffer) {
        int n7 = 0;
        int n8 = n3;
        while (n8 < n3 + n5) {
            int n9 = n2;
            while (n9 < n2 + n4) {
                this.setSample(n9, n8, n6, dArray[n7++], dataBuffer);
                ++n9;
            }
            ++n8;
        }
    }

    public double[] getSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray, DataBuffer dataBuffer) {
        int n7 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[n4 * n5];
        int n8 = n3;
        while (n8 < n3 + n5) {
            int n9 = n2;
            while (n9 < n2 + n4) {
                dArray2[n7++] = this.getSampleDouble(n9, n8, n6, dataBuffer);
                ++n9;
            }
            ++n8;
        }
        return dArray2;
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray, DataBuffer dataBuffer) {
        int n7 = 0;
        int n8 = n3;
        while (n8 < n3 + n5) {
            int n9 = n2;
            while (n9 < n2 + n4) {
                this.setSample(n9, n8, n6, fArray[n7++], dataBuffer);
                ++n9;
            }
            ++n8;
        }
    }

    public float[] getSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray, DataBuffer dataBuffer) {
        int n7 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[n4 * n5];
        int n8 = n3;
        while (n8 < n5 + n3) {
            int n9 = n2;
            while (n9 < n4 + n2) {
                fArray2[n7++] = this.getSampleFloat(n9, n8, n6, dataBuffer);
                ++n9;
            }
            ++n8;
        }
        return fArray2;
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        int n7 = 0;
        int n8 = n3;
        while (n8 < n3 + n5) {
            int n9 = n2;
            while (n9 < n2 + n4) {
                this.setSample(n9, n8, n6, nArray[n7++], dataBuffer);
                ++n9;
            }
            ++n8;
        }
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        int n7 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n8 = n3;
        while (n8 < n5 + n3) {
            int n9 = n2;
            while (n9 < n4 + n2) {
                nArray2[n7++] = this.getSample(n9, n8, n6, dataBuffer);
                ++n9;
            }
            ++n8;
        }
        return nArray2;
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setPixels(int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n3;
        while (n7 < n3 + n5) {
            int n8 = n2;
            while (n8 < n2 + n4) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    this.setSample(n8, n7, n9, dArray[n6++], dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
    }

    public double[] getPixels(int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n4 * n5];
        int n7 = n3;
        while (n7 < n5 + n3) {
            int n8 = n2;
            while (n8 < n4 + n2) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    dArray2[n6++] = this.getSampleDouble(n8, n7, n9, dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        return dArray2;
    }

    public void setPixels(int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n3;
        while (n7 < n3 + n5) {
            int n8 = n2;
            while (n8 < n2 + n4) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    this.setSample(n8, n7, n9, fArray[n6++], dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
    }

    public float[] getPixels(int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands * n4 * n5];
        int n7 = n3;
        while (n7 < n5 + n3) {
            int n8 = n2;
            while (n8 < n4 + n2) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    fArray2[n6++] = this.getSampleFloat(n8, n7, n9, dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        return fArray2;
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n3;
        while (n7 < n3 + n5) {
            int n8 = n2;
            while (n8 < n2 + n4) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    this.setSample(n8, n7, n9, nArray[n6++], dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands * n4 * n5];
        int n7 = n3;
        while (n7 < n5 + n3) {
            int n8 = n2;
            while (n8 < n4 + n2) {
                int n9 = 0;
                while (n9 < this.numBands) {
                    nArray2[n6++] = this.getSample(n8, n7, n9, dataBuffer);
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        return nArray2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        double d2 = this.getSample(n2, n3, n4, dataBuffer);
        return d2;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        float f2 = this.getSample(n2, n3, n4, dataBuffer);
        return f2;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public void setPixel(int n2, int n3, double[] dArray, DataBuffer dataBuffer) {
        int n4 = 0;
        while (n4 < this.numBands) {
            this.setSample(n2, n3, n4, dArray[n4], dataBuffer);
            ++n4;
        }
    }

    public double[] getPixel(int n2, int n3, double[] dArray, DataBuffer dataBuffer) {
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands];
        int n4 = 0;
        while (n4 < this.numBands) {
            dArray2[n4] = this.getSampleDouble(n2, n3, n4, dataBuffer);
            ++n4;
        }
        return dArray2;
    }

    public void setPixel(int n2, int n3, float[] fArray, DataBuffer dataBuffer) {
        int n4 = 0;
        while (n4 < this.numBands) {
            this.setSample(n2, n3, n4, fArray[n4], dataBuffer);
            ++n4;
        }
    }

    public float[] getPixel(int n2, int n3, float[] fArray, DataBuffer dataBuffer) {
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands];
        int n4 = 0;
        while (n4 < this.numBands) {
            fArray2[n4] = this.getSampleFloat(n2, n3, n4, dataBuffer);
            ++n4;
        }
        return fArray2;
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        int n4 = 0;
        while (n4 < this.numBands) {
            this.setSample(n2, n3, n4, nArray[n4], dataBuffer);
            ++n4;
        }
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray2[n4] = this.getSample(n2, n3, n4, dataBuffer);
            ++n4;
        }
        return nArray2;
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public void setDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = 0;
        Object var8_8 = null;
        int n7 = this.getTransferType();
        int n8 = this.getNumDataElements();
        switch (n7) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n8];
                int n9 = n3;
                while (n9 < n3 + n5) {
                    int n10 = n2;
                    while (n10 < n2 + n4) {
                        int n11 = 0;
                        while (n11 < n8) {
                            byArray2[n11] = byArray[n6++];
                            ++n11;
                        }
                        this.setDataElements(n10, n9, byArray2, dataBuffer);
                        ++n10;
                    }
                    ++n9;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n8];
                int n12 = n3;
                while (n12 < n3 + n5) {
                    int n13 = n2;
                    while (n13 < n2 + n4) {
                        int n14 = 0;
                        while (n14 < n8) {
                            sArray2[n14] = sArray[n6++];
                            ++n14;
                        }
                        this.setDataElements(n13, n12, sArray2, dataBuffer);
                        ++n13;
                    }
                    ++n12;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n8];
                int n15 = n3;
                while (n15 < n3 + n5) {
                    int n16 = n2;
                    while (n16 < n2 + n4) {
                        int n17 = 0;
                        while (n17 < n8) {
                            nArray2[n17] = nArray[n6++];
                            ++n17;
                        }
                        this.setDataElements(n16, n15, nArray2, dataBuffer);
                        ++n16;
                    }
                    ++n15;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n8];
                int n18 = n3;
                while (n18 < n3 + n5) {
                    int n19 = n2;
                    while (n19 < n2 + n4) {
                        int n20 = 0;
                        while (n20 < n8) {
                            fArray2[n20] = fArray[n6++];
                            ++n20;
                        }
                        this.setDataElements(n19, n18, fArray2, dataBuffer);
                        ++n19;
                    }
                    ++n18;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n8];
                int n21 = n3;
                while (n21 < n3 + n5) {
                    int n22 = n2;
                    while (n22 < n2 + n4) {
                        int n23 = 0;
                        while (n23 < n8) {
                            dArray2[n23] = dArray[n6++];
                            ++n23;
                        }
                        this.setDataElements(n22, n21, dArray2, dataBuffer);
                        ++n22;
                    }
                    ++n21;
                }
                break;
            }
        }
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object, DataBuffer dataBuffer) {
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        int n8 = 0;
        Object object2 = null;
        switch (n6) {
            case 0: {
                byte[] byArray = object == null ? new byte[n7 * n4 * n5] : (byte[])object;
                int n9 = n3;
                while (n9 < n3 + n5) {
                    int n10 = n2;
                    while (n10 < n2 + n4) {
                        object2 = this.getDataElements(n10, n9, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        int n11 = 0;
                        while (n11 < n7) {
                            byArray[n8++] = byArray2[n11];
                            ++n11;
                        }
                        ++n10;
                    }
                    ++n9;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n7 * n4 * n5] : (short[])object;
                int n12 = n3;
                while (n12 < n3 + n5) {
                    int n13 = n2;
                    while (n13 < n2 + n4) {
                        object2 = this.getDataElements(n13, n12, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        int n14 = 0;
                        while (n14 < n7) {
                            sArray[n8++] = sArray2[n14];
                            ++n14;
                        }
                        ++n13;
                    }
                    ++n12;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n7 * n4 * n5] : (int[])object;
                int n15 = n3;
                while (n15 < n3 + n5) {
                    int n16 = n2;
                    while (n16 < n2 + n4) {
                        object2 = this.getDataElements(n16, n15, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        int n17 = 0;
                        while (n17 < n7) {
                            nArray[n8++] = nArray2[n17];
                            ++n17;
                        }
                        ++n16;
                    }
                    ++n15;
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n7 * n4 * n5] : (float[])object;
                int n18 = n3;
                while (n18 < n3 + n5) {
                    int n19 = n2;
                    while (n19 < n2 + n4) {
                        object2 = this.getDataElements(n19, n18, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        int n20 = 0;
                        while (n20 < n7) {
                            fArray[n8++] = fArray2[n20];
                            ++n20;
                        }
                        ++n19;
                    }
                    ++n18;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n7 * n4 * n5] : (double[])object;
                int n21 = n3;
                while (n21 < n3 + n5) {
                    int n22 = n2;
                    while (n22 < n2 + n4) {
                        object2 = this.getDataElements(n22, n21, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        int n23 = 0;
                        while (n23 < n7) {
                            dArray[n8++] = dArray2[n23];
                            ++n23;
                        }
                        ++n22;
                    }
                    ++n21;
                }
                object = dArray;
            }
        }
        return object;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);
}

