/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    private static final int STRING = 0;
    private static final int PLAIN_TEXT = 1;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String data;

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n2 = 0;
        while (n2 < flavors.length) {
            if (dataFlavor.equals(flavors[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public StringSelection(String string) {
        this.data = string;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[0])) {
            return this.data;
        }
        if (dataFlavor.equals(flavors[1])) {
            return new StringReader(this.data);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

