/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import sun.awt.color.ICC_Transform;

public class ICC_ColorSpace
extends ColorSpace {
    static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit = true;
    private transient ICC_Transform this2srgb;
    private transient ICC_Transform srgb2this;
    private transient ICC_Transform this2xyz;
    private transient ICC_Transform xyz2this;

    private void setComponentScaling() {
        int n2 = this.getNumComponents();
        this.diffMinMax = new float[n2];
        this.invDiffMinMax = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.minVal[n3] = this.getMinValue(n3);
            this.maxVal[n3] = this.getMaxValue(n3);
            this.diffMinMax[n3] = this.maxVal[n3] - this.minVal[n3];
            this.invDiffMinMax[n3] = 65535.0f / this.diffMinMax[n3];
            ++n3;
        }
        this.needScaleInit = false;
    }

    private void setMinMax() {
        int n2 = this.getNumComponents();
        int n3 = this.getType();
        this.minVal = new float[n2];
        this.maxVal = new float[n2];
        if (n3 == 1) {
            this.minVal[0] = 0.0f;
            this.maxVal[0] = 100.0f;
            this.minVal[1] = -128.0f;
            this.maxVal[1] = 127.0f;
            this.minVal[2] = -128.0f;
            this.maxVal[2] = 127.0f;
        } else if (n3 == 0) {
            this.minVal[2] = 0.0f;
            this.minVal[1] = 0.0f;
            this.minVal[0] = 0.0f;
            this.maxVal[2] = 1.9999695f;
            this.maxVal[1] = 1.9999695f;
            this.maxVal[0] = 1.9999695f;
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.minVal[n4] = 0.0f;
                this.maxVal[n4] = 1.0f;
                ++n4;
            }
        }
    }

    public float getMaxValue(int n2) {
        if (n2 < 0 || n2 > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.maxVal[n2];
    }

    public float getMinValue(int n2) {
        if (n2 < 0 || n2 > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.minVal[n2];
    }

    public float[] fromCIEXYZ(float[] fArray) {
        ICC_Transform[] iCC_TransformArray;
        if (this.xyz2this == null) {
            iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            try {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, 1, 2);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            }
            this.xyz2this = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        iCC_TransformArray = (ICC_Transform[])new short[3];
        float f2 = 1.9999695f;
        float f3 = 65535.0f / f2;
        int n2 = 0;
        while (n2 < 3) {
            iCC_TransformArray[n2] = (ICC_Transform)((short)(fArray[n2] * f3 + 0.5f));
            ++n2;
        }
        iCC_TransformArray = (ICC_Transform[])this.xyz2this.colorConvert((short[])iCC_TransformArray, null);
        int n3 = this.getNumComponents();
        float[] fArray2 = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray2[n4] = (float)(iCC_TransformArray[n4] & 0xFFFF) / 65535.0f * this.diffMinMax[n4] + this.minVal[n4];
            ++n4;
        }
        return fArray2;
    }

    public float[] fromRGB(float[] fArray) {
        ICC_Transform[] iCC_TransformArray;
        if (this.srgb2this == null) {
            iCC_TransformArray = new ICC_Transform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(this.thisProfile, -1, 2);
            this.srgb2this = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        iCC_TransformArray = (ICC_Transform[])new short[3];
        int n2 = 0;
        while (n2 < 3) {
            iCC_TransformArray[n2] = (ICC_Transform)((short)(fArray[n2] * 65535.0f + 0.5f));
            ++n2;
        }
        iCC_TransformArray = (ICC_Transform[])this.srgb2this.colorConvert((short[])iCC_TransformArray, null);
        int n3 = this.getNumComponents();
        float[] fArray2 = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray2[n4] = (float)(iCC_TransformArray[n4] & 0xFFFF) / 65535.0f * this.diffMinMax[n4] + this.minVal[n4];
            ++n4;
        }
        return fArray2;
    }

    public float[] toCIEXYZ(float[] fArray) {
        Object object;
        if (this.this2xyz == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            try {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, 1, 1);
            }
            catch (CMMException cMMException) {
                iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            }
            iCC_TransformArray[1] = new ICC_Transform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2xyz = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n2 = this.getNumComponents();
        object = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            object[n3] = (short)((fArray[n3] - this.minVal[n3]) * this.invDiffMinMax[n3] + 0.5f);
            ++n3;
        }
        object = this.this2xyz.colorConvert((short[])object, null);
        float f2 = 1.9999695f;
        float[] fArray2 = new float[3];
        int n4 = 0;
        while (n4 < 3) {
            fArray2[n4] = (float)(object[n4] & 0xFFFF) / 65535.0f * f2;
            ++n4;
        }
        return fArray2;
    }

    public float[] toRGB(float[] fArray) {
        Object object;
        if (this.this2srgb == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            iCC_TransformArray[0] = new ICC_Transform(this.thisProfile, -1, 1);
            iCC_TransformArray[1] = new ICC_Transform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2srgb = new ICC_Transform(iCC_TransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n2 = this.getNumComponents();
        object = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            object[n3] = (short)((fArray[n3] - this.minVal[n3]) * this.invDiffMinMax[n3] + 0.5f);
            ++n3;
        }
        object = this.this2srgb.colorConvert((short[])object, null);
        float[] fArray2 = new float[3];
        int n4 = 0;
        while (n4 < 3) {
            fArray2[n4] = (float)(object[n4] & 0xFFFF) / 65535.0f;
            ++n4;
        }
        return fArray2;
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(iCC_Profile.getColorSpaceType(), iCC_Profile.getNumComponents());
        int n2 = iCC_Profile.getProfileClass();
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 4 && n2 != 6) {
            throw new IllegalArgumentException("Invalid profile type");
        }
        this.thisProfile = iCC_Profile;
        this.setMinMax();
    }
}

