/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.im.InputContext;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.DebugHelper;
import sun.security.action.GetPropertyAction;

public class Window
extends Container
implements Accessible {
    String warningString;
    static boolean systemSyncLWRequests = false;
    boolean syncLWRequests = false;
    boolean isFirstPack = true;
    static final int OPENED = 1;
    int state;
    transient Vector ownedWindowList = new Vector();
    private transient WeakReference weakThis;
    private transient boolean showWithParent = false;
    transient WindowListener windowListener;
    transient WindowStateListener windowStateListener;
    transient WindowFocusListener windowFocusListener;
    transient InputContext inputContext;
    private transient Object inputContextLock = new Object();
    private FocusManager focusMgr;
    private boolean focusableWindowState = true;
    private static final String base = "win";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 4497834738069338734L;
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$Window == null ? (class$java$awt$Window = Window.class$("java.awt.Window")) : class$java$awt$Window);
    private int windowSerializedDataVersion = 2;
    static Class class$java$awt$Window;
    static Class class$java$awt$event$WindowListener;
    static Class class$java$awt$event$WindowFocusListener;
    static Class class$java$awt$event$WindowStateListener;

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Window.initIDs();
        }
        systemSyncLWRequests = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean("true".equals(System.getProperty("java.awt.syncLWRequests", "false")));
            }
        });
    }

    Window() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = this.parent;
            if (container != null && container.getPeer() == null) {
                container.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createWindow(this);
            }
            super.addNotify();
        }
    }

    final void clearMostRecentFocusOwnerOnHide() {
    }

    public void dispose() {
        class DisposeAction
        implements Runnable {
            private final Window this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = this.this$0.ownedWindowList;
                synchronized (vector) {
                    int n2 = 0;
                    while (n2 < this.this$0.ownedWindowList.size()) {
                        Window window = (Window)((WeakReference)this.this$0.ownedWindowList.elementAt(n2)).get();
                        if (window != null) {
                            window.dispose();
                        }
                        ++n2;
                    }
                }
                this.this$0.setVisible(false);
                this.this$0.removeNotify();
                Object object = Window.access$000(this.this$0);
                synchronized (object) {
                    if (this.this$0.inputContext != null) {
                        this.this$0.inputContext.dispose();
                        this.this$0.inputContext = null;
                    }
                }
                this.this$0.clearCurrentFocusCycleRootOnHide();
            }

            DisposeAction(Window window) {
                this.this$0 = window;
            }
        }
        DisposeAction disposeAction = new DisposeAction(this);
        if (EventQueue.isDispatchThread()) {
            disposeAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(disposeAction);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Disposal was interrupted:");
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Exception during disposal:");
                invocationTargetException.printStackTrace();
            }
        }
        this.postWindowEvent(202);
    }

    protected void finalize() throws Throwable {
        if (this.parent != null) {
            ((Window)this.parent).removeOwnedWindow(this.weakThis);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.ownedWindowList.size()) {
                Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(n2)).get();
                if (window != null && window.visible) {
                    window.hide();
                    window.showWithParent = true;
                }
                ++n2;
            }
        }
        super.hide();
    }

    private static native void initIDs();

    public void pack() {
        Container container = this.parent;
        if (container != null && container.getPeer() == null) {
            container.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        if (this.isFirstPack) {
            this.isPacked = true;
            this.isFirstPack = false;
        }
        this.validate();
    }

    void resetGC() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setGCFromPeer();
            if (this.graphicsConfig == null) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
        }
    }

    private void setWarningString() {
        this.warningString = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = (String)AccessController.doPrivileged(new GetPropertyAction("awt.appletWarning", "Java Applet Window"));
        }
    }

    public void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.visible) {
            this.toFront();
        } else {
            super.show();
            int n2 = 0;
            while (n2 < this.ownedWindowList.size()) {
                Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(n2)).get();
                if (window != null && window.showWithParent) {
                    window.show();
                    window.showWithParent = false;
                }
                ++n2;
            }
        }
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    public void toBack() {
        WindowPeer windowPeer;
        if (this.visible && (windowPeer = (WindowPeer)this.peer) != null) {
            windowPeer.toBack();
        }
    }

    public void toFront() {
        WindowPeer windowPeer;
        if (this.visible && (windowPeer = (WindowPeer)this.peer) != null) {
            windowPeer.toFront();
        }
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public boolean isActive() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == this;
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        if (this instanceof Frame || this instanceof Dialog) {
            return true;
        }
        if (this.getFocusTraversalPolicy().getDefaultComponent(this) == null) {
            return false;
        }
        Window window = this.getOwner();
        while (window != null) {
            if (window instanceof Frame || window instanceof Dialog) {
                return window.isShowing();
            }
            window = window.getOwner();
        }
        return false;
    }

    public boolean isFocused() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == this;
    }

    public boolean isShowing() {
        return this.visible;
    }

    void adjustDecendantsOnParent(int n2) {
    }

    public void createBufferStrategy(int n2) {
        super.createBufferStrategy(n2);
    }

    synchronized void postWindowEvent(int n2) {
        if (this.windowListener != null || (this.eventMask & 0x40L) != 0L || Toolkit.enabledOnToolkit(64L)) {
            WindowEvent windowEvent = new WindowEvent(this, n2);
            Toolkit.getEventQueue().postEvent(windowEvent);
        }
    }

    void adjustListeningChildrenOnParent(long l2, int n2) {
    }

    public final void setFocusCycleRoot(boolean bl2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusableWindowState(boolean bl2) {
        boolean bl3;
        Window window = this;
        synchronized (window) {
            bl3 = this.focusableWindowState;
            this.focusableWindowState = bl2;
        }
        this.firePropertyChange("focusableWindowState", bl3, bl2);
        if (bl3 && !bl2 && this.isFocused()) {
            Window window2 = (Window)this.getParent();
            while (window2 != null) {
                Component component = KeyboardFocusManager.getMostRecentFocusOwner(window2);
                if (component != null && component.requestFocus(false)) {
                    return;
                }
                window2 = (Window)window2.getParent();
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 101) {
            this.invalidate();
            this.validate();
        }
        super.dispatchEventImpl(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            switch (aWTEvent.getID()) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    this.processWindowEvent((WindowEvent)aWTEvent);
                    break;
                }
                case 207: 
                case 208: {
                    this.processWindowFocusEvent((WindowEvent)aWTEvent);
                    break;
                }
                case 209: {
                    this.processWindowStateEvent((WindowEvent)aWTEvent);
                }
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
            case 207: 
            case 208: {
                return (this.eventMask & 0x80000L) != 0L || this.windowFocusListener != null;
            }
            case 209: {
                return (this.eventMask & 0x40000L) != 0L || this.windowStateListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    public void createBufferStrategy(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        super.createBufferStrategy(n2, bufferCapabilities);
    }

    public Component getFocusOwner() {
        return this.isFocused() ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() : null;
    }

    public Component getMostRecentFocusOwner() {
        if (this.isFocused()) {
            return this.getFocusOwner();
        }
        Component component = KeyboardFocusManager.getMostRecentFocusOwner(this);
        if (component != null) {
            return component;
        }
        return this.isFocusableWindow() ? this.getFocusTraversalPolicy().getInitialComponent(this) : null;
    }

    public void setLocationRelativeTo(Component component) {
        Serializable serializable;
        Serializable serializable2 = null;
        if (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                serializable2 = (Container)component;
            } else {
                serializable = component.getParent();
                while (serializable != null) {
                    if (serializable instanceof Window || serializable instanceof Applet) {
                        serializable2 = serializable;
                        break;
                    }
                    serializable = ((Component)serializable).getParent();
                }
            }
        }
        if (component != null && !component.isShowing() || serializable2 == null || !serializable2.isShowing()) {
            serializable = this.getSize();
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - ((Dimension)serializable).width) / 2, (dimension.height - ((Dimension)serializable).height) / 2);
        } else {
            Serializable serializable3;
            Point point;
            serializable = component.getSize();
            if (serializable2 instanceof Applet) {
                point = component.getLocationOnScreen();
            } else {
                point = new Point(0, 0);
                serializable3 = component;
                while (serializable3 != null) {
                    Point point2 = ((Component)serializable3).getLocation();
                    point.x += point2.x;
                    point.y += point2.y;
                    if (serializable3 == serializable2) break;
                    serializable3 = ((Component)serializable3).getParent();
                }
            }
            serializable3 = this.getBounds();
            int n2 = point.x + (((Dimension)serializable).width - ((Rectangle)serializable3).width >> 1);
            int n3 = point.y + (((Dimension)serializable).height - ((Rectangle)serializable3).height >> 1);
            Dimension dimension = this.getToolkit().getScreenSize();
            if (n3 + ((Rectangle)serializable3).height > dimension.height) {
                n3 = dimension.height - ((Rectangle)serializable3).height;
                int n4 = n2 = point.x < dimension.width >> 1 ? point.x + ((Dimension)serializable).width : point.x - ((Rectangle)serializable3).width;
            }
            if (n2 + ((Rectangle)serializable3).width > dimension.width) {
                n2 = dimension.width - ((Rectangle)serializable3).width;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.setLocation(n2, n3);
        }
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(0);
        }
        super.setCursor(cursor);
    }

    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        return false;
    }

    public Window(Frame frame) {
        this(frame == null ? (GraphicsConfiguration)null : frame.getGraphicsConfiguration());
        this.ownedInit(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig == null && !GraphicsEnvironment.isHeadless()) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            return this.graphicsConfig;
        }
    }

    Window(GraphicsConfiguration graphicsConfiguration) {
        this.init(graphicsConfiguration);
    }

    private void init(GraphicsConfiguration graphicsConfiguration) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException("headless environment");
        }
        this.syncLWRequests = systemSyncLWRequests;
        this.setWarningString();
        this.cursor = Cursor.getPredefinedCursor(0);
        this.visible = false;
        this.graphicsConfig = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : graphicsConfiguration;
        if (this.graphicsConfig.getDevice().getType() != 0) {
            throw new IllegalArgumentException("not a screen device");
        }
        this.setLayout(new BorderLayout());
        Rectangle rectangle = this.graphicsConfig.getBounds();
        Insets insets = this.getToolkit().getScreenInsets(this.graphicsConfig);
        int n2 = this.getX() + rectangle.x + insets.left;
        int n3 = this.getY() + rectangle.y + insets.top;
        this.setLocation(n2, n3);
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getOwnedWindows() {
        Window[] windowArray;
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n2 = this.ownedWindowList.size();
            int n3 = 0;
            Window[] windowArray2 = new Window[n2];
            int n4 = 0;
            while (n4 < n2) {
                windowArray2[n3] = (Window)((WeakReference)this.ownedWindowList.elementAt(n4)).get();
                if (windowArray2[n3] != null) {
                    ++n3;
                }
                ++n4;
            }
            if (n2 != n3) {
                windowArray = new Window[n3];
                System.arraycopy(windowArray2, 0, windowArray, 0, n3);
            } else {
                windowArray = windowArray2;
            }
        }
        return windowArray;
    }

    public Window(Window window) {
        this(window == null ? (GraphicsConfiguration)null : window.getGraphicsConfiguration());
        this.ownedInit(window);
    }

    void connectOwnedWindow(Window window) {
        WeakReference weakReference;
        window.weakThis = weakReference = new WeakReference(window);
        window.parent = this;
        this.addOwnedWindow(weakReference);
    }

    private void ownedInit(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("null owner window");
        }
        this.parent = window;
        this.weakThis = new WeakReference(this);
        window.addOwnedWindow(this.weakThis);
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getID() == 401) {
            this.list(System.out, 0);
        }
    }

    void deliverMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
    }

    boolean dispatchMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowFocusEvent(WindowEvent windowEvent) {
        if (this.windowFocusListener != null) {
            switch (windowEvent.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(windowEvent);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent windowEvent) {
        if (this.windowStateListener != null) {
            switch (windowEvent.getID()) {
                case 209: {
                    this.windowStateListener.windowStateChanged(windowEvent);
                    break;
                }
            }
        }
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])this.getListeners(class$java$awt$event$WindowFocusListener == null ? (class$java$awt$event$WindowFocusListener = Window.class$("java.awt.event.WindowFocusListener")) : class$java$awt$event$WindowFocusListener);
    }

    public synchronized void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        if (windowFocusListener == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, windowFocusListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        if (windowFocusListener == null) {
            return;
        }
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, windowFocusListener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])this.getListeners(class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = Window.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener);
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.newEventsOnly = true;
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])this.getListeners(class$java$awt$event$WindowStateListener == null ? (class$java$awt$event$WindowStateListener = Window.class$("java.awt.event.WindowStateListener")) : class$java$awt$event$WindowStateListener);
    }

    public synchronized void addWindowStateListener(WindowStateListener windowStateListener) {
        if (windowStateListener == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, windowStateListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowStateListener(WindowStateListener windowStateListener) {
        if (windowStateListener == null) {
            return;
        }
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, windowStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputContext getInputContext() {
        if (this.inputContext == null) {
            Object object = this.inputContextLock;
            synchronized (object) {
                if (this.inputContext == null) {
                    this.inputContext = InputContext.getInstance();
                }
            }
        }
        return this.inputContext;
    }

    public BufferStrategy getBufferStrategy() {
        return super.getBufferStrategy();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        String string;
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        if (this.windowSerializedDataVersion < 2) {
            if (this.focusMgr != null && this.focusMgr.focusOwner != null) {
                KeyboardFocusManager.setMostRecentFocusOwner(this, this.focusMgr.focusOwner);
            }
            this.focusableWindowState = true;
        }
        this.focusMgr = null;
        this.ownedWindowList = new Vector();
        while (null != (object = objectInputStream.readObject())) {
            string = ((String)object).intern();
            if ("windowL" == string) {
                this.addWindowListener((WindowListener)objectInputStream.readObject());
                continue;
            }
            if ("windowFocusL" == string) {
                this.addWindowFocusListener((WindowFocusListener)objectInputStream.readObject());
                continue;
            }
            if ("windowStateL" == string) {
                this.addWindowStateListener((WindowStateListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        try {
            while (null != (object = objectInputStream.readObject())) {
                string = ((String)object).intern();
                if ("ownedL" == string) {
                    this.connectOwnedWindow((Window)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.setWarningString();
        this.inputContextLock = new Object();
        this.visible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Window window = this;
        synchronized (window) {
            this.focusMgr = new FocusManager();
            this.focusMgr.focusRoot = this;
            this.focusMgr.focusOwner = this.getMostRecentFocusOwner();
            objectOutputStream.defaultWriteObject();
            this.focusMgr = null;
            AWTEventMulticaster.save(objectOutputStream, "windowL", this.windowListener);
            AWTEventMulticaster.save(objectOutputStream, "windowFocusL", this.windowFocusListener);
            AWTEventMulticaster.save(objectOutputStream, "windowStateL", this.windowStateListener);
        }
        objectOutputStream.writeObject(null);
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.ownedWindowList.size()) {
                Window window2 = (Window)((WeakReference)this.ownedWindowList.elementAt(n2)).get();
                if (window2 != null) {
                    objectOutputStream.writeObject("ownedL");
                    objectOutputStream.writeObject(window2);
                }
                ++n2;
            }
        }
        objectOutputStream.writeObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public void applyResourceBundle(String string) {
        this.applyResourceBundle(ResourceBundle.getBundle(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            Vector vector = this.ownedWindowList;
            synchronized (vector) {
                if (!this.ownedWindowList.contains(weakReference)) {
                    this.ownedWindowList.addElement(weakReference);
                }
            }
        }
    }

    void removeOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            this.ownedWindowList.removeElement(weakReference);
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(resourceBundle));
    }

    public Set getFocusTraversalKeys(int n2) {
        Set set;
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        Set set2 = set = this.focusTraversalKeys != null ? this.focusTraversalKeys[n2] : null;
        if (set != null) {
            return set;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow(this);
        }
        return this.accessibleContext;
    }

    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this(graphicsConfiguration);
        this.ownedInit(window);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static Object access$000(Window window) {
        return window.inputContextLock;
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener eventListener = null;
        if (clazz == (class$java$awt$event$WindowFocusListener == null ? (class$java$awt$event$WindowFocusListener = Window.class$("java.awt.event.WindowFocusListener")) : class$java$awt$event$WindowFocusListener)) {
            eventListener = this.windowFocusListener;
        } else if (clazz == (class$java$awt$event$WindowStateListener == null ? (class$java$awt$event$WindowStateListener = Window.class$("java.awt.event.WindowStateListener")) : class$java$awt$event$WindowStateListener)) {
            eventListener = this.windowStateListener;
        } else if (clazz == (class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = Window.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener)) {
            eventListener = this.windowListener;
        } else {
            return super.getListeners(clazz);
        }
        return AWTEventMulticaster.getListeners(eventListener, clazz);
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private final Window this$0;

        protected AccessibleAWTWindow(Window window) {
            this.this$0 = window;
            super(window);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

