/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class TextField
extends TextComponent {
    int columns;
    char echoChar;
    transient ActionListener actionListener;
    private static final String base = "textfield";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -2966288784432217853L;
    private int textFieldSerializedDataVersion = 1;
    static Class class$java$awt$event$ActionListener;

    public char getEchoChar() {
        return this.echoChar;
    }

    public int getColumns() {
        return this.columns;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            TextField.initIDs();
        }
    }

    public TextField() throws HeadlessException {
        this("", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextField(this);
            }
            super.addNotify();
        }
    }

    private static native void initIDs();

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public void setEchoChar(char c2) {
        this.setEchoCharacter(c2);
    }

    public synchronized void setEchoCharacter(char c2) {
        if (this.echoChar != c2) {
            this.echoChar = c2;
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            if (textFieldPeer != null) {
                textFieldPeer.setEchoCharacter(c2);
            }
        }
    }

    public TextField(int n2) throws HeadlessException {
        this("", n2);
    }

    public synchronized void setColumns(int n2) {
        int n3 = this.columns;
        if (n2 < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n2 != n3) {
            this.columns = n2;
            this.invalidate();
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.columns > 0 ? this.minimumSize(this.columns) : super.minimumSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.columns > 0 ? this.preferredSize(this.columns) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            return textFieldPeer != null ? textFieldPeer.minimumSize(n2) : super.minimumSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            return textFieldPeer != null ? textFieldPeer.preferredSize(n2) : super.preferredSize();
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TextField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        objectInputStream.defaultReadObject();
        if (this.columns < 0) {
            this.columns = 0;
        }
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.echoChar != '\u0000') {
            string = string + ",echo=" + this.echoChar;
        }
        return string;
    }

    public TextField(String string) throws HeadlessException {
        this(string, string != null ? string.length() : 0);
    }

    public void setText(String string) {
        super.setText(string);
        if (this.valid) {
            this.invalidate();
        }
    }

    public TextField(String string, int n2) throws HeadlessException {
        super(string);
        this.columns = n2 >= 0 ? n2 : 0;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextField(this);
        }
        return this.accessibleContext;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        ActionListener actionListener = null;
        if (clazz != (class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TextField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener)) {
            return super.getListeners(clazz);
        }
        actionListener = this.actionListener;
        return AWTEventMulticaster.getListeners(actionListener, clazz);
    }

    protected class AccessibleAWTTextField
    extends TextComponent.AccessibleAWTTextComponent {
        private final TextField this$0;

        protected AccessibleAWTTextField(TextField textField) {
            this.this$0 = textField;
            super(textField);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }
    }
}

