/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.login;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class ConfigFile
extends Configuration {
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private HashMap configuration;
    private boolean expandProp = true;
    private boolean testing = false;

    private int nextToken() throws IOException {
        int n2;
        while ((n2 = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return n2;
    }

    public ConfigFile() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ConfigFile this$0;
            {
                this.this$0 = configFile;
            }

            public Object run() {
                return System.getProperty("policy.expandProperties");
            }
        });
        if ("false".equals(string)) {
            this.expandProp = false;
        }
        try {
            this.init();
        }
        catch (IOException iOException) {
            throw (SecurityException)new SecurityException(iOException.getMessage()).initCause(iOException);
        }
    }

    private void init() throws IOException {
        String string;
        Object[] objectArray;
        String string2;
        boolean bl2 = false;
        Object var2_2 = null;
        String string3 = File.separator;
        HashMap hashMap = new HashMap();
        String string4 = Security.getProperty("policy.allowSystemProperty");
        if ("true".equalsIgnoreCase(string4) && (string2 = System.getProperty("java.security.auth.login.config")) != null) {
            boolean bl3 = false;
            if (string2.startsWith("=")) {
                bl3 = true;
                string2 = string2.substring(1);
            }
            try {
                string2 = PropertyExpander.expand(string2);
            }
            catch (PropertyExpander.ExpandException expandException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Unable to properly expand config", "sun.security.util.AuthResources"));
                Object[] objectArray2 = new Object[]{string2};
                throw new IOException(messageFormat.format(objectArray2));
            }
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                objectArray = new File(string2);
                if (objectArray.exists()) {
                    uRL = new URL("file:" + objectArray.getCanonicalPath());
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("extra_config (No such file or directory)", "sun.security.util.AuthResources"));
                Object[] objectArray3 = new Object[]{string2};
                throw new IOException(messageFormat.format(objectArray3));
            }
            if (this.testing) {
                System.out.println("reading " + uRL);
            }
            this.init(uRL, hashMap);
            bl2 = true;
            if (bl3 && this.testing) {
                System.out.println("overriding other policies!");
            }
        }
        int n2 = 1;
        while ((string = Security.getProperty("login.config.url." + n2)) != null) {
            try {
                string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
                if (this.testing) {
                    System.out.println("\tReading config: " + string);
                }
                this.init(new URL(string), hashMap);
                bl2 = true;
            }
            catch (PropertyExpander.ExpandException expandException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Unable to properly expand config", "sun.security.util.AuthResources"));
                objectArray = new Object[]{string};
                throw new IOException(messageFormat.format(objectArray));
            }
            ++n2;
        }
        if (!bl2 && n2 == 1 && string == null) {
            if (this.testing) {
                System.out.println("\tReading Policy from ~/.java.login.config");
            }
            string = System.getProperty("user.home");
            try {
                this.init(new URL("file:" + string + File.separatorChar + ".java.login.config"), hashMap);
            }
            catch (IOException iOException) {
                throw new IOException(ResourcesMgr.getString("Unable to locate a login configuration", "sun.security.util.AuthResources"));
            }
        }
        this.configuration = hashMap;
    }

    public synchronized void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final ConfigFile this$0;
            {
                this.this$0 = configFile;
            }

            public Object run() {
                try {
                    ConfigFile.access$000(this.this$0);
                }
                catch (IOException iOException) {
                    throw new SecurityException(iOException.getLocalizedMessage());
                }
                return null;
            }
        });
    }

    static void access$000(ConfigFile configFile) throws IOException {
        configFile.init();
    }

    private boolean peek(String string) {
        boolean bl2 = false;
        switch (this.lookahead) {
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl2 = true;
                break;
            }
            case 59: {
                if (!string.equalsIgnoreCase(";")) break;
                bl2 = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl2 = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private void parseLoginEntry(HashMap hashMap) throws IOException {
        Object object;
        Cloneable cloneable;
        LinkedList linkedList = new LinkedList();
        String string = this.st.sval;
        this.lookahead = this.nextToken();
        if (this.testing) {
            System.out.println("appName = " + string);
        }
        this.match("{");
        while (!this.peek("}")) {
            Object object2;
            Object object3;
            AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag;
            cloneable = new HashSet();
            String string2 = this.match("module class name");
            String string3 = this.match("controlFlag");
            if (string3.equalsIgnoreCase("REQUIRED")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (string3.equalsIgnoreCase("REQUISITE")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (string3.equalsIgnoreCase("SUFFICIENT")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (string3.equalsIgnoreCase("OPTIONAL")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                object = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tInvalid control flag, flag", "sun.security.util.AuthResources"));
                object3 = new Object[]{string3};
                throw new IOException(((Format)object).format(object3));
            }
            object = new HashMap();
            while (!this.peek(";")) {
                String string4;
                object3 = this.match("option key");
                this.match("=");
                try {
                    string4 = this.expand(this.match("option value"));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    throw new IOException(expandException.getLocalizedMessage());
                }
                ((HashMap)object).put(object3, string4);
            }
            this.lookahead = this.nextToken();
            if (this.testing) {
                System.out.print("\t\t" + string2 + ", " + string3);
                object2 = ((HashMap)object).keySet().iterator();
                while (object2.hasNext()) {
                    object3 = (String)object2.next();
                    System.out.print(", " + (String)object3 + "=" + (String)((HashMap)object).get(object3));
                }
                System.out.println("");
            }
            object2 = new AppConfigurationEntry(string2, loginModuleControlFlag, (Map)object);
            linkedList.add(object2);
        }
        this.match("}");
        this.match(";");
        if (hashMap.containsKey(string)) {
            cloneable = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tCan not specify multiple entries for appName", "sun.security.util.AuthResources"));
            object = new Object[]{string};
            throw new IOException(((Format)cloneable).format(object));
        }
        hashMap.put(string, linkedList);
        if (this.testing) {
            System.out.println("\t\t***Added entry for " + string + " to overall configuration***");
        }
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    private String expand(String string) throws PropertyExpander.ExpandException, IOException {
        if (this.expandProp) {
            String string2 = PropertyExpander.expand(string);
            if (string2 == null || string2.length() == 0) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: system property [value] expanded to empty value", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string};
                throw new IOException(messageFormat.format(objectArray));
            }
            return string2;
        }
        return string;
    }

    private String match(String string) throws IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -1: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\texpected [expect], read [end of file]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{string};
                throw new IOException(messageFormat.format(objectArray));
            }
            case -3: 
            case 34: {
                if (string.equalsIgnoreCase("module class name") || string.equalsIgnoreCase("controlFlag") || string.equalsIgnoreCase("option key") || string.equalsIgnoreCase("option value")) {
                    string2 = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect], found [value]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 61: {
                if (string.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect], found [value]", "sun.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
        }
        return string2;
    }

    private void readConfig(Reader reader, HashMap hashMap) throws IOException {
        boolean bl2 = true;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.quoteChar(34);
        this.st.wordChars(36, 36);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        this.lookahead = this.nextToken();
        while (this.lookahead != -1) {
            if (this.testing) {
                System.out.print("\tReading next config entry: ");
            }
            this.parseLoginEntry(hashMap);
        }
    }

    private void init(URL uRL, HashMap hashMap) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL), "UTF-8");
        this.readConfig(inputStreamReader, hashMap);
        inputStreamReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        LinkedList linkedList = null;
        HashMap hashMap = this.configuration;
        synchronized (hashMap) {
            linkedList = (LinkedList)this.configuration.get(string);
        }
        if (linkedList == null || linkedList.size() == 0) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
            appConfigurationEntryArray[n2] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
            ++n2;
        }
        return appConfigurationEntryArray;
    }
}

