/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileWriter;
import com.sun.media.sound.WaveFileFormat;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WaveFileWriter
extends SunFileWriter {
    static final int RIFF_MAGIC = 1380533830;
    static final int WAVE_MAGIC = 1463899717;
    static final int FMT_MAGIC = 1718449184;
    static final int DATA_MAGIC = 1684108385;
    static final int WAVE_FORMAT_UNKNOWN = 0;
    static final int WAVE_FORMAT_PCM = 1;
    static final int WAVE_FORMAT_ADPCM = 2;
    static final int WAVE_FORMAT_ALAW = 6;
    static final int WAVE_FORMAT_MULAW = 7;
    static final int WAVE_FORMAT_OKI_ADPCM = 16;
    static final int WAVE_FORMAT_DIGISTD = 21;
    static final int WAVE_FORMAT_DIGIFIX = 22;
    static final int WAVE_IBM_FORMAT_MULAW = 257;
    static final int WAVE_IBM_FORMAT_ALAW = 258;
    static final int WAVE_IBM_FORMAT_ADPCM = 259;
    static final int WAVE_FORMAT_DVI_ADPCM = 17;
    static final int WAVE_FORMAT_SX7383 = 7175;
    private static final AudioFileFormat.Type[] waveTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    public WaveFileWriter() {
        super(waveTypes);
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, typeArray, 0, this.types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n2 = this.writeWaveFile(audioInputStream, waveFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (waveFileFormat.getByteLength() == -1) {
            int n3 = n2 - waveFileFormat.getHeaderSize();
            int n4 = n3 + waveFileFormat.getHeaderSize() - 8;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.skipBytes(4);
            randomAccessFile.writeInt(this.big2little(n4));
            randomAccessFile.skipBytes(12 + WaveFileFormat.getFmtChunkSize(waveFileFormat.getWaveType()) + 4);
            randomAccessFile.writeInt(this.big2little(n3));
            randomAccessFile.close();
        }
        return n2;
    }

    private InputStream getFileStream(WaveFileFormat waveFileFormat, InputStream inputStream) throws IOException {
        AudioFormat audioFormat = waveFileFormat.getFormat();
        int n2 = waveFileFormat.getHeaderSize();
        int n3 = 1380533830;
        int n4 = 1463899717;
        int n5 = 1718449184;
        int n6 = WaveFileFormat.getFmtChunkSize(waveFileFormat.getWaveType());
        short s2 = (short)waveFileFormat.getWaveType();
        short s3 = (short)audioFormat.getChannels();
        short s4 = (short)audioFormat.getSampleSizeInBits();
        int n7 = (int)audioFormat.getSampleRate();
        int n8 = audioFormat.getFrameSize();
        int n9 = (int)audioFormat.getFrameRate();
        int n10 = s3 * s4 * n7 / 8;
        short s5 = (short)(s4 / 8 * s3);
        int n11 = 1684108385;
        int n12 = waveFileFormat.getFrameLength() * n8;
        int n13 = waveFileFormat.getByteLength();
        int n14 = n12 + n2 - 8;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        InputStream inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream) {
            audioFormat2 = ((AudioInputStream)inputStream).getFormat();
            encoding = audioFormat2.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_SIGNED && s4 == 8) {
                s2 = 1;
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false), (AudioInputStream)inputStream);
            }
            if ((encoding == AudioFormat.Encoding.PCM_SIGNED && audioFormat2.isBigEndian() || encoding == AudioFormat.Encoding.PCM_UNSIGNED && !audioFormat2.isBigEndian() || encoding == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat2.isBigEndian()) && s4 != 8) {
                s2 = 1;
                inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false), (AudioInputStream)inputStream);
            }
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(this.big2little(n14));
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeInt(n5);
        dataOutputStream.writeInt(this.big2little(n6));
        dataOutputStream.writeShort(this.big2littleShort(s2));
        dataOutputStream.writeShort(this.big2littleShort(s3));
        dataOutputStream.writeInt(this.big2little(n7));
        dataOutputStream.writeInt(this.big2little(n10));
        dataOutputStream.writeShort(this.big2littleShort(s5));
        dataOutputStream.writeShort(this.big2littleShort(s4));
        if (s2 != 1) {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.writeInt(n11);
        dataOutputStream.writeInt(this.big2little(n12));
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
        return sequenceInputStream;
    }

    private int writeWaveFile(InputStream inputStream, WaveFileFormat waveFileFormat, OutputStream outputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream2 = this.getFileStream(waveFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n4 = waveFileFormat.getByteLength();
        while ((n2 = inputStream2.read(byArray)) >= 0) {
            if (n4 > 0) {
                if (n2 < n4) {
                    outputStream.write(byArray, 0, n2);
                    n3 += n2;
                    n4 -= n2;
                    continue;
                }
                outputStream.write(byArray, 0, n4);
                n3 += n4;
                n4 = 0;
                break;
            }
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        if (audioInputStream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        WaveFileFormat waveFileFormat = (WaveFileFormat)this.getAudioFileFormat(type, audioInputStream);
        int n2 = this.writeWaveFile(audioInputStream, waveFileFormat, outputStream);
        return n2;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n2;
        AudioFormat audioFormat = null;
        WaveFileFormat waveFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        if (type != this.types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        int n3 = 1;
        if (encoding2 == AudioFormat.Encoding.ALAW || encoding2 == AudioFormat.Encoding.ULAW) {
            encoding = encoding2;
            n2 = audioFormat2.getSampleSizeInBits();
            n3 = encoding2 == AudioFormat.Encoding.ALAW ? 6 : 7;
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            n2 = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n2 = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n2, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), false);
        int n4 = audioInputStream.getFrameLength() != -1L ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + WaveFileFormat.getHeaderSize(n3) : -1;
        waveFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, n4, audioFormat, (int)audioInputStream.getFrameLength());
        return waveFileFormat;
    }
}

