/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleInputDeviceProvider;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.TargetDataLine;

class SimpleInputDevice
extends AbstractMixer {
    private JSSecurity jsSecurity = JSSecurityManager.getJSSecurity();
    private Port[] ports;
    private boolean implStarted = false;
    static Class class$javax$sound$sampled$DataLine;
    static Class class$javax$sound$sampled$TargetDataLine;
    static Class class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine;
    static Class class$javax$sound$sampled$Port;

    private native int nGetBufferSizeInFrames();

    private native int nGetNumPorts();

    private native long nGetPosition();

    private void callbackCaptureStreamDestroy() {
    }

    public void implClose() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        this.nClose();
    }

    void implStart() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (!this.implStarted) {
            this.nStart();
            this.implStarted = true;
        } else {
            this.nResume();
        }
    }

    void implStop() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        this.nPause();
        this.setActive(false);
        this.setStarted(false);
    }

    private native void nClose();

    private native void nDrain();

    private native void nFlush();

    private native void nPause();

    private native void nResume();

    private native void nStart();

    private native void nOpen(int var1, int var2, float var3, int var4, int var5, int var6) throws LineUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamPutData(byte[] byArray, int n2) {
        this.setActive(true);
        this.setStarted(true);
        int n3 = n2 * this.format.getFrameSize();
        Vector vector = (Vector)this.targetLines.clone();
        int n4 = 0;
        while (n4 < vector.size()) {
            InputDeviceDataLine inputDeviceDataLine = (InputDeviceDataLine)vector.elementAt(n4);
            if (inputDeviceDataLine.isOpen() && inputDeviceDataLine.isStartedRunning()) {
                inputDeviceDataLine.setActive(true);
                inputDeviceDataLine.setStarted(true);
                int n5 = InputDeviceDataLine.access$300(inputDeviceDataLine).writeover(byArray, 0, n3);
                InputDeviceDataLine inputDeviceDataLine2 = inputDeviceDataLine;
                synchronized (inputDeviceDataLine2) {
                    inputDeviceDataLine.notifyAll();
                }
                if (n5 > 0) {
                    // empty if block
                }
            }
            ++n4;
        }
    }

    static long access$800(SimpleInputDevice simpleInputDevice) {
        return simpleInputDevice.nGetPosition();
    }

    static void access$600(SimpleInputDevice simpleInputDevice) {
        simpleInputDevice.nDrain();
    }

    static void access$700(SimpleInputDevice simpleInputDevice) {
        simpleInputDevice.nFlush();
    }

    static boolean access$502(SimpleInputDevice simpleInputDevice, boolean bl2) {
        simpleInputDevice.implStarted = bl2;
        return simpleInputDevice.implStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleInputDevice(SimpleInputDeviceProvider.InputDeviceInfo inputDeviceInfo) {
        super(null, new Control[0], null, -1, inputDeviceInfo, null, null);
        int n2;
        AudioFormat[] audioFormatArray;
        Platform.initialize();
        this.nGetFormats(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), this.formats, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW, AudioFormat.Encoding.ALAW);
        Vector vector = this.formats;
        synchronized (vector) {
            audioFormatArray = new AudioFormat[this.formats.size()];
            n2 = 0;
            while (n2 < audioFormatArray.length) {
                audioFormatArray[n2] = (AudioFormat)this.formats.elementAt(n2);
                ++n2;
            }
        }
        this.info = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = SimpleInputDevice.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, audioFormatArray, 0, -1);
        n2 = this.nGetNumPorts();
        this.sourceLineInfo = new Port.Info[n2];
        this.ports = new Port[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string = this.nGetPortName(n3);
            this.sourceLineInfo[n3] = this.getPortInfo(string);
            this.ports[n3] = new InputDevicePort(this, (Port.Info)this.sourceLineInfo[n3], this, new Control[0], null);
            ++n3;
        }
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = SimpleInputDevice.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormatArray, 0, -1);
        this.format = this.formats.size() > 0 ? (AudioFormat)this.formats.lastElement() : null;
        this.defaultFormat = this.format;
        this.defaultBufferSize = this.bufferSize;
    }

    private native String nGetPortName(int var1);

    public void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 8;
        int n4 = 0;
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            n4 = 1;
        } else if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            n4 = 2;
        }
        this.nOpen(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), n4, (int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), n2 / (audioFormat.getFrameSize() * n3));
        this.format = audioFormat;
        this.bufferSize = this.nGetBufferSizeInFrames() * audioFormat.getFrameSize() * n3;
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        if (info2 instanceof DataLine.Info) {
            return -1;
        }
        return 0;
    }

    static JSSecurity access$400(SimpleInputDevice simpleInputDevice) {
        return simpleInputDevice.jsSecurity;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void open(DataLine dataLine, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        if (this.equals(dataLine)) {
            return;
        }
        if (this.isSourceLine(dataLine.getLineInfo())) {
            if (!this.sourceLines.contains(dataLine)) {
                this.open(audioFormat, n2);
                this.sourceLines.addElement(dataLine);
            }
        } else if (this.isTargetLine(dataLine.getLineInfo()) && !this.targetLines.contains(dataLine)) {
            this.open(audioFormat, n2);
            this.targetLines.addElement(dataLine);
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine.Info info2;
        Line.Info info3 = this.getLineInfo(info);
        if (info3 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info3 instanceof Port.Info) {
            int n2 = 0;
            while (n2 < this.ports.length) {
                if (info3.equals(this.ports[n2].getLineInfo())) {
                    return this.ports[n2];
                }
                ++n2;
            }
        }
        if (info3 instanceof DataLine.Info && (info2 = (DataLine.Info)info3).getLineClass().isAssignableFrom(class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine == null ? (class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine = SimpleInputDevice.class$("com.sun.media.sound.SimpleInputDevice$InputDeviceDataLine")) : class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine)) {
            AudioFormat[] audioFormatArray;
            int n3 = -1;
            AudioFormat audioFormat = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                if (audioFormatArray != null && audioFormatArray.length > 0) {
                    audioFormat = audioFormatArray[audioFormatArray.length - 1];
                }
                if ((n3 = ((DataLine.Info)info).getMaxBufferSize()) == -1) {
                    n3 = ((DataLine.Info)info).getMinBufferSize();
                }
                if (n3 <= 0) {
                    n3 = -1;
                }
            }
            if (audioFormat == null) {
                audioFormatArray = info2.getFormats();
                audioFormat = audioFormatArray[audioFormatArray.length - 1];
            }
            if (n3 == -1) {
                n3 = (int)(audioFormat.getFrameRate() * (float)audioFormat.getFrameSize() / 2.0f);
            }
            return new InputDeviceDataLine(this, info2, this, audioFormat, n3, null);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    private Port.Info getPortInfo(String string) {
        if (string.equals(Port.Info.MICROPHONE.toString())) {
            return Port.Info.MICROPHONE;
        }
        if (string.equals(Port.Info.LINE_IN.toString())) {
            return Port.Info.LINE_IN;
        }
        if (string.equals(Port.Info.COMPACT_DISC.toString())) {
            return Port.Info.COMPACT_DISC;
        }
        return new InputDevicePortInfo(string, null);
    }

    private native void nGetFormats(int var1, Vector var2, AudioFormat.Encoding var3, AudioFormat.Encoding var4, AudioFormat.Encoding var5, AudioFormat.Encoding var6);

    class 1 {
    }

    private class InputDeviceDataLine
    extends AbstractDataLine
    implements TargetDataLine {
        private CircularBuffer circularBuffer;
        private final SimpleInputDevice this$0;

        public int available() {
            return this.circularBuffer.bytesAvailableToRead();
        }

        public int getFramePosition() {
            return this.isOpen() ? (int)SimpleInputDevice.access$800(this.this$0) : super.getFramePosition();
        }

        public void drain() {
            if (this.isOpen()) {
                this.circularBuffer.drain();
                SimpleInputDevice.access$600(this.this$0);
            }
        }

        public void flush() {
            if (this.isOpen()) {
                this.circularBuffer.flush();
                SimpleInputDevice.access$700(this.this$0);
            }
        }

        void implClose() {
            if (SimpleInputDevice.access$400(this.this$0) != null) {
                SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
            }
            SimpleInputDevice.access$502(this.this$0, false);
        }

        void implStart() {
            if (SimpleInputDevice.access$400(this.this$0) != null) {
                SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
            }
        }

        void implStop() {
            if (SimpleInputDevice.access$400(this.this$0) != null) {
                SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
            }
            this.setActive(false);
            this.setStarted(false);
        }

        public synchronized void open() throws LineUnavailableException {
            try {
                super.open();
            }
            catch (LineUnavailableException lineUnavailableException) {
                AudioFormat audioFormat = AbstractMixer.getSystemFormat();
                if (audioFormat != null) {
                    this.open(audioFormat);
                }
                throw lineUnavailableException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) {
            int n4 = n3;
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n3 + " bytes )");
            }
            int n5 = 0;
            int n6 = 0;
            while (this.isOpen() && this.isStartedRunning() && n5 < n4) {
                n6 = this.circularBuffer.read(byArray, n2, n4 - n5);
                n2 += n6;
                if ((n5 += n6) >= n4) continue;
                try {
                    InputDeviceDataLine inputDeviceDataLine = this;
                    synchronized (inputDeviceDataLine) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return n5;
        }

        private CircularBuffer getCircularBuffer() {
            return this.circularBuffer;
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            if (SimpleInputDevice.access$400(this.this$0) != null) {
                SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
            }
            n2 = this.mixer.getBufferSize();
            boolean bl2 = false;
            boolean bl3 = false;
            if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !Platform.isSigned8()) {
                bl2 = true;
            } else if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && Platform.isSigned8()) {
                bl2 = true;
            }
            if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
                bl3 = true;
            }
            this.circularBuffer = new CircularBuffer(n2, bl2, bl3);
            this.bufferSize = n2;
            this.format = audioFormat;
        }

        static CircularBuffer access$300(InputDeviceDataLine inputDeviceDataLine) {
            return inputDeviceDataLine.getCircularBuffer();
        }

        private InputDeviceDataLine(SimpleInputDevice simpleInputDevice, DataLine.Info info, SimpleInputDevice simpleInputDevice2, AudioFormat audioFormat, int n2) {
            this.this$0 = simpleInputDevice;
            super(info, simpleInputDevice2, null, audioFormat, n2);
            this.circularBuffer = null;
        }

        InputDeviceDataLine(SimpleInputDevice simpleInputDevice, DataLine.Info info, SimpleInputDevice simpleInputDevice2, AudioFormat audioFormat, int n2, 1 var6_6) {
            this(simpleInputDevice, info, simpleInputDevice2, audioFormat, n2);
        }
    }

    private class InputDevicePort
    extends AbstractLine
    implements Port {
        private final SimpleInputDevice this$0;

        public synchronized void close() {
            if (this.isOpen()) {
                if (SimpleInputDevice.access$400(this.this$0) != null) {
                    SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
                }
                this.setOpen(false);
                this.mixer.close(this);
            }
        }

        public synchronized void open() throws LineUnavailableException {
            if (!this.isOpen()) {
                if (SimpleInputDevice.access$400(this.this$0) != null) {
                    SimpleInputDevice.access$400(this.this$0).checkRecordPermission();
                }
                this.mixer.open(this);
                this.setOpen(true);
            }
        }

        private InputDevicePort(SimpleInputDevice simpleInputDevice, Port.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
            this.this$0 = simpleInputDevice;
            super(info, abstractMixer, controlArray);
        }

        InputDevicePort(SimpleInputDevice simpleInputDevice, Port.Info info, AbstractMixer abstractMixer, Control[] controlArray, 1 var5_5) {
            this(simpleInputDevice, info, abstractMixer, controlArray);
        }
    }

    private static class InputDevicePortInfo
    extends Port.Info {
        private InputDevicePortInfo(String string) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = SimpleInputDevice.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, string, true);
        }

        InputDevicePortInfo(String string, 1 var2_2) {
            this(string);
        }
    }
}

