/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12PropertyAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class Platform {
    private static final String[] libraries = new String[]{"jsound"};
    private static boolean signed8;
    private static boolean bigEndian;
    private static String javahome;
    private static String classpath;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;

    static {
        jsSecurity = null;
        securityPrivilege = false;
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            securityPrivilege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (securityPrivilege && jsSecurity != null) {
            if (!(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    Platform.loadLibraries();
                    Platform.readProperties();
                } else {
                    try {
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 1);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 64);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Platform.loadLibraries();
                    Platform.readProperties();
                }
            }
        } else {
            Platform.loadLibraries();
            Platform.readProperties();
        }
    }

    private Platform() {
    }

    static void initialize() {
    }

    private static void loadLibraries() {
        int n2 = 0;
        while (n2 < libraries.length) {
            if (securityPrivilege) {
                if (jsSecurity != null) {
                    jsSecurity.loadLibrary(libraries[n2]);
                } else {
                    System.loadLibrary(libraries[n2]);
                }
            }
            ++n2;
        }
    }

    private static void readProperties() {
        bigEndian = Platform.nIsBigEndian();
        signed8 = Platform.nIsSigned8();
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12PropertyAction.cons;
                    javahome = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.home"})});
                    classpath = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.class.path"})});
                }
                catch (Exception exception) {
                    javahome = System.getProperty("java.home");
                    classpath = System.getProperty("java.class.path");
                }
            } else {
                javahome = jsSecurity.readProperty("java.home");
                classpath = jsSecurity.readProperty("java.class.path");
            }
        } else {
            javahome = System.getProperty("java.home");
            classpath = System.getProperty("java.class.path");
        }
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isSigned8() {
        return signed8;
    }

    private static native boolean nIsBigEndian();

    private static native boolean nIsSigned8();

    static String getClasspath() {
        return classpath;
    }

    static String getJavahome() {
        return javahome;
    }
}

