/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AuFileFormat;
import com.sun.media.sound.SunFileWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AuFileWriter
extends SunFileWriter {
    public static final int UNKNOWN_SIZE = -1;
    private static final AudioFileFormat.Type[] auTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.AU};

    public AuFileWriter() {
        super(auTypes);
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, typeArray, 0, this.types.length);
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return typeArray;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
        int n2 = this.writeAuFile(audioInputStream, auFileFormat, bufferedOutputStream);
        bufferedOutputStream.close();
        if (auFileFormat.getByteLength() == -1) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            if (randomAccessFile.length() <= Integer.MAX_VALUE) {
                randomAccessFile.skipBytes(8);
                randomAccessFile.writeInt(n2 - 24);
            }
            randomAccessFile.close();
        }
        return n2;
    }

    private InputStream getFileStream(AuFileFormat auFileFormat, InputStream inputStream) throws IOException {
        long l2;
        AudioFormat audioFormat = auFileFormat.getFormat();
        int n2 = 779316836;
        int n3 = 24;
        long l3 = auFileFormat.getFrameLength();
        long l4 = l2 = l3 == -1L ? -1L : l3 * (long)audioFormat.getFrameSize();
        if (l2 > Integer.MAX_VALUE) {
            l2 = -1L;
        }
        int n4 = auFileFormat.getAuType();
        int n5 = (int)audioFormat.getSampleRate();
        int n6 = audioFormat.getChannels();
        boolean bl2 = true;
        byte[] byArray = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        SequenceInputStream sequenceInputStream = null;
        AudioFormat audioFormat2 = null;
        AudioFormat.Encoding encoding = null;
        InputStream inputStream2 = inputStream;
        inputStream2 = inputStream;
        if (inputStream instanceof AudioInputStream && ((encoding = (audioFormat2 = ((AudioInputStream)inputStream).getFormat()).getEncoding()) == AudioFormat.Encoding.PCM_UNSIGNED || encoding == AudioFormat.Encoding.PCM_SIGNED && bl2 != audioFormat2.isBigEndian())) {
            inputStream2 = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), bl2), (AudioInputStream)inputStream);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (bl2) {
            dataOutputStream.writeInt(779316836);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt((int)l2);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(n6);
        } else {
            dataOutputStream.writeInt(1684960046);
            dataOutputStream.writeInt(this.big2little(n3));
            dataOutputStream.writeInt(this.big2little((int)l2));
            dataOutputStream.writeInt(this.big2little(n4));
            dataOutputStream.writeInt(this.big2little(n5));
            dataOutputStream.writeInt(this.big2little(n6));
        }
        dataOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream2);
        return sequenceInputStream;
    }

    private int writeAuFile(InputStream inputStream, AuFileFormat auFileFormat, OutputStream outputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream2 = this.getFileStream(auFileFormat, inputStream);
        byte[] byArray = new byte[4096];
        int n4 = auFileFormat.getByteLength();
        while ((n2 = inputStream2.read(byArray)) >= 0) {
            if (n4 > 0) {
                if (n2 < n4) {
                    outputStream.write(byArray, 0, n2);
                    n3 += n2;
                    n4 -= n2;
                    continue;
                }
                outputStream.write(byArray, 0, n4);
                n3 += n4;
                n4 = 0;
                break;
            }
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(type, audioInputStream);
        int n2 = this.writeAuFile(audioInputStream, auFileFormat, outputStream);
        return n2;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        int n2;
        AudioFormat audioFormat = null;
        AuFileFormat auFileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        if (type != this.types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (encoding2 == AudioFormat.Encoding.ALAW || encoding2 == AudioFormat.Encoding.ULAW) {
            encoding = encoding2;
            n2 = audioFormat2.getSampleSizeInBits();
        } else if (audioFormat2.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n2 = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            n2 = audioFormat2.getSampleSizeInBits();
        }
        audioFormat = new AudioFormat(encoding, audioFormat2.getSampleRate(), n2, audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat2.getFrameRate(), true);
        int n3 = audioInputStream.getFrameLength() != -1L ? (int)audioInputStream.getFrameLength() * audioFormat2.getFrameSize() + 24 : -1;
        auFileFormat = new AuFileFormat(AudioFileFormat.Type.AU, n3, audioFormat, (int)audioInputStream.getFrameLength());
        return auFileFormat;
    }
}

