/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.EventDispatcher;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractLine
implements Line {
    protected Line.Info info;
    protected Control[] controls;
    protected AbstractMixer mixer;
    private boolean open = false;
    private Vector listeners = new Vector();
    private static final EventDispatcher eventDispatcher = new EventDispatcher();

    public int getFramePosition() {
        return -1;
    }

    static {
        eventDispatcher.start();
    }

    public abstract void close();

    public abstract void open() throws LineUnavailableException;

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(boolean bl2) {
        boolean bl3 = false;
        int n2 = this.getFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != bl2) {
                this.open = bl2;
                bl3 = true;
            }
        }
        if (bl3) {
            if (bl2) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, n2));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, n2));
            }
        }
    }

    protected AbstractMixer getMixer() {
        return this.mixer;
    }

    public Control[] getControls() {
        Control[] controlArray = new Control[this.controls.length];
        int n2 = 0;
        while (n2 < this.controls.length) {
            controlArray[n2] = this.controls[n2];
            ++n2;
        }
        return controlArray;
    }

    public boolean isControlSupported(Control.Type type) {
        if (type == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.controls.length) {
            if (type == this.controls[n2].getType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Line.Info getLineInfo() {
        return this.info;
    }

    protected void sendEvents(LineEvent lineEvent) {
        eventDispatcher.sendAudioEvents(lineEvent, this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineListener(LineListener lineListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(lineListener)) {
                this.listeners.addElement(lineListener);
            }
        }
    }

    public void removeLineListener(LineListener lineListener) {
        this.listeners.removeElement(lineListener);
    }

    public Control getControl(Control.Type type) {
        if (type != null) {
            int n2 = 0;
            while (n2 < this.controls.length) {
                if (type == this.controls[n2].getType()) {
                    return this.controls[n2];
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + type);
    }

    protected AbstractLine(Line.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.info = info;
        this.mixer = abstractMixer;
        this.controls = controlArray;
    }
}

