/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsScrollBarUI
extends BasicScrollBarUI {
    private Grid thumbGrid;
    private Grid highlightGrid;

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        Color color = UIManager.getColor("ScrollBar.trackForeground");
        this.thumbGrid = Grid.getGrid(color, this.trackColor);
        color = UIManager.getColor("ScrollBar.trackHighlightForeground");
        this.highlightGrid = Grid.getGrid(color, this.trackHighlightColor);
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n5 = insets.left;
                n4 = this.decrButton.getY() + this.decrButton.getHeight();
                n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n2 = rectangle.y - n4;
            } else {
                n5 = this.decrButton.getX() + this.decrButton.getHeight();
                n4 = insets.top;
                n3 = rectangle.x - n5;
                n2 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n5, n4, n3, n2);
        }
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n5 = insets.left;
                n4 = rectangle.y + rectangle.height;
                n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n2 = this.incrButton.getY() - n4;
            } else {
                n5 = rectangle.x + rectangle.width;
                n4 = insets.top;
                n3 = this.incrButton.getX() - n5;
                n2 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n5, n4, n3, n2);
        }
    }

    protected JButton createDecreaseButton(int n2) {
        return new WindowsArrowButton(this, n2, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected JButton createIncreaseButton(int n2) {
        return new WindowsArrowButton(this, n2, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.highlightGrid = null;
        this.thumbGrid = null;
    }

    static JScrollBar access$000(WindowsScrollBarUI windowsScrollBarUI) {
        return windowsScrollBarUI.scrollbar;
    }

    static JScrollBar access$100(WindowsScrollBarUI windowsScrollBarUI) {
        return windowsScrollBarUI.scrollbar;
    }

    static JScrollBar access$200(WindowsScrollBarUI windowsScrollBarUI) {
        return windowsScrollBarUI.scrollbar;
    }

    static JScrollBar access$300(WindowsScrollBarUI windowsScrollBarUI) {
        return windowsScrollBarUI.scrollbar;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsScrollBarUI();
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (this.thumbGrid == null) {
            super.paintTrack(graphics, jComponent, rectangle);
        } else {
            this.thumbGrid.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.trackHighlight == 1) {
                this.paintDecreaseHighlight(graphics);
            } else if (this.trackHighlight == 2) {
                this.paintIncreaseHighlight(graphics);
            }
        }
    }

    private static class Grid {
        private static final int BUFFER_SIZE = 64;
        private static HashMap map = new HashMap();
        private BufferedImage image;

        public void paint(Graphics graphics, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = graphics.getClipBounds();
            int n6 = Math.max(n2, rectangle.x);
            int n7 = Math.max(n3, rectangle.y);
            int n8 = Math.min(rectangle.x + rectangle.width, n2 + n4);
            int n9 = Math.min(rectangle.y + rectangle.height, n3 + n5);
            if (n8 <= n6 || n9 <= n7) {
                return;
            }
            int n10 = (n6 - n2) % 2;
            int n11 = n6;
            while (n11 < n8) {
                int n12 = (n7 - n3) % 2;
                int n13 = Math.min(64 - n10, n8 - n11);
                int n14 = n7;
                while (n14 < n9) {
                    int n15 = Math.min(64 - n12, n9 - n14);
                    graphics.drawImage(this.image, n11, n14, n11 + n13, n14 + n15, n10, n12, n10 + n13, n12 + n15, null);
                    if (n12 != 0) {
                        n14 -= n12;
                        n12 = 0;
                    }
                    n14 += 64;
                }
                if (n10 != 0) {
                    n11 -= n10;
                    n10 = 0;
                }
                n11 += 64;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grid(Color color, Color color2) {
            int[] nArray = new int[]{color.getRGB(), color2.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 2, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
            Graphics graphics = this.image.getGraphics();
            try {
                graphics.setClip(0, 0, 64, 64);
                this.paintGrid(graphics, color, color2);
                Object var7_6 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                graphics.dispose();
                throw throwable;
            }
        }

        public static Grid getGrid(Color color, Color color2) {
            Grid grid;
            String string = color.getRGB() + " " + color2.getRGB();
            WeakReference weakReference = (WeakReference)map.get(string);
            Grid grid2 = grid = weakReference == null ? null : (Grid)weakReference.get();
            if (grid == null) {
                grid = new Grid(color, color2);
                map.put(string, new WeakReference(grid));
            }
            return grid;
        }

        private void paintGrid(Graphics graphics, Color color, Color color2) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.translate(rectangle.x, rectangle.y);
            int n2 = rectangle.width;
            int n3 = rectangle.height;
            int n4 = rectangle.x % 2;
            int n5 = n2 - n3;
            while (n4 < n5) {
                graphics.drawLine(n4, 0, n4 + n3, n3);
                n4 += 2;
            }
            int n6 = n2;
            while (n4 < n6) {
                graphics.drawLine(n4, 0, n2, n2 - n4);
                n4 += 2;
            }
            int n7 = rectangle.x % 2 == 0 ? 2 : 1;
            int n8 = n3 - n2;
            while (n7 < n8) {
                graphics.drawLine(0, n7, n2, n7 + n2);
                n7 += 2;
            }
            int n9 = n3;
            while (n7 < n9) {
                graphics.drawLine(0, n7, n3 - n7, n3);
                n7 += 2;
            }
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        private final WindowsScrollBarUI this$0;

        public WindowsArrowButton(WindowsScrollBarUI windowsScrollBarUI, int n2) {
            this.this$0 = windowsScrollBarUI;
            super(n2);
        }

        public Dimension getPreferredSize() {
            int n2 = 16;
            if (WindowsScrollBarUI.access$000(this.this$0) != null) {
                switch (WindowsScrollBarUI.access$100(this.this$0).getOrientation()) {
                    case 1: {
                        n2 = WindowsScrollBarUI.access$200(this.this$0).getWidth();
                        break;
                    }
                    case 0: {
                        n2 = WindowsScrollBarUI.access$300(this.this$0).getHeight();
                    }
                }
                n2 = Math.max(n2, 5);
            }
            return new Dimension(n2, n2);
        }

        public WindowsArrowButton(WindowsScrollBarUI windowsScrollBarUI, int n2, Color color, Color color2, Color color3, Color color4) {
            this.this$0 = windowsScrollBarUI;
            super(n2, color, color2, color3, color4);
        }
    }
}

