/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsGraphicsUtils {
    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n2) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = abstractButton.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            n3 = -1;
        }
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x + n2, rectangle.y + fontMetrics.getAscent() + n2);
        } else if (UIManager.getColor("Button.disabledForeground") instanceof Color && UIManager.getColor("Button.disabledShadow") instanceof Color) {
            graphics.setColor(UIManager.getColor("Button.disabledShadow"));
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(UIManager.getColor("Button.disabledForeground"));
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }
}

