/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MotifSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    public static final int minimumThumbSize = 6;
    public static final int defaultDividerSize = 18;
    protected static final int pad = 6;
    private int hThumbOffset = 30;
    private int vThumbOffset = 40;
    protected int hThumbWidth = 12;
    protected int hThumbHeight = 18;
    protected int vThumbWidth = 18;
    protected int vThumbHeight = 12;
    protected Color highlightColor = UIManager.getColor("SplitPane.highlight");
    protected Color shadowColor = UIManager.getColor("SplitPane.shadow");
    protected Color focusedColor = UIManager.getColor("SplitPane.activeThumb");

    public void setDividerSize(int n2) {
        Insets insets = this.getInsets();
        int n3 = 0;
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            if (insets != null) {
                n3 = insets.left + insets.right;
            }
        } else if (insets != null) {
            n3 = insets.top + insets.bottom;
        }
        if (n2 < 12 + n3) {
            this.setDividerSize(12 + n3);
        } else {
            this.vThumbHeight = this.hThumbWidth = n2 - 6 - n3;
            super.setDividerSize(n2);
        }
    }

    private boolean isInThumb(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        Dimension dimension = this.getSize();
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int n8 = dimension.width / 2;
            n7 = n8 - this.hThumbWidth / 2;
            n6 = this.hThumbOffset;
            n5 = this.hThumbWidth;
            n4 = this.hThumbHeight;
        } else {
            int n9 = dimension.height / 2;
            n7 = dimension.width - this.vThumbOffset;
            n6 = dimension.height / 2 - this.vThumbHeight / 2;
            n5 = this.vThumbWidth;
            n4 = this.vThumbHeight;
        }
        return n2 >= n7 && n2 < n7 + n5 && n3 >= n6 && n3 < n6 + n4;
    }

    static boolean access$300(MotifSplitPaneDivider motifSplitPaneDivider, int n2, int n3) {
        return motifSplitPaneDivider.isInThumb(n2, n3);
    }

    static Cursor access$400() {
        return defaultCursor;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Color color = this.getBackground();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int n2 = dimension.width / 2;
            int n3 = n2 - this.hThumbWidth / 2;
            int n4 = this.hThumbOffset;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n2 - 1, 0, n2 - 1, dimension.height);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n2, 0, n2, dimension.height);
            graphics.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            graphics.fillRect(n3 + 1, n4 + 1, this.hThumbWidth - 2, this.hThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n3, n4, n3 + this.hThumbWidth - 1, n4);
            graphics.drawLine(n3, n4 + 1, n3, n4 + this.hThumbHeight - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n3 + 1, n4 + this.hThumbHeight - 1, n3 + this.hThumbWidth - 1, n4 + this.hThumbHeight - 1);
            graphics.drawLine(n3 + this.hThumbWidth - 1, n4 + 1, n3 + this.hThumbWidth - 1, n4 + this.hThumbHeight - 2);
        } else {
            int n5 = dimension.height / 2;
            int n6 = dimension.width - this.vThumbOffset;
            int n7 = dimension.height / 2 - this.vThumbHeight / 2;
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, n5 - 1, dimension.width, n5 - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, n5, dimension.width, n5);
            graphics.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            graphics.fillRect(n6 + 1, n7 + 1, this.vThumbWidth - 1, this.vThumbHeight - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(n6, n7, n6 + this.vThumbWidth, n7);
            graphics.drawLine(n6, n7 + 1, n6, n7 + this.vThumbHeight);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n6 + 1, n7 + this.vThumbHeight, n6 + this.vThumbWidth, n7 + this.vThumbHeight);
            graphics.drawLine(n6 + this.vThumbWidth, n7 + 1, n6 + this.vThumbWidth, n7 + this.vThumbHeight - 1);
        }
        super.paint(graphics);
    }

    private JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private BasicSplitPaneDivider.DragController getDragger() {
        return this.dragger;
    }

    public MotifSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setDividerSize(this.hThumbWidth + 6);
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MotifMouseHandler(this, null);
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    static JSplitPane access$200(MotifSplitPaneDivider motifSplitPaneDivider) {
        return motifSplitPaneDivider.getSplitPane();
    }

    static BasicSplitPaneDivider.DragController access$100(MotifSplitPaneDivider motifSplitPaneDivider) {
        return motifSplitPaneDivider.getDragger();
    }

    class 1 {
    }

    private class MotifMouseHandler
    extends BasicSplitPaneDivider.MouseHandler {
        private final MotifSplitPaneDivider this$0;

        private MotifMouseHandler(MotifSplitPaneDivider motifSplitPaneDivider) {
            this.this$0 = motifSplitPaneDivider;
            super(motifSplitPaneDivider);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (MotifSplitPaneDivider.access$100(this.this$0) != null) {
                return;
            }
            if (!MotifSplitPaneDivider.access$300(this.this$0, mouseEvent.getX(), mouseEvent.getY())) {
                if (this.this$0.getCursor() != MotifSplitPaneDivider.access$400()) {
                    this.this$0.setCursor(MotifSplitPaneDivider.access$400());
                }
                return;
            }
            super.mouseMoved(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this.this$0 && MotifSplitPaneDivider.access$100(this.this$0) == null && MotifSplitPaneDivider.access$200(this.this$0).isEnabled() && MotifSplitPaneDivider.access$300(this.this$0, mouseEvent.getX(), mouseEvent.getY())) {
                super.mousePressed(mouseEvent);
            }
        }

        MotifMouseHandler(MotifSplitPaneDivider motifSplitPaneDivider, 1 var2_2) {
            this(motifSplitPaneDivider);
        }
    }
}

