/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class MotifDesktopPaneUI
extends BasicDesktopPaneUI {
    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new MotifDesktopManager(this, null);
            this.desktop.setDesktopManager(this.desktopManager);
            ((MotifDesktopManager)this.desktopManager).adjustIcons(this.desktop);
        }
    }

    public Insets getInsets(JComponent jComponent) {
        return new Insets(0, 0, 0, 0);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifDesktopPaneUI();
    }

    class 1 {
    }

    private class DragPane
    extends JComponent {
        private final MotifDesktopPaneUI this$0;

        private DragPane(MotifDesktopPaneUI motifDesktopPaneUI) {
            this.this$0 = motifDesktopPaneUI;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        DragPane(MotifDesktopPaneUI motifDesktopPaneUI, 1 var2_2) {
            this(motifDesktopPaneUI);
        }
    }

    private class MotifDesktopManager
    extends DefaultDesktopManager
    implements Serializable {
        JComponent dragPane;
        boolean usingDragPane;
        private transient JLayeredPane layeredPaneForDragPane;
        int iconWidth;
        int iconHeight;
        private final MotifDesktopPaneUI this$0;

        private MotifDesktopManager(MotifDesktopPaneUI motifDesktopPaneUI) {
            this.this$0 = motifDesktopPaneUI;
            this.usingDragPane = false;
        }

        public void beginDraggingFrame(JComponent jComponent) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane(this.this$0, null);
                }
                this.layeredPaneForDragPane = (JLayeredPane)jComponent.getParent();
                this.layeredPaneForDragPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                this.layeredPaneForDragPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        public void endDraggingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                this.layeredPaneForDragPane.remove(this.dragPane);
                this.usingDragPane = false;
                if (jComponent instanceof JInternalFrame) {
                    this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
                } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                    this.adjustBoundsForIcon((JInternalFrame.JDesktopIcon)jComponent, this.dragPane.getX(), this.dragPane.getY());
                }
            }
        }

        public void endResizingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.remove(this.dragPane);
                this.usingDragPane = false;
                this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
            }
        }

        public void beginResizingFrame(JComponent jComponent, int n2) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane(this.this$0, null);
                }
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                jLayeredPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        public void dragFrame(JComponent jComponent, int n2, int n3) {
            this.setBoundsForFrame(jComponent, n2, n3, jComponent.getWidth(), jComponent.getHeight());
        }

        public void resizeFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
            this.setBoundsForFrame(jComponent, n2, n3, n4, n5);
        }

        public void setBoundsForFrame(JComponent jComponent, int n2, int n3, int n4, int n5) {
            if (!this.usingDragPane) {
                boolean bl2 = jComponent.getWidth() != n4 || jComponent.getHeight() != n5;
                Rectangle rectangle = jComponent.getBounds();
                jComponent.setBounds(n2, n3, n4, n5);
                SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
                jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (bl2) {
                    jComponent.validate();
                }
            } else {
                Rectangle rectangle = this.dragPane.getBounds();
                this.dragPane.setBounds(n2, n3, n4, n5);
                SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
                this.dragPane.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        protected void adjustIcons(JDesktopPane jDesktopPane) {
            JInternalFrame.JDesktopIcon jDesktopIcon = new JInternalFrame.JDesktopIcon(new JInternalFrame());
            Dimension dimension = jDesktopIcon.getPreferredSize();
            this.iconWidth = dimension.width;
            this.iconHeight = dimension.height;
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            int n2 = 0;
            while (n2 < jInternalFrameArray.length) {
                jDesktopIcon = jInternalFrameArray[n2].getDesktopIcon();
                Point point = jDesktopIcon.getLocation();
                this.adjustBoundsForIcon(jDesktopIcon, point.x, point.y);
                ++n2;
            }
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Point point = jDesktopIcon.getLocation();
            this.adjustBoundsForIcon(jDesktopIcon, point.x, point.y);
            super.iconifyFrame(jInternalFrame);
        }

        protected void adjustBoundsForIcon(JInternalFrame.JDesktopIcon jDesktopIcon, int n2, int n3) {
            JDesktopPane jDesktopPane = jDesktopIcon.getDesktopPane();
            int n4 = jDesktopPane.getHeight();
            int n5 = this.iconWidth;
            int n6 = this.iconHeight;
            jDesktopPane.repaint(n2, n3, n5, n6);
            n2 = n2 < 0 ? 0 : n2;
            n3 = n3 < 0 ? 0 : n3;
            n3 = n3 >= n4 ? n4 - 1 : n3;
            int n7 = n2 / n5 * n5;
            int n8 = n4 % n6;
            int n9 = (n3 - n8) / n6 * n6 + n8;
            int n10 = n2 - n7;
            int n11 = n3 - n9;
            int n12 = n2 = n10 < n5 / 2 ? n7 : n7 + n5;
            n3 = n11 < n6 / 2 ? n9 : (n9 + n6 < n4 ? n9 + n6 : n9);
            while (this.getIconAt(jDesktopPane, jDesktopIcon, n2, n3) != null) {
                n2 += n5;
            }
            if (n2 > jDesktopPane.getWidth()) {
                return;
            }
            if (jDesktopIcon.getParent() != null) {
                this.setBoundsForFrame(jDesktopIcon, n2, n3, n5, n6);
            } else {
                jDesktopIcon.setLocation(n2, n3);
            }
        }

        MotifDesktopManager(MotifDesktopPaneUI motifDesktopPaneUI, 1 var2_2) {
            this(motifDesktopPaneUI);
        }

        protected JInternalFrame.JDesktopIcon getIconAt(JDesktopPane jDesktopPane, JInternalFrame.JDesktopIcon jDesktopIcon, int n2, int n3) {
            Object var5_5 = null;
            Component[] componentArray = jDesktopPane.getComponents();
            int n4 = 0;
            while (n4 < componentArray.length) {
                Component component = componentArray[n4];
                if (component instanceof JInternalFrame.JDesktopIcon && component != jDesktopIcon) {
                    Point point = component.getLocation();
                    if (point.x == n2 && point.y == n3) {
                        return (JInternalFrame.JDesktopIcon)component;
                    }
                }
                ++n4;
            }
            return null;
        }
    }
}

