/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class Utility {
    static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final boolean arrayRegionMatches(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (dArray[n7] != dArray2[n7 + n6]) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (nArray[n7] != nArray2[n7 + n6]) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public static final boolean arrayEquals(double[] dArray, Object object) {
        if (dArray == null) {
            return object == null;
        }
        if (!(object instanceof double[])) {
            return false;
        }
        double[] dArray2 = (double[])object;
        return dArray.length == dArray2.length && Utility.arrayRegionMatches(dArray, 0, dArray2, 0, dArray.length);
    }

    public static final boolean arrayEquals(int[] nArray, Object object) {
        if (nArray == null) {
            return object == null;
        }
        if (!(object instanceof int[])) {
            return false;
        }
        int[] nArray2 = (int[])object;
        return nArray.length == nArray2.length && Utility.arrayRegionMatches(nArray, 0, nArray2, 0, nArray.length);
    }

    public static final String hex(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        return Utility.hex(c2, stringBuffer).toString();
    }

    public static final byte[] RLEStringToByteArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        byte[] byArray = new byte[n2];
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        int n7 = 0;
        while (n7 < n2) {
            int n8;
            if (bl2) {
                n3 = string.charAt(n6++);
                n8 = (byte)(n3 >> 8);
                bl2 = false;
            } else {
                n8 = n3 & 0xFF;
                bl2 = true;
            }
            switch (n4) {
                case 0: {
                    if (n8 == -91) {
                        n4 = 1;
                        break;
                    }
                    byArray[n7++] = n8;
                    break;
                }
                case 1: {
                    if (n8 == -91) {
                        byArray[n7++] = -91;
                        n4 = 0;
                        break;
                    }
                    n5 = n8;
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    n4 = 2;
                    break;
                }
                case 2: {
                    int n9 = 0;
                    while (n9 < n5) {
                        byArray[n7++] = n8;
                        ++n9;
                    }
                    n4 = 0;
                }
            }
        }
        if (n4 != 0) {
            throw new InternalError("Bad run-length encoded byte array");
        }
        if (n6 != string.length()) {
            throw new InternalError("Excess data in RLE byte array string");
        }
        return byArray;
    }

    public static final char[] RLEStringToCharArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 2;
        while (n4 < string.length()) {
            int n5 = string.charAt(n4);
            if (n5 == 42405) {
                if ((n5 = string.charAt(++n4)) == 42405) {
                    cArray[n3++] = n5;
                } else {
                    int n6 = n5;
                    char c2 = string.charAt(++n4);
                    int n7 = 0;
                    while (n7 < n6) {
                        cArray[n3++] = c2;
                        ++n7;
                    }
                }
            } else {
                cArray[n3++] = n5;
            }
            ++n4;
        }
        if (n3 != n2) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return cArray;
    }

    public static final int[] RLEStringToIntArray(String string) {
        int n2 = Utility.getInt(string, 0);
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = string.length() / 2;
        while (n3 < n2 && n4 < n5) {
            int n6;
            if ((n6 = Utility.getInt(string, n4++)) == 42405) {
                if ((n6 = Utility.getInt(string, n4++)) == 42405) {
                    nArray[n3++] = n6;
                    continue;
                }
                int n7 = n6;
                int n8 = Utility.getInt(string, n4++);
                int n9 = 0;
                while (n9 < n7) {
                    nArray[n3++] = n8;
                    ++n9;
                }
                continue;
            }
            nArray[n3++] = n6;
        }
        if (n3 != n2 || n4 != n5) {
            throw new InternalError("Bad run-length encoded int array");
        }
        return nArray;
    }

    public static final short[] RLEStringToShortArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        short[] sArray = new short[n2];
        int n3 = 0;
        int n4 = 2;
        while (n4 < string.length()) {
            int n5 = string.charAt(n4);
            if (n5 == 42405) {
                if ((n5 = string.charAt(++n4)) == 42405) {
                    sArray[n3++] = (short)n5;
                } else {
                    int n6 = n5;
                    short s2 = (short)string.charAt(++n4);
                    int n7 = 0;
                    while (n7 < n6) {
                        sArray[n3++] = s2;
                        ++n7;
                    }
                }
            } else {
                sArray[n3++] = (short)n5;
            }
            ++n4;
        }
        if (n3 != n2) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return sArray;
    }

    static final int getInt(String string, int n2) {
        return string.charAt(2 * n2) << 16 | string.charAt(2 * n2 + 1);
    }

    public static final String arrayToRLEString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(byArray.length >> 16));
        stringBuffer.append((char)byArray.length);
        byte by = byArray[0];
        int n2 = 1;
        byte[] byArray2 = new byte[2];
        int n3 = 1;
        while (n3 < byArray.length) {
            byte by2 = byArray[n3];
            if (by2 == by && n2 < 255) {
                ++n2;
            } else {
                Utility.encodeRun(stringBuffer, by, n2, byArray2);
                by = by2;
                n2 = 1;
            }
            ++n3;
        }
        Utility.encodeRun(stringBuffer, by, n2, byArray2);
        if (byArray2[0] != 0) {
            Utility.appendEncodedByte(stringBuffer, (byte)0, byArray2);
        }
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(cArray.length >> 16));
        stringBuffer.append((char)cArray.length);
        char c2 = cArray[0];
        int n2 = 1;
        int n3 = 1;
        while (n3 < cArray.length) {
            char c3 = cArray[n3];
            if (c3 == c2 && n2 < 65535) {
                ++n2;
            } else {
                Utility.encodeRun(stringBuffer, (short)c2, n2);
                c2 = c3;
                n2 = 1;
            }
            ++n3;
        }
        Utility.encodeRun(stringBuffer, (short)c2, n2);
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Utility.appendInt(stringBuffer, nArray.length);
        int n2 = nArray[0];
        int n3 = 1;
        int n4 = 1;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n5 == n2 && n3 < 65535) {
                ++n3;
            } else {
                Utility.encodeRun(stringBuffer, n2, n3);
                n2 = n5;
                n3 = 1;
            }
            ++n4;
        }
        Utility.encodeRun(stringBuffer, n2, n3);
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(sArray.length >> 16));
        stringBuffer.append((char)sArray.length);
        short s2 = sArray[0];
        int n2 = 1;
        int n3 = 1;
        while (n3 < sArray.length) {
            short s3 = sArray[n3];
            if (s3 == s2 && n2 < 65535) {
                ++n2;
            } else {
                Utility.encodeRun(stringBuffer, s2, n2);
                s2 = s3;
                n2 = 1;
            }
            ++n3;
        }
        Utility.encodeRun(stringBuffer, s2, n2);
        return stringBuffer.toString();
    }

    private static final void encodeRun(StringBuffer stringBuffer, byte by, int n2, byte[] byArray) {
        if (n2 < 4) {
            int n3 = 0;
            while (n3 < n2) {
                if (by == -91) {
                    Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(stringBuffer, by, byArray);
                ++n3;
            }
        } else {
            if (n2 == -91) {
                if (by == -91) {
                    Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(stringBuffer, by, byArray);
                --n2;
            }
            Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
            Utility.appendEncodedByte(stringBuffer, (byte)n2, byArray);
            Utility.appendEncodedByte(stringBuffer, by, byArray);
        }
    }

    private static final void appendEncodedByte(StringBuffer stringBuffer, byte by, byte[] byArray) {
        if (byArray[0] != 0) {
            char c2 = (char)(byArray[1] << 8 | by & 0xFF);
            stringBuffer.append(c2);
            byArray[0] = 0;
        } else {
            byArray[0] = 1;
            byArray[1] = by;
        }
    }

    private static final void appendInt(StringBuffer stringBuffer, int n2) {
        stringBuffer.append((char)(n2 >>> 16));
        stringBuffer.append((char)(n2 & 0xFFFF));
    }

    private static final void encodeRun(StringBuffer stringBuffer, int n2, int n3) {
        if (n3 < 4) {
            int n4 = 0;
            while (n4 < n3) {
                if (n2 == 42405) {
                    Utility.appendInt(stringBuffer, n2);
                }
                Utility.appendInt(stringBuffer, n2);
                ++n4;
            }
        } else {
            if (n3 == 42405) {
                if (n2 == 42405) {
                    Utility.appendInt(stringBuffer, 42405);
                }
                Utility.appendInt(stringBuffer, n2);
                --n3;
            }
            Utility.appendInt(stringBuffer, 42405);
            Utility.appendInt(stringBuffer, n3);
            Utility.appendInt(stringBuffer, n2);
        }
    }

    private static final void encodeRun(StringBuffer stringBuffer, short s2, int n2) {
        if (n2 < 4) {
            int n3 = 0;
            while (n3 < n2) {
                if (s2 == 42405) {
                    stringBuffer.append('\ua5a5');
                }
                stringBuffer.append((char)s2);
                ++n3;
            }
        } else {
            if (n2 == 42405) {
                if (s2 == 42405) {
                    stringBuffer.append('\ua5a5');
                }
                stringBuffer.append((char)s2);
                --n2;
            }
            stringBuffer.append('\ua5a5');
            stringBuffer.append((char)n2);
            stringBuffer.append((char)s2);
        }
    }

    public static final boolean arrayEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Object[]) {
            return Utility.arrayEquals((Object[])object, object2);
        }
        if (object instanceof int[]) {
            return Utility.arrayEquals((int[])object, object2);
        }
        if (object instanceof double[]) {
            return Utility.arrayEquals((int[])object, object2);
        }
        return object.equals(object2);
    }

    public static final boolean objectEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static final boolean arrayRegionMatches(Object[] objectArray, int n2, Object[] objectArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (!Utility.arrayEquals(objectArray[n7], objectArray2[n7 + n6])) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public static final boolean arrayEquals(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return object == null;
        }
        if (!(object instanceof Object[])) {
            return false;
        }
        Object[] objectArray2 = (Object[])object;
        return objectArray.length == objectArray2.length && Utility.arrayRegionMatches(objectArray, 0, objectArray2, 0, objectArray.length);
    }

    public static final String formatForSource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (n2 > 0) {
                stringBuffer.append("+\n");
            }
            stringBuffer.append("        \"");
            int n3 = 11;
            while (n2 < string.length() && n3 < 80) {
                char c2;
                if ((c2 = string.charAt(n2++)) < ' ' || c2 == '\"') {
                    stringBuffer.append('\\');
                    stringBuffer.append(HEX_DIGIT[(c2 & 0x1C0) >> 6]);
                    stringBuffer.append(HEX_DIGIT[(c2 & 0x38) >> 3]);
                    stringBuffer.append(HEX_DIGIT[c2 & 7]);
                    n3 += 4;
                    continue;
                }
                if (c2 <= '~') {
                    stringBuffer.append(c2);
                    ++n3;
                    continue;
                }
                stringBuffer.append("\\u");
                stringBuffer.append(HEX_DIGIT[(c2 & 0xF000) >> 12]);
                stringBuffer.append(HEX_DIGIT[(c2 & 0xF00) >> 8]);
                stringBuffer.append(HEX_DIGIT[(c2 & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGIT[c2 & 0xF]);
                n3 += 6;
            }
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public static final String hex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Utility.hex(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static final String hex(StringBuffer stringBuffer) {
        return Utility.hex(stringBuffer.toString());
    }

    public static final StringBuffer hex(char c2, StringBuffer stringBuffer) {
        int n2 = 12;
        while (n2 >= 0) {
            stringBuffer.append(HEX_DIGIT[(byte)(c2 >> n2 & 0xF)]);
            n2 -= 4;
        }
        return stringBuffer;
    }

    public static final StringBuffer hex(String string, StringBuffer stringBuffer) {
        if (string != null && stringBuffer != null) {
            int n2 = string.length();
            int n3 = 0;
            Utility.hex(string.charAt(n3), stringBuffer);
            while (n3 < n2) {
                stringBuffer.append(',');
                Utility.hex(string.charAt(n3++), stringBuffer);
            }
        }
        return stringBuffer;
    }
}

