/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateIssuerUniqueIdentity;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateSubjectUniqueIdentity;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.OIDMap;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X509AttributeName;

public class X509CertInfo
implements CertAttrSet {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected CertificateIssuerName issuer = null;
    protected CertificateValidity interval = null;
    protected CertificateSubjectName subject = null;
    protected CertificateX509Key pubKey = null;
    protected CertificateIssuerUniqueIdentity issuerUniqueId = null;
    protected CertificateSubjectUniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final Hashtable map = new Hashtable();

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.rawCertInfo.length) {
            n2 += this.rawCertInfo[n3] * n3;
            ++n3;
        }
        return n2;
    }

    static {
        map.put(VERSION, new Integer(1));
        map.put(SERIAL_NUMBER, new Integer(2));
        map.put(ALGORITHM_ID, new Integer(3));
        map.put(ISSUER, new Integer(4));
        map.put(VALIDITY, new Integer(5));
        map.put(SUBJECT, new Integer(6));
        map.put(KEY, new Integer(7));
        map.put(ISSUER_ID, new Integer(8));
        map.put(SUBJECT_ID, new Integer(9));
        map.put(EXTENSIONS, new Integer(10));
    }

    public X509CertInfo() {
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.rawCertInfo = derOutputStream.toByteArray();
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public X509CertInfo(byte[] byArray) throws CertificateParsingException {
        try {
            DerValue derValue = new DerValue(byArray);
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw certificateParsingException;
        }
    }

    public void decode(InputStream inputStream) throws CertificateParsingException, IOException {
        DerValue derValue = new DerValue(inputStream);
        this.parse(derValue);
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.rawCertInfo == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.emit(derOutputStream);
            this.rawCertInfo = derOutputStream.toByteArray();
        }
        outputStream.write((byte[])this.rawCertInfo.clone());
    }

    private void setAlgorithmId(Object object) throws CertificateException {
        if (!(object instanceof CertificateAlgorithmId)) {
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        this.algId = (CertificateAlgorithmId)object;
    }

    private void setExtensions(Object object) throws CertificateException {
        if (this.version.compare(2) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateExtensions)) {
            throw new CertificateException("Extensions class type invalid.");
        }
        this.extensions = (CertificateExtensions)object;
    }

    private void setIssuer(Object object) throws CertificateException {
        if (!(object instanceof CertificateIssuerName)) {
            throw new CertificateException("Issuer class type invalid.");
        }
        this.issuer = (CertificateIssuerName)object;
    }

    private void setIssuerUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateIssuerUniqueIdentity)) {
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        this.issuerUniqueId = (CertificateIssuerUniqueIdentity)object;
    }

    private void setKey(Object object) throws CertificateException {
        if (!(object instanceof CertificateX509Key)) {
            throw new CertificateException("Key class type invalid.");
        }
        this.pubKey = (CertificateX509Key)object;
    }

    private void setSerialNumber(Object object) throws CertificateException {
        if (!(object instanceof CertificateSerialNumber)) {
            throw new CertificateException("SerialNumber class type invalid.");
        }
        this.serialNum = (CertificateSerialNumber)object;
    }

    private void setSubject(Object object) throws CertificateException {
        if (!(object instanceof CertificateSubjectName)) {
            throw new CertificateException("Subject class type invalid.");
        }
        this.subject = (CertificateSubjectName)object;
    }

    private void setSubjectUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateSubjectUniqueIdentity)) {
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
        this.subjectUniqueId = (CertificateSubjectUniqueIdentity)object;
    }

    private void setValidity(Object object) throws CertificateException {
        if (!(object instanceof CertificateValidity)) {
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        this.interval = (CertificateValidity)object;
    }

    private void setVersion(Object object) throws CertificateException {
        if (!(object instanceof CertificateVersion)) {
            throw new CertificateException("Version class type invalid.");
        }
        this.version = (CertificateVersion)object;
    }

    public boolean equals(Object object) {
        if (object instanceof X509CertInfo) {
            return this.equals((X509CertInfo)object);
        }
        return false;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        stringBuffer.append("  " + this.version.toString() + "\n");
        stringBuffer.append("  Subject: " + this.subject.toString() + "\n");
        stringBuffer.append("  Signature Algorithm: " + this.algId.toString() + "\n");
        stringBuffer.append("  Key:  " + this.pubKey.toString() + "\n");
        stringBuffer.append("  " + this.interval.toString() + "\n");
        stringBuffer.append("  Issuer: " + this.issuer.toString() + "\n");
        stringBuffer.append("  " + this.serialNum.toString() + "\n");
        if (this.issuerUniqueId != null) {
            stringBuffer.append("  Issuer Id:\n" + this.issuerUniqueId.toString() + "\n");
        }
        if (this.subjectUniqueId != null) {
            stringBuffer.append("  Subject Id:\n" + this.subjectUniqueId.toString() + "\n");
        }
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\nCertificate Extensions: " + objectArray.length);
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append("\n[" + (n2 + 1) + "]: ");
                Extension extension = (Extension)objectArray[n2];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray != null) {
                            DerOutputStream derOutputStream = new DerOutputStream();
                            derOutputStream.putOctetString(byArray);
                            byArray = derOutputStream.toByteArray();
                            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                            stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        }
                    } else {
                        stringBuffer.append(extension.toString());
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
                ++n2;
            }
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private int attributeMap(String string) {
        Integer n2 = (Integer)map.get(string);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void delete(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n2 = this.attributeMap(x509AttributeName.getPrefix());
        if (n2 == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        switch (n2) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(x509AttributeName.getSuffix());
                break;
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(x509AttributeName.getSuffix());
                break;
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(x509AttributeName.getSuffix());
                break;
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    this.issuer = null;
                    break;
                }
                this.issuer.delete(x509AttributeName.getSuffix());
                break;
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(x509AttributeName.getSuffix());
                break;
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    this.subject = null;
                    break;
                }
                this.subject.delete(x509AttributeName.getSuffix());
                break;
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(x509AttributeName.getSuffix());
                break;
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    this.issuerUniqueId = null;
                    break;
                }
                this.issuerUniqueId.delete(x509AttributeName.getSuffix());
                break;
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    this.subjectUniqueId = null;
                    break;
                }
                this.subjectUniqueId.delete(x509AttributeName.getSuffix());
                break;
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    this.extensions = null;
                    break;
                }
                if (this.extensions == null) break;
                this.extensions.delete(x509AttributeName.getSuffix());
            }
        }
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        attributeNameEnumeration.addElement(ALGORITHM_ID);
        attributeNameEnumeration.addElement(ISSUER);
        attributeNameEnumeration.addElement(VALIDITY);
        attributeNameEnumeration.addElement(SUBJECT);
        attributeNameEnumeration.addElement(KEY);
        attributeNameEnumeration.addElement(ISSUER_ID);
        attributeNameEnumeration.addElement(SUBJECT_ID);
        attributeNameEnumeration.addElement(EXTENSIONS);
        return attributeNameEnumeration.elements();
    }

    private void emit(DerOutputStream derOutputStream) throws CertificateException, IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.version.encode(derOutputStream2);
        this.serialNum.encode(derOutputStream2);
        this.algId.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(derOutputStream2);
        this.interval.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(derOutputStream2);
        this.pubKey.encode(derOutputStream2);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(derOutputStream2);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(derOutputStream2);
        }
        if (this.extensions != null) {
            this.extensions.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public X509CertInfo(DerValue derValue) throws CertificateParsingException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw certificateParsingException;
        }
    }

    private void parse(DerValue derValue) throws CertificateParsingException, IOException {
        if (derValue.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = derValue.toByteArray();
        DerInputStream derInputStream = derValue.data;
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(derValue2);
            derValue2 = derInputStream.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(derValue2);
        this.algId = new CertificateAlgorithmId(derInputStream);
        this.issuer = new CertificateIssuerName(derInputStream);
        String string = this.issuer.toString();
        if (string == null || string.length() == 0) {
            throw new CertificateParsingException("Empty issuer DN not allowed in X509Certificates");
        }
        this.interval = new CertificateValidity(derInputStream);
        this.subject = new CertificateSubjectName(derInputStream);
        String string2 = this.subject.toString();
        if (this.version.compare(0) == 0 && (string2 == null || string2.length() == 0)) {
            throw new CertificateParsingException("Empty subject DN not allowed in v1 certificate");
        }
        this.pubKey = new CertificateX509Key(derInputStream);
        if (derInputStream.available() != 0) {
            if (this.version.compare(0) == 0) {
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (derValue2.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(derValue2.data);
        }
        this.verifyCert(this.subject, this.extensions);
    }

    public boolean equals(X509CertInfo x509CertInfo) {
        if (this == x509CertInfo) {
            return true;
        }
        if (this.rawCertInfo == null || x509CertInfo.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != x509CertInfo.rawCertInfo.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.rawCertInfo.length) {
            if (this.rawCertInfo[n2] != x509CertInfo.rawCertInfo[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Object get(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n2 = this.attributeMap(x509AttributeName.getPrefix());
        if (n2 == 0) {
            throw new CertificateParsingException("Attribute name not recognized: " + string);
        }
        switch (n2) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.version;
                }
                return this.version.get(x509AttributeName.getSuffix());
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.serialNum;
                }
                return this.serialNum.get(x509AttributeName.getSuffix());
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.algId;
                }
                return this.algId.get(x509AttributeName.getSuffix());
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.issuer;
                }
                return this.issuer.get(x509AttributeName.getSuffix());
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.interval;
                }
                return this.interval.get(x509AttributeName.getSuffix());
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.subject;
                }
                return this.subject.get(x509AttributeName.getSuffix());
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.pubKey;
                }
                return this.pubKey.get(x509AttributeName.getSuffix());
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.issuerUniqueId;
                }
                if (this.issuerUniqueId == null) {
                    return null;
                }
                return this.issuerUniqueId.get(x509AttributeName.getSuffix());
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.subjectUniqueId;
                }
                if (this.subjectUniqueId == null) {
                    return null;
                }
                return this.subjectUniqueId.get(x509AttributeName.getSuffix());
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    return this.extensions;
                }
                if (this.extensions == null) {
                    return null;
                }
                return this.extensions.get(x509AttributeName.getSuffix());
            }
        }
        return null;
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n2 = this.attributeMap(x509AttributeName.getPrefix());
        if (n2 == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        switch (n2) {
            case 1: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setVersion(object);
                    break;
                }
                this.version.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 2: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSerialNumber(object);
                    break;
                }
                this.serialNum.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 3: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setAlgorithmId(object);
                    break;
                }
                this.algId.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 4: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setIssuer(object);
                    break;
                }
                this.issuer.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 5: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setValidity(object);
                    break;
                }
                this.interval.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 6: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSubject(object);
                    break;
                }
                this.subject.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 7: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setKey(object);
                    break;
                }
                this.pubKey.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 8: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setIssuerUniqueId(object);
                    break;
                }
                this.issuerUniqueId.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 9: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setSubjectUniqueId(object);
                    break;
                }
                this.subjectUniqueId.set(x509AttributeName.getSuffix(), object);
                break;
            }
            case 10: {
                if (x509AttributeName.getSuffix() == null) {
                    this.setExtensions(object);
                    break;
                }
                if (this.extensions == null) {
                    this.extensions = new CertificateExtensions();
                }
                this.extensions.set(x509AttributeName.getSuffix(), object);
            }
        }
    }

    private void verifyCert(CertificateSubjectName certificateSubjectName, CertificateExtensions certificateExtensions) throws CertificateParsingException {
        if (certificateSubjectName == null || certificateSubjectName.toString() == null || certificateSubjectName.toString().length() == 0) {
            if (certificateExtensions == null) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions");
            }
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
            Object var4_4 = null;
            GeneralNames generalNames = null;
            try {
                subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)certificateExtensions.get("SubjectAlternativeName");
                generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            }
            catch (IOException iOException) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent");
            }
            if (generalNames == null || generalNames.isEmpty()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty");
            }
            if (!subjectAlternativeNameExtension.isCritical()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty");
            }
        }
    }
}

