/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.KeyUsageExtension;

public class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static ObjectIdentifier NetscapeCertType_Id;
    private boolean[] bitString;
    private static MapEntry[] mMapData;
    private static final Vector mAttributeNames;

    static {
        try {
            NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mMapData = new MapEntry[]{new MapEntry(SSL_CLIENT, 0), new MapEntry(SSL_SERVER, 1), new MapEntry(S_MIME, 2), new MapEntry(OBJECT_SIGNING, 3), new MapEntry(SSL_CA, 5), new MapEntry(S_MIME_CA, 6), new MapEntry(OBJECT_SIGNING_CA, 7)};
        mAttributeNames = new Vector();
        int n2 = 0;
        while (n2 < mMapData.length) {
            mAttributeNames.addElement(NetscapeCertTypeExtension.mMapData[n2].mName);
            ++n2;
        }
    }

    public NetscapeCertTypeExtension() {
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.bitString));
        this.extensionValue = derOutputStream.toByteArray();
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
        Boolean bl2 = new Boolean(true);
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                keyUsageExtension.set("digital_signature", bl2);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                keyUsageExtension.set("key_encipherment", bl2);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                keyUsageExtension.set("key_certsign", bl2);
            }
        }
        catch (IOException iOException) {}
        return keyUsageExtension.getBits();
    }

    private boolean isSet(int n2) {
        return this.bitString[n2];
    }

    private void set(int n2, boolean bl2) {
        if (n2 >= this.bitString.length) {
            boolean[] blArray = new boolean[n2 + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n2] = bl2;
    }

    public NetscapeCertTypeExtension(byte[] byArray) throws IOException {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(boolean[] blArray) throws IOException {
        this.bitString = blArray;
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        String string = super.toString() + "NetscapeCertType [\n";
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                string = string + "   SSL client\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                string = string + "   SSL server\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                string = string + "   S/MIME\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                string = string + "   Object Signing\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                string = string + "   SSL CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                string = string + "   S/MIME CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                string = string + "   Object Signing CA";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    private static int getPosition(String string) throws IOException {
        int n2 = 0;
        while (n2 < mMapData.length) {
            if (string.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[n2].mName)) {
                return NetscapeCertTypeExtension.mMapData[n2].mPosition;
            }
            ++n2;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    public void delete(String string) throws IOException {
        this.set(NetscapeCertTypeExtension.getPosition(string), false);
        this.encodeThis();
    }

    public Enumeration getElements() {
        return mAttributeNames.elements();
    }

    public NetscapeCertTypeExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = NetscapeCertType_Id;
        this.critical = bl2;
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = Array.getByte(object, n3);
            ++n3;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.bitString = derValue.getUnalignedBitString().toBooleanArray();
    }

    public Object get(String string) throws IOException {
        return new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(string)));
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl2 = (Boolean)object;
        this.set(NetscapeCertTypeExtension.getPosition(string), bl2);
        this.encodeThis();
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String string, int n2) {
            this.mName = string;
            this.mPosition = n2;
        }
    }
}

