/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String IDENT = "x509.info.extensions.InhibitAnyPolicy";
    public static ObjectIdentifier AnyPolicy_Id;
    public static final String NAME = "InhibitAnyPolicy";
    public static final String SKIP_CERTS = "skip_certs";
    private int skipCerts = Integer.MAX_VALUE;

    static {
        try {
            AnyPolicy_Id = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {}
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.skipCerts);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public InhibitAnyPolicyExtension(int n2) throws IOException {
        if (n2 < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = n2 == -1 ? Integer.MAX_VALUE : n2;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        String string = super.toString() + "InhibitAnyPolicy: " + this.skipCerts + "\n";
        return string;
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            throw new IOException("Attribute skip_certs may not be deleted.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(SKIP_CERTS);
        return attributeNameEnumeration.elements();
    }

    public InhibitAnyPolicyExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        if (!bl2.booleanValue()) {
            throw new IOException("Criticality cannot be false for InhibitAnyPolicy");
        }
        this.critical = bl2;
        if (!(object instanceof byte[])) {
            throw new IOException("Invalid argument type for InhibitAnyPolicy");
        }
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        System.arraycopy(object, 0, byArray, 0, n2);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 2) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: data not integer");
        }
        if (derValue.data == null) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: null data");
        }
        int n3 = derValue.getInteger();
        if (n3 < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = n3 == -1 ? Integer.MAX_VALUE : n3;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            return new Integer(this.skipCerts);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(SKIP_CERTS)) {
            if (!(object instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            int n2 = (Integer)object;
            if (n2 < -1) {
                throw new IOException("Invalid value for skipCerts");
            }
            this.skipCerts = n2 == -1 ? Integer.MAX_VALUE : n2;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.encodeThis();
    }
}

