/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyInformation;

public class CertificatePoliciesExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.CertificatePolicies";
    public static final String NAME = "CertificatePolicies";
    public static final String POLICIES = "policies";
    private Vector certPolicies;

    private void encodeThis() throws IOException {
        if (this.certPolicies == null || this.certPolicies.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            int n2 = 0;
            while (n2 < this.certPolicies.size()) {
                ((PolicyInformation)this.certPolicies.elementAt(n2)).encode(derOutputStream2);
                ++n2;
            }
            derOutputStream.write((byte)48, derOutputStream2);
            this.extensionValue = derOutputStream.toByteArray();
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificatePolicies_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        if (this.certPolicies == null) {
            return "";
        }
        String string = super.toString();
        string = string + "CertificatePolicies [\n";
        Enumeration enumeration = this.certPolicies.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((PolicyInformation)enumeration.nextElement()).toString();
        }
        string = string + "]\n";
        return string;
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(POLICIES)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
        }
        this.certPolicies = null;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(POLICIES);
        return attributeNameEnumeration.elements();
    }

    public CertificatePoliciesExtension(Vector vector) throws IOException {
        this(Boolean.FALSE, vector);
    }

    public CertificatePoliciesExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = bl2;
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = Array.getByte(object, n3);
            ++n3;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for CertificatePoliciesExtension.");
        }
        this.certPolicies = new Vector(1, 1);
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            PolicyInformation policyInformation = new PolicyInformation(derValue2);
            this.certPolicies.addElement(policyInformation);
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(POLICIES)) {
            return this.certPolicies;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(POLICIES)) {
            if (!(object instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
        }
        this.certPolicies = (Vector)object;
        this.encodeThis();
    }

    public CertificatePoliciesExtension(Boolean bl2, Vector vector) throws IOException {
        this.certPolicies = vector;
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = bl2;
        this.encodeThis();
    }
}

