/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS = new HostnameChecker(1);
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP = new HostnameChecker(2);
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;

    private HostnameChecker(byte by) {
        this.checkType = by;
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isHexDigit(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    private static boolean isIpAddress(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        if (HostnameChecker.isDigit(string.charAt(0))) {
            return true;
        }
        if (!HostnameChecker.isHexDigit(string.charAt(n2 - 1))) {
            return false;
        }
        int n3 = string.indexOf(58);
        return n3 != -1 && string.lastIndexOf(58) != n3;
    }

    public static HostnameChecker getInstance(byte by) {
        if (by == 1) {
            return INSTANCE_TLS;
        }
        if (by == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + by);
    }

    private boolean isMatched(String string, String string2) {
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(string, string2);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(string, string2);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean matchAllWildcards(String var0, String var1_1) {
        var0 = var0.toLowerCase();
        var1_1 = var1_1.toLowerCase();
        var2_2 = new StringTokenizer(var0, ".");
        var3_3 = new StringTokenizer(var1_1, ".");
        if (var2_2.countTokens() == var3_3.countTokens()) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (HostnameChecker.matchWildCards(var2_2.nextToken(), var3_3.nextToken())) continue;
            return false;
lbl9:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl10:
        // 1 sources

        return true;
    }

    private static boolean matchLeftmostWildcard(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int n2 = string2.indexOf(".");
        int n3 = string.indexOf(".");
        if (n2 == -1) {
            n2 = string2.length();
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        if (HostnameChecker.matchWildCards(string.substring(0, n3), string2.substring(0, n2))) {
            return string2.substring(n2).equals(string.substring(n3));
        }
        return false;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n2 = string2.indexOf("*");
        if (n2 == -1) {
            return string.equals(string2);
        }
        boolean bl2 = true;
        String string3 = "";
        String string4 = string2;
        while (n2 != -1) {
            string3 = string4.substring(0, n2);
            string4 = string4.substring(n2 + 1);
            int n3 = string.indexOf(string3);
            if (n3 == -1 || bl2 && n3 != 0) {
                return false;
            }
            bl2 = false;
            string = string.substring(n3 + string3.length());
            n2 = string4.indexOf("*");
        }
        return string.endsWith(string4);
    }

    public void match(String string, X509Certificate x509Certificate) throws CertificateException {
        if (HostnameChecker.isIpAddress(string)) {
            HostnameChecker.matchIP(string, x509Certificate);
        } else {
            this.matchDNS(string, x509Certificate);
        }
    }

    private void matchDNS(String string, X509Certificate x509Certificate) throws CertificateException {
        X500Name x500Name;
        Object object;
        Object object2;
        Collection collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean bl2 = false;
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (List)object2.next();
                if ((Integer)object.get(0) != 2) continue;
                bl2 = true;
                String string2 = (String)object.get(1);
                if (!this.isMatched(string, string2)) continue;
                return;
            }
            if (bl2) {
                throw new CertificateException("No subject alternative DNS name matching " + string + " found.");
            }
        }
        if ((object2 = (x500Name = HostnameChecker.getSubjectX500Name(x509Certificate)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
            try {
                if (this.isMatched(string, ((DerValue)object2).getAsString())) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = "No name matching " + string + " found";
        throw new CertificateException((String)object);
    }

    private static void matchIP(String string, X509Certificate x509Certificate) throws CertificateException {
        Collection collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2;
            List list = (List)iterator.next();
            if ((Integer)list.get(0) != 7 || !string.equalsIgnoreCase(string2 = (String)list.get(1))) continue;
            return;
        }
        throw new CertificateException("No subject alternative names matching IP address " + string + " found");
    }

    public static X500Name getSubjectX500Name(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            Principal principal = x509Certificate.getSubjectDN();
            if (principal instanceof X500Name) {
                return (X500Name)principal;
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            return new X500Name(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw (CertificateParsingException)new CertificateParsingException().initCause(iOException);
        }
    }
}

