/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509CertImpl;

public class X509CertificatePair {
    private static final byte TAG_FORWARD = 0;
    private static final byte TAG_REVERSE = 1;
    private X509Certificate forward;
    private X509Certificate reverse;
    private byte[] encoded;

    public X509CertificatePair() {
    }

    private void checkPair() throws CertificateException {
        if (this.forward == null || this.reverse == null) {
            return;
        }
        if (!this.forward.getIssuerDN().equals(this.reverse.getSubjectDN()) || !this.reverse.getIssuerDN().equals(this.forward.getSubjectDN())) {
            throw new CertificateException("subject and issuer names in forward and reverse certificates do not match");
        }
        try {
            PublicKey publicKey = this.reverse.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey) || ((DSAPublicKey)publicKey).getParams() != null) {
                this.forward.verify(publicKey);
            }
            if (!((publicKey = this.forward.getPublicKey()) instanceof DSAPublicKey) || ((DSAPublicKey)publicKey).getParams() != null) {
                this.reverse.verify(publicKey);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("invalid signature: " + generalSecurityException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            if (this.encoded == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.encoded = derOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        return this.encoded;
    }

    public X509CertificatePair(byte[] byArray) throws CertificateException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
        this.checkPair();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X.509 Certificate Pair: [\n");
        if (this.forward != null) {
            stringBuffer.append("  Forward: " + this.forward + "\n");
        }
        if (this.reverse != null) {
            stringBuffer.append("  Reverse: " + this.reverse + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public void setForward(X509Certificate x509Certificate) throws CertificateException {
        this.checkPair();
        this.forward = x509Certificate;
    }

    public void setReverse(X509Certificate x509Certificate) throws CertificateException {
        this.checkPair();
        this.reverse = x509Certificate;
    }

    private void emit(DerOutputStream derOutputStream) throws IOException, CertificateEncodingException {
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.forward != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putDerValue(new DerValue(this.forward.getEncoded()));
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (this.reverse != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putDerValue(new DerValue(this.reverse.getEncoded()));
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }

    /*
     * Unable to fully structure code
     */
    private void parse(DerValue var1_1) throws IOException, CertificateException {
        if (var1_1.tag == 48) ** GOTO lbl22
        throw new IOException("Sequence tag missing for X509CertificatePair");
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.data.getDerValue();
            var3_3 = (byte)(var2_2.tag & 31);
            switch (var3_3) {
                case 0: {
                    if (!var2_2.isContextSpecific() || !var2_2.isConstructed()) continue block4;
                    if (this.forward != null) {
                        throw new IOException("Duplicate forward certificate in X509CertificatePair");
                    }
                    var2_2 = var2_2.data.getDerValue();
                    this.forward = new X509CertImpl(var2_2.toByteArray());
                    break;
                }
                case 1: {
                    if (!var2_2.isContextSpecific() || !var2_2.isConstructed()) continue block4;
                    if (this.reverse != null) {
                        throw new IOException("Duplicate reverse certificate in X509CertificatePair");
                    }
                    var2_2 = var2_2.data.getDerValue();
                    this.reverse = new X509CertImpl(var2_2.toByteArray());
                    break;
                }
                default: {
                    throw new IOException("Invalid encoding of X509CertificatePair");
                }
            }
lbl22:
            // 5 sources

            ** while (var1_1.data != null && var1_1.data.available() != 0)
        }
lbl23:
        // 1 sources

        if (this.forward == null && this.reverse == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
    }

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertificateException {
        if (x509Certificate == null && x509Certificate2 == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
        this.forward = x509Certificate;
        this.reverse = x509Certificate2;
        this.checkPair();
    }
}

