/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import sun.security.util.Debug;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X509CertImpl;

public class Vertex {
    private static final Debug debug = Debug.getInstance("certpath");
    private Certificate cert;
    private int index;
    private Throwable throwable;

    public int getIndex() {
        return this.index;
    }

    void setIndex(int n2) {
        this.index = n2;
    }

    public String certToString() {
        String string;
        block15: {
            Object object;
            X509CertImpl x509CertImpl;
            block14: {
                boolean[] blArray;
                string = "";
                if (this.cert == null || !(this.cert instanceof X509Certificate)) {
                    return "Cert:       Not an X509Certificate\n";
                }
                x509CertImpl = null;
                try {
                    x509CertImpl = new X509CertImpl(this.cert.getEncoded());
                }
                catch (CertificateException certificateException) {
                    if (debug != null) {
                        debug.println("Vertex.certToString() unexpected exception");
                        certificateException.printStackTrace();
                    }
                    return string;
                }
                string = "Issuer:     " + x509CertImpl.getIssuerDN().toString() + "\n";
                string = string + "Subject:    " + x509CertImpl.getSubjectDN().toString() + "\n";
                string = string + "SerialNum:  " + x509CertImpl.getSerialNumber().toString(16) + "\n";
                string = string + "Expires:    " + x509CertImpl.getNotAfter().toString() + "\n";
                boolean[] blArray2 = x509CertImpl.getIssuerUniqueID();
                if (blArray2 != null) {
                    string = string + "IssuerUID:  ";
                    int n2 = 0;
                    while (n2 < blArray2.length) {
                        string = string + (blArray2[n2] ? 1 : 0);
                        ++n2;
                    }
                    string = string + "\n";
                }
                if ((blArray = x509CertImpl.getSubjectUniqueID()) != null) {
                    string = string + "SubjectUID: ";
                    int n3 = 0;
                    while (n3 < blArray.length) {
                        string = string + (blArray[n3] ? 1 : 0);
                        ++n3;
                    }
                    string = string + "\n";
                }
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
                try {
                    subjectKeyIdentifierExtension = x509CertImpl.getSubjectKeyIdentifierExtension();
                    if (subjectKeyIdentifierExtension != null) {
                        object = (KeyIdentifier)subjectKeyIdentifierExtension.get("key_id");
                        string = string + "SubjKeyID:  " + ((KeyIdentifier)object).toString();
                    }
                }
                catch (Exception exception) {
                    if (debug == null) break block14;
                    debug.println("Vertex.certToString() unexpected exception");
                    exception.printStackTrace();
                }
            }
            object = null;
            try {
                object = x509CertImpl.getAuthorityKeyIdentifierExtension();
                if (object != null) {
                    KeyIdentifier keyIdentifier = (KeyIdentifier)((AuthorityKeyIdentifierExtension)object).get("key_id");
                    string = string + "AuthKeyID:  " + keyIdentifier.toString();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block15;
                debug.println("Vertex.certToString() 2 unexpected exception");
                exception.printStackTrace();
            }
        }
        return string;
    }

    public String indexToString() {
        String string = "Index:      " + this.index + "\n";
        return string;
    }

    public String moreToString() {
        String string = "Last cert?  ";
        string = string + (this.index == -1 ? "Yes" : "No");
        string = string + "\n";
        return string;
    }

    public String throwableToString() {
        String string = "Exception:  ";
        string = this.throwable != null ? string + this.throwable.toString() : string + "null";
        string = string + "\n";
        return string;
    }

    public String toString() {
        return this.certToString() + this.throwableToString() + this.indexToString();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    Vertex(Certificate certificate) {
        this.cert = certificate;
        this.index = -1;
    }
}

