/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.PKCS7;
import sun.security.provider.certpath.X509CertPath;
import sun.security.util.DerValue;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private static char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};

    private boolean isBase64(InputStream inputStream) throws IOException {
        if (inputStream.available() >= 10) {
            inputStream.mark(10);
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            int n11 = inputStream.read();
            inputStream.reset();
            return n2 == 45 && n3 == 45 && n4 == 45 && n5 == 45 && n6 == 45 && n7 == 66 && n8 == 69 && n9 == 71 && n10 == 73 && n11 == 78;
        }
        return false;
    }

    private byte[] base64_to_binary(InputStream inputStream) throws IOException {
        long l2 = 0L;
        inputStream.mark(inputStream.available());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
        String string = this.readLine(bufferedReader);
        if (string == null || !string.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        l2 += (long)string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(bufferedReader)) != null && !string.startsWith("-----END")) {
            stringBuffer.append(string);
        }
        if (string == null) {
            throw new IOException("Unsupported encoding");
        }
        l2 += (long)string.length();
        inputStream.reset();
        inputStream.skip(l2 += (long)stringBuffer.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(stringBuffer.toString());
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Iterator engineGetCertPathEncodings() {
        return X509CertPath.getEncodingsStatic();
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        int n2;
        int n3 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        do {
            n2 = bufferedReader.read();
            if (bl2 && n3 < endBoundary.length) {
                boolean bl4 = bl2 = (char)n2 == endBoundary[n3++];
            }
            if (!bl3) {
                bl3 = bl2 && n3 == endBoundary.length;
            }
            stringBuffer.append((char)n2);
        } while (n2 != -1 && n2 != 10 && n2 != 13);
        if (!bl3 && n2 == -1) {
            return null;
        }
        if (n2 == 13) {
            bufferedReader.mark(1);
            int n4 = bufferedReader.read();
            if (n4 == 10) {
                stringBuffer.append((char)n2);
            } else {
                bufferedReader.reset();
            }
        }
        return stringBuffer.toString();
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CRLImpl(byArray);
            }
            return new X509CRLImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertPath(new ByteArrayInputStream(byArray));
            }
            return new X509CertPath(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        return new X509CertPath(list);
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertImpl(byArray);
            }
            return new X509CertImpl(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(inputStream)));
            }
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(inputStream)));
            }
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CertificateException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7CRL(InputStream inputStream) throws CRLException, IOException {
        ArrayList arrayList = new ArrayList();
        boolean bl2 = true;
        while (inputStream.available() != 0) {
            block6: {
                InputStream inputStream2 = inputStream;
                if (this.isBase64(inputStream)) {
                    inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
                }
                if (bl2) {
                    inputStream2.mark(inputStream2.available());
                }
                try {
                    arrayList.add(new X509CRLImpl(inputStream2));
                }
                catch (CRLException cRLException) {
                    if (!bl2) break block6;
                    inputStream2.reset();
                    PKCS7 pKCS7 = new PKCS7(inputStream2);
                    Object[] objectArray = pKCS7.getCRLs();
                    if (objectArray != null) {
                        return Arrays.asList(objectArray);
                    }
                    return new ArrayList(0);
                }
            }
            bl2 = false;
        }
        return arrayList;
    }

    private Collection parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException, IOException {
        ArrayList arrayList = new ArrayList();
        boolean bl2 = true;
        while (inputStream.available() != 0) {
            InputStream inputStream2 = inputStream;
            if (this.isBase64(inputStream2)) {
                inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
            }
            if (bl2) {
                inputStream2.mark(inputStream2.available());
            }
            try {
                arrayList.add(new X509CertImpl(new DerValue(inputStream2)));
            }
            catch (CertificateException certificateException) {
                Throwable throwable = certificateException.getCause();
                if (bl2 && throwable != null && throwable instanceof IOException) {
                    inputStream2.reset();
                    PKCS7 pKCS7 = new PKCS7(inputStream2);
                    Object[] objectArray = pKCS7.getCertificates();
                    if (objectArray != null) {
                        return Arrays.asList(objectArray);
                    }
                    return new ArrayList(0);
                }
                throw certificateException;
            }
            bl2 = false;
        }
        return arrayList;
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertPath(new ByteArrayInputStream(byArray), string);
            }
            return new X509CertPath(inputStream, string);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }
}

