/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private static final boolean eagerHttpFallback = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.transport.proxy.eagerHttpFallback"));
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    private static long getConnectTimeout() {
        return (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean bl2 = false;
        try {
            Boolean bl3;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl3 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && string != null && string.length() > 0) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        if (bl2) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    public ServerSocket createServerSocket(int n2) throws IOException {
        return this.initialFactory.createServerSocket(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket createSocket(String var1_1, int var2_2) throws IOException {
        block50: {
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "host: " + var1_1 + ", port: " + var2_2);
            }
            if (this.altFactoryList.size() == 0) {
                return this.initialFactory.createSocket(var1_1, var2_2);
            }
            var3_3 = (RMISocketFactory)this.successTable.get(var1_1);
            if (var3_3 != null) {
                if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF) == false) return var3_3.createSocket(var1_1, var2_2);
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "previously successful factory found: " + var3_3);
                return var3_3.createSocket(var1_1, var2_2);
            }
            var4_4 = null;
            var5_5 = null;
            var6_6 = new AsyncConnector(this, this.initialFactory, var1_1, var2_2, AccessController.getContext());
            var7_7 /* !! */  = null;
            try {
                var8_8 = var6_6;
                synchronized (var8_8) {
                    var9_11 = (Thread)AccessController.doPrivileged(new NewThreadAction(var6_6, "AsyncConnector", true));
                    var9_11.start();
                    try {
                        var10_16 = System.currentTimeMillis();
                        var12_25 = var10_16 + RMIMasterSocketFactory.connectTimeout;
                        do {
                            var6_6.wait(var12_25 - var10_16);
                        } while ((var4_4 = this.checkConnector(var6_6)) == null && (var10_16 = System.currentTimeMillis()) < var12_25);
                    }
                    catch (InterruptedException var10_17) {
                        throw new InterruptedIOException("interrupted while waiting for connector");
                    }
                    ** if (var4_4 != null) goto lbl30
                }
lbl-1000:
                // 1 sources

                {
                    throw new NoRouteToHostException("connect timed out: " + var1_1);
                }
lbl30:
                // 1 sources

                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection successful");
                var9_11 = var4_4;
                return var9_11;
            }
            catch (UnknownHostException var8_9) {
                var7_7 /* !! */  = var8_9;
                return var7_7 /* !! */ ;
            }
            catch (NoRouteToHostException var9_13) {
                var7_7 /* !! */  = var9_13;
                return var7_7 /* !! */ ;
            }
            catch (SocketException var10_23) {
                if (RMIMasterSocketFactory.eagerHttpFallback == false) throw var10_23;
                var7_7 /* !! */  = var10_23;
            }
            finally {
                if (var7_7 /* !! */  == null) break block50;
                if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "direct socket connection failed: ", var7_7 /* !! */ );
                }
                var9_12 = 0;
                ** while (var9_12 < this.altFactoryList.size())
            }
lbl-1000:
            // 1 sources

            {
                block51: {
                    var3_3 = (RMISocketFactory)this.altFactoryList.elementAt(var9_12);
                    try {
                        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "trying with factory: " + var3_3);
                        }
                        var10_20 = var3_3.createSocket(var1_1, var2_2);
                        var11_35 = var10_20.getInputStream();
                        var12_27 = var11_35.read();
                        var10_20.close();
                    }
                    catch (IOException var10_19) {
                        if (!RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) break block51;
                        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory failed: ", var10_19);
                        break block51;
                    }
                    RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {
                        var5_5 = var3_3.createSocket(var1_1, var2_2);
                    }
                    catch (IOException var10_21) {}
                    break;
                }
                ++var9_12;
                continue;
            }
        }
        var8_10 = this.successTable;
        synchronized (var8_10) {
            try {
                var9_14 = var6_6;
                synchronized (var9_14) {
                    var4_4 = this.checkConnector(var6_6);
                    ** if (var4_4 == null) goto lbl82
                }
lbl-1000:
                // 1 sources

                {
                    if (var5_5 == null) return var4_4;
                    var5_5.close();
                    return var4_4;
                }
lbl82:
                // 1 sources

                var6_6.notUsed();
            }
            catch (UnknownHostException var9_15) {
                var7_7 /* !! */  = var9_15;
            }
            catch (NoRouteToHostException var10_24) {
                var7_7 /* !! */  = var10_24;
            }
            catch (SocketException var11_41) {
                if (RMIMasterSocketFactory.eagerHttpFallback == false) throw var11_41;
                var7_7 /* !! */  = var11_41;
            }
            if (var5_5 == null) throw var7_7 /* !! */ ;
            this.rememberFactory(var1_1, var3_3);
            return var5_5;
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = AsyncConnector.access$000(asyncConnector);
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return AsyncConnector.access$100(asyncConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception;
        private Socket socket;
        private boolean cleanUp;
        private final RMIMasterSocketFactory this$0;

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    Socket socket = this.factory.createSocket(this.host, this.port);
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.socket = socket;
                        this.notify();
                    }
                    this.this$0.rememberFactory(this.host, this.factory);
                    AsyncConnector asyncConnector2 = this;
                    synchronized (asyncConnector2) {
                        if (this.cleanUp) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.exception = exception;
                        this.notify();
                    }
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                throw throwable;
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        static Exception access$000(AsyncConnector asyncConnector) {
            return asyncConnector.getException();
        }

        static Socket access$100(AsyncConnector asyncConnector) {
            return asyncConnector.getSocket();
        }

        AsyncConnector(RMIMasterSocketFactory rMIMasterSocketFactory, RMISocketFactory rMISocketFactory, String string, int n2, AccessControlContext accessControlContext) {
            this.this$0 = rMIMasterSocketFactory;
            this.exception = null;
            this.socket = null;
            this.cleanUp = false;
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n2;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n2);
            }
        }
    }
}

