/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.OutputStream;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.PSStreamPrintJob;
import sun.print.PSStreamPrinterFactory;
import sun.print.SunPrinterJobService;

public class PSStreamPrintService
extends StreamPrintService
implements SunPrinterJobService {
    private static final Class[] suppAttrCats = new Class[]{class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = PSStreamPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity, class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSStreamPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies, class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = PSStreamPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity, class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PSStreamPrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName, class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PSStreamPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media, class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PSStreamPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea, class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = PSStreamPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested, class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = PSStreamPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges, class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = PSStreamPrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName, class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = PSStreamPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate, class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = PSStreamPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides};
    private static int MAXCOPIES = 1000;
    private static final MediaSizeName[] mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
    static Class class$javax$print$attribute$standard$Chromaticity;
    static Class class$javax$print$attribute$standard$Copies;
    static Class class$javax$print$attribute$standard$Fidelity;
    static Class class$javax$print$attribute$standard$JobName;
    static Class class$javax$print$attribute$standard$Media;
    static Class class$javax$print$attribute$standard$MediaPrintableArea;
    static Class class$javax$print$attribute$standard$OrientationRequested;
    static Class class$javax$print$attribute$standard$PageRanges;
    static Class class$javax$print$attribute$standard$RequestingUserName;
    static Class class$javax$print$attribute$standard$SheetCollate;
    static Class class$javax$print$attribute$standard$Sides;
    static Class class$sun$print$PSPrinterJob;
    static Class class$javax$print$attribute$PrintServiceAttribute;
    static Class class$javax$print$attribute$standard$ColorSupported;
    static Class class$javax$print$attribute$Attribute;
    static Class class$javax$print$attribute$standard$CopiesSupported;
    static Class class$javax$print$attribute$standard$MediaSize;

    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    public PSStreamPrintService(OutputStream outputStream) {
        super(outputStream);
    }

    public Class[] getSupportedAttributeCategories() {
        Class[] classArray = new Class[suppAttrCats.length];
        System.arraycopy(suppAttrCats, 0, classArray, 0, classArray.length);
        return classArray;
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = PSStreamPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        int n2 = 0;
        while (n2 < suppAttrCats.length) {
            if (clazz == suppAttrCats[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean usesClass(Class clazz) {
        return clazz == (class$sun$print$PSPrinterJob == null ? (class$sun$print$PSPrinterJob = PSStreamPrintService.class$("sun.print.PSPrinterJob")) : class$sun$print$PSPrinterJob);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof PSStreamPrintService && ((PSStreamPrintService)object).getName().equals(this.getName());
    }

    public String getName() {
        return "Postscript output";
    }

    public String getOutputFormat() {
        return "application/postscript";
    }

    public String toString() {
        return "PSStreamPrintService: " + this.getName();
    }

    public DocFlavor[] getSupportedDocFlavors() {
        return PSStreamPrinterFactory.getFlavors();
    }

    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        DocFlavor[] docFlavorArray = this.getSupportedDocFlavors();
        int n2 = 0;
        while (n2 < docFlavorArray.length) {
            if (docFlavor.equals(docFlavorArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public DocPrintJob createPrintJob() {
        return new PSStreamPrintJob(this);
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(ColorSupported.SUPPORTED);
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    private boolean isSupportedCopies(Copies copies) {
        int n2 = copies.getValue();
        return n2 > 0 && n2 < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        int n2 = 0;
        while (n2 < mediaSizes.length) {
            if (mediaSizeName.equals(mediaSizes[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getDefaultAttributeValue(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = PSStreamPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSStreamPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            return new Copies(1);
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = PSStreamPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            return Chromaticity.COLOR;
        }
        if (clazz == (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = PSStreamPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PSStreamPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PSStreamPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            float f2;
            float f3;
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                f3 = MediaSize.NA.LETTER.getX(25400) - 2.0f;
                f2 = MediaSize.NA.LETTER.getY(25400) - 2.0f;
            } else {
                f3 = MediaSize.ISO.A4.getX(25400) - 2.0f;
                f2 = MediaSize.ISO.A4.getY(25400) - 2.0f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, f3, f2, 25400);
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = PSStreamPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            return OrientationRequested.PORTRAIT;
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = PSStreamPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = PSStreamPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            return SheetCollate.UNCOLLATED;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = PSStreamPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!(class$javax$print$attribute$PrintServiceAttribute == null ? (class$javax$print$attribute$PrintServiceAttribute = PSStreamPrintService.class$("javax.print.attribute.PrintServiceAttribute")) : class$javax$print$attribute$PrintServiceAttribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == (class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = PSStreamPrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported)) {
            return ColorSupported.SUPPORTED;
        }
        return null;
    }

    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
        }
        Class clazz = attribute.getCategory();
        if (!this.isAttributeCategorySupported(clazz)) {
            return false;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = PSStreamPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            return attribute == Chromaticity.COLOR;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSStreamPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PSStreamPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media) && attribute instanceof MediaSizeName) {
            return this.isSupportedMedia((MediaSizeName)attribute);
        }
        return !(attribute.getCategory() == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = PSStreamPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested) ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = PSStreamPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges) ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = PSStreamPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate) ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attribute.getCategory() == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = PSStreamPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides) && docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            try {
                Attribute attribute = attributeArray[n2];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                } else if (!this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) {
                    hashAttributeSet.add(attribute);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = PSStreamPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = PSStreamPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.COLOR};
            return chromaticityArray;
        }
        if (clazz == (class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PSStreamPrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName)) {
            return new JobName("", null);
        }
        if (clazz == (class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = PSStreamPrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName)) {
            return new RequestingUserName("", null);
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = PSStreamPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSStreamPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies) || clazz == (class$javax$print$attribute$standard$CopiesSupported == null ? (class$javax$print$attribute$standard$CopiesSupported = PSStreamPrintService.class$("javax.print.attribute.standard.CopiesSupported")) : class$javax$print$attribute$standard$CopiesSupported)) {
            return new CopiesSupported(1, MAXCOPIES);
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PSStreamPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            Media[] mediaArray = new Media[mediaSizes.length];
            System.arraycopy(mediaSizes, 0, mediaArray, 0, mediaSizes.length);
            return mediaArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = PSStreamPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PSStreamPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            Object object;
            if (attributeSet == null) {
                return null;
            }
            MediaSize mediaSize = (MediaSize)attributeSet.get(class$javax$print$attribute$standard$MediaSize == null ? (class$javax$print$attribute$standard$MediaSize = PSStreamPrintService.class$("javax.print.attribute.standard.MediaSize")) : class$javax$print$attribute$standard$MediaSize);
            if (mediaSize == null && (object = (Media)attributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PSStreamPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) != null && object instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)object;
                mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            if (mediaSize == null) {
                return null;
            }
            object = new MediaPrintableArea[]{new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(25400), mediaSize.getY(25400), 25400)};
            return object;
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = PSStreamPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = PSStreamPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            if (docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return sheetCollateArray;
            }
            SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return sheetCollateArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = PSStreamPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            if (docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        return null;
    }
}

