/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    static final boolean $assertionsDisabled = !(class$sun$nio$ch$IOUtil == null ? (class$sun$nio$ch$IOUtil = IOUtil.class$("sun.nio.ch.IOUtil")) : class$sun$nio$ch$IOUtil).desiredAssertionStatus();
    static Class class$sun$nio$ch$IOUtil;

    static {
        Util.load();
    }

    private IOUtil() {
    }

    static native void initIDs();

    static native boolean drain(int var0) throws IOException;

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static FileDescriptor newFD(int n2) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n2);
        return fileDescriptor;
    }

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n2 = byteBufferArray.length;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (byteBufferArray[n3].hasRemaining()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n2) {
        int n3 = byteBufferArray.length - n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        int n4 = 0;
        while (n4 < n3) {
            byteBufferArray2[n4] = byteBufferArray[n4 + n2];
            ++n4;
        }
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n2;
        int n3 = IOUtil.remaining(byteBufferArray);
        if (n3 < 0) {
            return 0;
        }
        if (n3 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n3);
        }
        int n4 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        int n5 = 0;
        while (n5 < n4) {
            if (byteBufferArray[n5].isReadOnly()) {
                throw new IllegalArgumentException("Read-only buffer");
            }
            byteBufferArray2[n5] = !(byteBufferArray[n5] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[n5].remaining()) : byteBufferArray[n5];
            ++n5;
        }
        IOVecWrapper iOVecWrapper = null;
        int n6 = 0;
        try {
            iOVecWrapper = new IOVecWrapper(n4);
            n2 = 0;
            while (n2 < n4) {
                ByteBuffer byteBuffer = byteBufferArray2[n2];
                long l2 = byteBuffer.position();
                long l3 = byteBuffer.remaining();
                iOVecWrapper.putBase(n2, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(n2, l3);
                ++n2;
            }
            n6 = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n4);
            Object var16_17 = null;
            iOVecWrapper.free();
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            iOVecWrapper.free();
            throw throwable;
        }
        n2 = n6;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            ByteBuffer byteBuffer = byteBufferArray2[n7];
            int n9 = byteBuffer.position();
            int n10 = byteBuffer.remaining();
            if (n6 >= n10) {
                n6 -= n10;
            } else {
                if (n6 <= 0) break;
                n8 = n9 + n6;
                byteBuffer.position(n8);
                break;
            }
            n8 = n9 + n10;
            byteBuffer.position(n8);
            ++n7;
        }
        int n11 = 0;
        while (n11 < n4) {
            if (!(byteBufferArray[n11] instanceof DirectBuffer)) {
                byteBufferArray2[n11].flip();
                byteBufferArray[n11].put(byteBufferArray2[n11]);
            }
            ++n11;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        ByteBuffer byteBuffer;
        int n2;
        int n3;
        int n4 = IOUtil.remaining(byteBufferArray);
        if (n4 < 0) {
            return 0;
        }
        if (n4 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n4);
        }
        int n5 = byteBufferArray.length;
        int n6 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n5];
        int n7 = 0;
        while (n7 < n5) {
            if (!(byteBufferArray[n7] instanceof DirectBuffer)) {
                int n8 = byteBufferArray[n7].position();
                n3 = byteBufferArray[n7].limit();
                if (!$assertionsDisabled && n8 > n3) {
                    throw new AssertionError();
                }
                n2 = n8 <= n3 ? n3 - n8 : 0;
                byteBufferArray2[n7] = byteBuffer = ByteBuffer.allocateDirect(n2);
                byteBuffer.put(byteBufferArray[n7]);
                byteBufferArray[n7].position(n8);
                byteBuffer.flip();
            } else {
                byteBufferArray2[n7] = byteBufferArray[n7];
            }
            ++n7;
        }
        IOVecWrapper iOVecWrapper = null;
        n3 = 0;
        try {
            iOVecWrapper = new IOVecWrapper(n5);
            n2 = 0;
            while (n2 < n5) {
                byteBuffer = byteBufferArray2[n2];
                long l2 = byteBuffer.position();
                long l3 = (long)byteBuffer.limit() - l2;
                n6 = (int)((long)n6 + l3);
                iOVecWrapper.putBase(n2, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(n2, l3);
                ++n2;
            }
            n3 = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n5);
            Object var17_18 = null;
            iOVecWrapper.free();
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            iOVecWrapper.free();
            throw throwable;
        }
        n2 = n3;
        int n9 = 0;
        while (n9 < n5) {
            int n10;
            int n11;
            ByteBuffer byteBuffer2 = byteBufferArray[n9];
            int n12 = byteBuffer2.position();
            int n13 = byteBuffer2.limit();
            if (!$assertionsDisabled && n12 > n13) {
                throw new AssertionError();
            }
            int n14 = n11 = n12 <= n13 ? n13 - n12 : n13;
            if (n3 >= n11) {
                n3 -= n11;
            } else {
                if (n3 <= 0) break;
                n10 = n12 + n3;
                byteBuffer2.position(n10);
                break;
            }
            n10 = n12 + n11;
            byteBuffer2.position(n10);
            ++n9;
        }
        return n2;
    }

    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
        int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
        byteBuffer2.flip();
        if (n2 > 0) {
            byteBuffer.put(byteBuffer2);
        }
        return n2;
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (n2 == 0) {
            return 0;
        }
        int n6 = 0;
        n6 = l2 != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, l2, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2);
        if (n6 > 0) {
            byteBuffer.position(n3 + n6);
        }
        return n6;
    }

    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n2);
        int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = 0;
        if (n4 == 0) {
            return 0;
        }
        n5 = l2 != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, l2, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }
}

