/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.ExtensionDependency;
import sun.misc.InvalidJarIndexException;
import sun.misc.JarIndex;
import sun.misc.Resource;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private ArrayList path = new ArrayList();
    private Stack urls = new Stack();
    private ArrayList loaders = new ArrayList();
    private HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            return (URL[])this.path.toArray(new URL[this.path.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    static void check(URL uRL) throws IOException {
        URLConnection uRLConnection;
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = (uRLConnection = uRL.openConnection()).getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    URL uRL2 = uRL;
                    if (uRLConnection instanceof JarURLConnection) {
                        uRL2 = ((JarURLConnection)uRLConnection).getJarFileURL();
                    }
                    securityManager.checkConnect(uRL2.getHost(), uRL2.getPort());
                }
                throw securityException;
            }
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            int n2 = uRLArray.length - 1;
            while (n2 >= 0) {
                this.urls.push(uRLArray[n2]);
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(int n2) {
        while (this.loaders.size() < n2 + 1) {
            Loader loader;
            URL uRL;
            block7: {
                Stack stack = this.urls;
                synchronized (stack) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    uRL = (URL)this.urls.pop();
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    loader = this.getLoader(uRL);
                    URL[] uRLArray = loader.getClassPath();
                    if (uRLArray == null) break block7;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add(loader);
            this.lmap.put(uRL, loader);
        }
        return (Loader)this.loaders.get(n2);
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            try {
                object = new File(object.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                uRLArray[n2++] = ParseUtil.fileToEncodedURL((File)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (uRLArray.length != n2) {
            object = new URL[n2];
            System.arraycopy(uRLArray, 0, object, 0, n2);
            uRLArray = object;
        }
        return uRLArray;
    }

    public URL findResource(String string, boolean bl2) {
        Loader loader;
        int n2 = 0;
        while ((loader = this.getLoader(n2)) != null) {
            URL uRL = loader.findResource(string, bl2);
            if (uRL != null) {
                return uRL;
            }
            ++n2;
        }
        return null;
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static URLStreamHandler access$100(URLClassPath uRLClassPath) {
        return uRLClassPath.jarHandler;
    }

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        int n2 = 0;
        while (n2 < uRLArray.length) {
            this.path.add(uRLArray[n2]);
            ++n2;
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    public Enumeration findResources(String string, boolean bl2) {
        return new Enumeration(this, string, bl2){
            private int index;
            private URL url;
            private final String val$name;
            private final boolean val$check;
            private final URLClassPath this$0;

            public boolean hasMoreElements() {
                return this.next();
            }

            /*
             * Unable to fully structure code
             */
            private boolean next() {
                if (this.url == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    this.url = var1_1.findResource(this.val$name, this.val$check);
                    if (this.url == null) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while ((var1_1 = URLClassPath.access$000((URLClassPath)this.this$0, (int)this.index++)) != null)
                }
lbl7:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }
            {
                this.this$0 = uRLClassPath;
                this.val$name = string;
                this.val$check = bl2;
                this.index = 0;
                this.url = null;
            }
        };
    }

    public Enumeration getResources(String string, boolean bl2) {
        return new Enumeration(this, string, bl2){
            private int index;
            private Resource res;
            private final String val$name;
            private final boolean val$check;
            private final URLClassPath this$0;

            public boolean hasMoreElements() {
                return this.next();
            }

            /*
             * Unable to fully structure code
             */
            private boolean next() {
                if (this.res == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    this.res = var1_1.getResource(this.val$name, this.val$check);
                    if (this.res == null) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while ((var1_1 = URLClassPath.access$000((URLClassPath)this.this$0, (int)this.index++)) != null)
                }
lbl7:
                // 1 sources

                return false;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
            {
                this.this$0 = uRLClassPath;
                this.val$name = string;
                this.val$check = bl2;
                this.index = 0;
                this.res = null;
            }
        };
    }

    static HashMap access$200(URLClassPath uRLClassPath) {
        return uRLClassPath.lmap;
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Resource getResource(String string, boolean bl2) {
        Loader loader;
        int n2 = 0;
        while ((loader = this.getLoader(n2)) != null) {
            Resource resource = loader.getResource(string, bl2);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    private Loader getLoader(URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                private final URL val$url;
                private final URLClassPath this$0;

                public Object run() throws IOException {
                    String string = this.val$url.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(this.val$url.getProtocol())) {
                            return new FileLoader(this.val$url);
                        }
                        return new Loader(this.val$url);
                    }
                    return new JarLoader(this.val$url, URLClassPath.access$100(this.this$0), URLClassPath.access$200(this.this$0));
                }
                {
                    this.this$0 = uRLClassPath;
                    this.val$url = uRL;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static Loader access$000(URLClassPath uRLClassPath, int n2) {
        return uRLClassPath.getLoader(n2);
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            this.dir = new File(string);
        }

        URL findResource(String string, boolean bl2) {
            Resource resource = this.getResource(string, bl2);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        Resource getResource(String string, boolean bl2) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), ".");
                URL uRL2 = new URL(this.getBaseURL(), string);
                if (!uRL2.getFile().startsWith(uRL.getFile())) {
                    return null;
                }
                if (bl2) {
                    URLClassPath.check(uRL2);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(this, string, uRL2, file){
                        private final String val$name;
                        private final URL val$url;
                        private final File val$file;
                        private final FileLoader this$0;

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public URL getURL() {
                            return this.val$url;
                        }
                        {
                            this.this$0 = fileLoader;
                            this.val$name = string;
                            this.val$url = uRL;
                            this.val$file = file;
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private URLStreamHandler handler;
        private HashMap lmap;

        private void parseExtensionsDependencies() throws IOException {
            ExtensionDependency.checkExtensionsDependencies(this.jar);
        }

        boolean validIndex(String string) {
            String string2 = string;
            int n2 = string.lastIndexOf("/");
            if (n2 != -1) {
                string2 = string.substring(0, n2);
            }
            Enumeration enumeration = this.jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string3 = zipEntry.getName();
                n2 = string3.lastIndexOf("/");
                if (n2 != -1) {
                    string3 = string3.substring(0, n2);
                }
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            if (this.index != null) {
                return null;
            }
            this.parseExtensionsDependencies();
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        JarIndex getIndex() {
            return this.index;
        }

        URL findResource(String string, boolean bl2) {
            Resource resource = this.getResource(string, bl2);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        static URL access$400(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static URLStreamHandler access$600(JarLoader jarLoader) {
            return jarLoader.handler;
        }

        static HashMap access$700(JarLoader jarLoader) {
            return jarLoader.lmap;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile().replace('/', File.separatorChar);
                File file = new File(string = ParseUtil.decode(string));
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        static JarFile access$500(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        Resource getResource(String string, boolean bl2) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl2, jarEntry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet hashSet = new HashSet();
            return this.getResource(string, bl2, hashSet);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n2] = new URL(uRL, string2);
                ++n2;
            }
            return uRLArray;
        }

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, HashMap hashMap) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/", uRLStreamHandler));
            this.jar = this.getJarFile(uRL);
            this.index = JarIndex.getJarIndex(this.jar);
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = hashMap;
            if (this.index != null) {
                String[] stringArray = this.index.getJarFiles();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    try {
                        URL uRL2 = new URL(this.csu, stringArray[n2]);
                        if (!this.lmap.containsKey(uRL2)) {
                            this.lmap.put(uRL2, null);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }

        Resource getResource(String string, boolean bl2, Set set) {
            boolean bl3 = false;
            int n2 = 0;
            LinkedList linkedList = null;
            linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n3 = linkedList.size();
                while (n2 < n3) {
                    Resource resource;
                    boolean bl4;
                    JarLoader jarLoader;
                    URL uRL;
                    block10: {
                        String string2 = (String)objectArray[n2++];
                        try {
                            uRL = new URL(this.csu, string2);
                            jarLoader = (JarLoader)this.lmap.get(uRL);
                            if (jarLoader != null) break block10;
                            jarLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                                private final URL val$url;
                                private final JarLoader this$0;

                                public Object run() throws IOException {
                                    return new JarLoader(this.val$url, JarLoader.access$600(this.this$0), JarLoader.access$700(this.this$0));
                                }
                                {
                                    this.this$0 = jarLoader;
                                    this.val$url = uRL;
                                }
                            });
                            JarIndex jarIndex = jarLoader.getIndex();
                            if (jarIndex != null) {
                                int n4 = string2.lastIndexOf("/");
                                jarIndex.merge(this.index, n4 == -1 ? null : string2.substring(0, n4 + 1));
                            }
                            this.lmap.put(uRL, jarLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl5 = bl4 = !set.add(uRL);
                    if (!bl4) {
                        JarEntry jarEntry = jarLoader.jar.getJarEntry(string);
                        if (jarEntry != null) {
                            return jarLoader.checkResource(string, bl2, jarEntry);
                        }
                        if (!jarLoader.validIndex(string)) {
                            throw new InvalidJarIndexException("Invalid index");
                        }
                    }
                    if (bl4 || jarLoader == this || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl2, set)) == null) continue;
                    return resource;
                }
            } while (n2 < (linkedList = this.index.get(string)).size());
            return null;
        }

        Resource checkResource(String string, boolean bl2, JarEntry jarEntry) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), string);
                if (bl2) {
                    URLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            return new Resource(this, string, uRL, jarEntry){
                private final String val$name;
                private final URL val$url;
                private final JarEntry val$entry;
                private final JarLoader this$0;

                public int getContentLength() {
                    return (int)this.val$entry.getSize();
                }

                public InputStream getInputStream() throws IOException {
                    return JarLoader.access$500(this.this$0).getInputStream(this.val$entry);
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.access$400(this.this$0);
                }

                public URL getURL() {
                    return this.val$url;
                }

                public Certificate[] getCertificates() {
                    return this.val$entry.getCertificates();
                }

                public Manifest getManifest() throws IOException {
                    return JarLoader.access$500(this.this$0).getManifest();
                }
                {
                    this.this$0 = jarLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$entry = jarEntry;
                }
            };
        }
    }

    private static class Loader {
        private final URL base;

        URL getBaseURL() {
            return this.base;
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL findResource(String string, boolean bl2) {
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uRLConnection;
                if (bl2) {
                    URLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("HEAD");
                    if (httpURLConnection.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                return uRL;
            }
            catch (Exception exception) {
                return null;
            }
        }

        static URL access$300(Loader loader) {
            return loader.base;
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        Resource getResource(String string, boolean bl2) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl2) {
                    URLClassPath.check(uRL);
                }
                uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(this, string, uRL, uRLConnection){
                private final String val$name;
                private final URL val$url;
                private final URLConnection val$uc;
                private final Loader this$0;

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getCodeSourceURL() {
                    return Loader.access$300(this.this$0);
                }

                public URL getURL() {
                    return this.val$url;
                }
                {
                    this.this$0 = loader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$uc = uRLConnection;
                }
            };
        }
    }
}

