/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import sun.java2d.pipe.RegionClipSpanIterator;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.RegionSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Region {
    public static final int INIT_SIZE = 50;
    public static final int GROW_SIZE = 50;
    int[] bands = new int[50];
    int endIndex;
    int prevYrow;
    int curYrow;
    int lox;
    int loy;
    int hix;
    int hiy;

    void calcBBox() {
        if (this.endIndex == 0) {
            this.hiy = 0;
            this.hix = 0;
            this.loy = 0;
            this.lox = 0;
            return;
        }
        int n2 = this.hix;
        int n3 = this.lox;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = this.bands;
        while (n5 < this.endIndex) {
            n4 = n5;
            int n6 = nArray[n5 + 2];
            if (n2 > nArray[n5 += 3]) {
                n2 = nArray[n5];
            }
            if (n3 >= nArray[(n5 += n6 * 2) - 1]) continue;
            n3 = nArray[n5 - 1];
        }
        this.lox = n2;
        this.loy = nArray[0];
        this.hix = n3;
        this.hiy = nArray[n4 + 1];
    }

    void endRow() {
        int[] nArray;
        int n2 = this.curYrow;
        int n3 = this.prevYrow;
        if (n2 > n3 && (nArray = this.bands)[n3 + 1] == nArray[n2] && nArray[n3 + 2] == nArray[n2 + 2]) {
            int n4 = nArray[n2 + 2] * 2;
            n2 += 3;
            n3 += 3;
            while (n4 > 0) {
                if (nArray[n2++] != nArray[n3++]) break;
                --n4;
            }
            if (n4 == 0) {
                nArray[this.prevYrow + 1] = nArray[this.curYrow + 1];
                this.endIndex = this.curYrow;
                return;
            }
        }
        this.prevYrow = this.curYrow;
        this.curYrow = this.endIndex;
    }

    void needSpace(int n2) {
        if (this.endIndex + n2 >= this.bands.length) {
            int[] nArray = new int[this.bands.length + 50];
            System.arraycopy(this.bands, 0, nArray, 0, this.endIndex);
            this.bands = nArray;
        }
    }

    public void appendSpan(int n2, int n3, int n4, int n5) {
        if (n2 < this.lox) {
            n2 = this.lox;
        }
        if (n3 < this.loy) {
            n3 = this.loy;
        }
        if (n4 > this.hix) {
            n4 = this.hix;
        }
        if (n5 > this.hiy) {
            n5 = this.hiy;
        }
        if (n4 <= n2 || n5 <= n3) {
            return;
        }
        if (this.endIndex == 0 || n3 >= this.bands[this.curYrow + 1]) {
            this.endRow();
            this.needSpace(5);
            this.bands[this.endIndex++] = n3;
            this.bands[this.endIndex++] = n5;
            this.bands[this.endIndex++] = 0;
        } else if (n3 == this.bands[this.curYrow] && n5 == this.bands[this.curYrow + 1] && n2 >= this.bands[this.endIndex - 1]) {
            if (n2 == this.bands[this.endIndex - 1]) {
                this.bands[this.endIndex - 1] = n4;
                return;
            }
            this.needSpace(2);
        } else {
            throw new InternalError("bad span");
        }
        this.bands[this.endIndex++] = n2;
        this.bands[this.endIndex++] = n4;
        int n6 = this.curYrow + 2;
        this.bands[n6] = this.bands[n6] + 1;
    }

    public void setOutputArea(int n2, int n3, int n4, int n5) {
        this.lox = n2;
        this.loy = n3;
        this.hix = n2 + n4;
        this.hiy = n3 + n5;
    }

    public void getBounds(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public void setOutputArea(Rectangle rectangle) {
        this.setOutputArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public RegionIterator getIterator() {
        return new RegionIterator(this);
    }

    public SpanIterator getSpanIterator() {
        return new RegionSpanIterator(this);
    }

    public void appendSpans(SpanIterator spanIterator) {
        int[] nArray = new int[4];
        while (spanIterator.nextSpan(nArray)) {
            this.appendSpan(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        this.endRow();
        this.calcBBox();
    }

    public SpanIterator getSpanIterator(int[] nArray) {
        SpanIterator spanIterator = this.getSpanIterator();
        spanIterator.intersectClipBox(nArray[0], nArray[1], nArray[2], nArray[3]);
        return spanIterator;
    }

    public SpanIterator filter(SpanIterator spanIterator) {
        return new RegionClipSpanIterator(this, spanIterator);
    }
}

