/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.GeneralRenderer;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.SurfaceType;

public final class GraphicsPrimitiveMgr {
    private static final boolean debugTrace = false;
    private static GraphicsPrimitive[] primitives;
    private static GraphicsPrimitive[] generalPrimitives;
    private static boolean needssort;
    private static Comparator primSorter;
    private static Comparator primFinder;
    static Class class$sun$java2d$loops$GraphicsPrimitive;
    static Class class$sun$java2d$loops$SurfaceType;
    static Class class$sun$java2d$loops$CompositeType;
    static Class class$sun$java2d$SunGraphics2D;
    static Class class$java$awt$Color;
    static Class class$sun$java2d$loops$XORComposite;
    static Class class$java$awt$AlphaComposite;

    static {
        needssort = true;
        GraphicsPrimitiveMgr.initIDs(class$sun$java2d$loops$GraphicsPrimitive == null ? (class$sun$java2d$loops$GraphicsPrimitive = GraphicsPrimitiveMgr.class$("sun.java2d.loops.GraphicsPrimitive")) : class$sun$java2d$loops$GraphicsPrimitive, class$sun$java2d$loops$SurfaceType == null ? (class$sun$java2d$loops$SurfaceType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.SurfaceType")) : class$sun$java2d$loops$SurfaceType, class$sun$java2d$loops$CompositeType == null ? (class$sun$java2d$loops$CompositeType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.CompositeType")) : class$sun$java2d$loops$CompositeType, class$sun$java2d$SunGraphics2D == null ? (class$sun$java2d$SunGraphics2D = GraphicsPrimitiveMgr.class$("sun.java2d.SunGraphics2D")) : class$sun$java2d$SunGraphics2D, class$java$awt$Color == null ? (class$java$awt$Color = GraphicsPrimitiveMgr.class$("java.awt.Color")) : class$java$awt$Color, class$sun$java2d$loops$XORComposite == null ? (class$sun$java2d$loops$XORComposite = GraphicsPrimitiveMgr.class$("sun.java2d.loops.XORComposite")) : class$sun$java2d$loops$XORComposite, class$java$awt$AlphaComposite == null ? (class$java$awt$AlphaComposite = GraphicsPrimitiveMgr.class$("java.awt.AlphaComposite")) : class$java$awt$AlphaComposite);
        CustomComponent.register();
        GeneralRenderer.register();
        GraphicsPrimitiveMgr.registerNativeLoops();
        primSorter = new Comparator(){

            public int compare(Object object, Object object2) {
                GraphicsPrimitive graphicsPrimitive = (GraphicsPrimitive)object;
                GraphicsPrimitive graphicsPrimitive2 = (GraphicsPrimitive)object2;
                int n2 = graphicsPrimitive.getSignature().compareTo(graphicsPrimitive2.getSignature());
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$000(graphicsPrimitive.getDestType(), graphicsPrimitive2.getDestType());
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$000(graphicsPrimitive.getSourceType(), graphicsPrimitive2.getSourceType());
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$100(graphicsPrimitive.getCompositeType(), graphicsPrimitive2.getCompositeType());
                return n2;
            }
        };
        primFinder = new Comparator(){

            public int compare(Object object, Object object2) {
                GraphicsPrimitive graphicsPrimitive = (GraphicsPrimitive)object;
                PrimitiveSpec primitiveSpec = (PrimitiveSpec)object2;
                int n2 = graphicsPrimitive.getSignature().compareTo(primitiveSpec.methodSignature);
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$000(graphicsPrimitive.getDestType(), primitiveSpec.destType);
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$000(graphicsPrimitive.getSourceType(), primitiveSpec.sourceType);
                if (n2 != 0) {
                    return n2;
                }
                n2 = GraphicsPrimitiveMgr.access$100(graphicsPrimitive.getCompositeType(), primitiveSpec.compType);
                return n2;
            }
        };
    }

    private GraphicsPrimitiveMgr() {
    }

    private static native void registerNativeLoops();

    public static void testPrimitiveInstantiation() {
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(false);
    }

    public static void testPrimitiveInstantiation(boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        GraphicsPrimitive[] graphicsPrimitiveArray = primitives;
        int n4 = 0;
        while (n4 < graphicsPrimitiveArray.length) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n4];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                GraphicsPrimitive graphicsPrimitive2 = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                if (!graphicsPrimitive2.getSignature().equals(GraphicsPrimitiveMgr.getSignature(graphicsPrimitive2.getClass()))) {
                    System.out.println("r.getSignature == " + graphicsPrimitive2.getSignature());
                    System.out.println("getSignature(r.getClass()) == " + GraphicsPrimitiveMgr.getSignature(graphicsPrimitive2.getClass()));
                    throw new RuntimeException("Primitive " + graphicsPrimitive + " returns wrong signature for " + graphicsPrimitive2.getClass());
                }
                ++n3;
                graphicsPrimitive = graphicsPrimitive2;
                if (bl2) {
                    System.out.println(graphicsPrimitive);
                }
            } else {
                if (bl2) {
                    System.out.println(graphicsPrimitive + " (not proxied).");
                }
                ++n2;
            }
            ++n4;
        }
        System.out.println(n2 + " graphics primitives were not proxied.");
        System.out.println(n3 + " proxied graphics primitives resolved correctly.");
        System.out.println(n2 + n3 + " total graphics primitives");
    }

    private static void writeLog(String string) {
    }

    public static void main(String[] stringArray) {
        if (needssort) {
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(stringArray.length > 0);
    }

    public static synchronized void registerGeneral(GraphicsPrimitive graphicsPrimitive) {
        if (generalPrimitives == null) {
            generalPrimitives = new GraphicsPrimitive[]{graphicsPrimitive};
            return;
        }
        int n2 = generalPrimitives.length;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[n2 + 1];
        System.arraycopy(generalPrimitives, 0, graphicsPrimitiveArray, 0, n2);
        graphicsPrimitiveArray[n2] = graphicsPrimitive;
        generalPrimitives = graphicsPrimitiveArray;
    }

    public static synchronized void register(GraphicsPrimitive[] graphicsPrimitiveArray) {
        GraphicsPrimitive[] graphicsPrimitiveArray2 = primitives;
        int n2 = 0;
        int n3 = graphicsPrimitiveArray.length;
        if (graphicsPrimitiveArray2 != null) {
            n2 = graphicsPrimitiveArray2.length;
        }
        GraphicsPrimitive[] graphicsPrimitiveArray3 = new GraphicsPrimitive[n2 + n3];
        if (graphicsPrimitiveArray2 != null) {
            System.arraycopy(graphicsPrimitiveArray2, 0, graphicsPrimitiveArray3, 0, n2);
        }
        System.arraycopy(graphicsPrimitiveArray, 0, graphicsPrimitiveArray3, n2, n3);
        needssort = true;
        primitives = graphicsPrimitiveArray3;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static String getSignature(Class clazz) {
        while (clazz != null) {
            String string = clazz.getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                Method method = methodArray[n2];
                if (method.getName().equals(string)) {
                    StringBuffer stringBuffer = new StringBuffer(string).append('(');
                    Class[] classArray = method.getParameterTypes();
                    int n3 = 0;
                    while (n3 < classArray.length) {
                        stringBuffer.append(GraphicsPrimitiveMgr.paramName(classArray[n3]));
                        ++n3;
                    }
                    stringBuffer.append(')');
                    stringBuffer.append(GraphicsPrimitiveMgr.paramName(method.getReturnType()));
                    long l2 = System.currentTimeMillis();
                    return stringBuffer.toString();
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static String paramName(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            throw new InternalError("No mapping for type: " + clazz);
        }
        if (clazz.isArray()) {
            return "[" + GraphicsPrimitiveMgr.paramName(clazz.getComponentType());
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static int access$100(CompositeType compositeType, CompositeType compositeType2) {
        return GraphicsPrimitiveMgr.compareComposites(compositeType, compositeType2);
    }

    private static int compareComposites(CompositeType compositeType, CompositeType compositeType2) {
        return compositeType.getDescriptor().compareTo(compositeType2.getDescriptor());
    }

    private static GraphicsPrimitive locateGeneral(String string) {
        if (generalPrimitives == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < generalPrimitives.length) {
            GraphicsPrimitive graphicsPrimitive = generalPrimitives[n2];
            if (graphicsPrimitive.getSignature() == string) {
                return graphicsPrimitive;
            }
            ++n2;
        }
        return null;
    }

    private static GraphicsPrimitive locate(PrimitiveSpec primitiveSpec) {
        Object[] objectArray;
        if (needssort) {
            if (GraphicsPrimitive.traceflags != 0) {
                int n2 = 0;
                while (n2 < primitives.length) {
                    GraphicsPrimitiveMgr.primitives[n2] = primitives[n2].traceWrap();
                    ++n2;
                }
            }
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        if ((objectArray = primitives) == null) {
            return null;
        }
        int n3 = Arrays.binarySearch(objectArray, primitiveSpec, primFinder);
        if (n3 >= 0) {
            Object object = objectArray[n3];
            if (object instanceof GraphicsPrimitiveProxy) {
                objectArray[n3] = object = ((GraphicsPrimitiveProxy)object).instantiate();
            }
            return object;
        }
        return null;
    }

    static int access$000(SurfaceType surfaceType, SurfaceType surfaceType2) {
        return GraphicsPrimitiveMgr.compareSurfaces(surfaceType, surfaceType2);
    }

    private static int compareSurfaces(SurfaceType surfaceType, SurfaceType surfaceType2) {
        return surfaceType.getDescriptor().compareTo(surfaceType2.getDescriptor());
    }

    public static synchronized GraphicsPrimitive locate(String string, SurfaceType surfaceType) {
        return GraphicsPrimitiveMgr.locate(string, SurfaceType.OpaqueColor, CompositeType.Src, surfaceType);
    }

    public static synchronized GraphicsPrimitive locate(String string, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locatePrim(string, surfaceType, compositeType, surfaceType2);
        if (graphicsPrimitive == null && (graphicsPrimitive = GraphicsPrimitiveMgr.locateGeneral(string)) != null && (graphicsPrimitive = graphicsPrimitive.makePrimitive(surfaceType, compositeType, surfaceType2)) != null && GraphicsPrimitive.traceflags != 0) {
            graphicsPrimitive = graphicsPrimitive.traceWrap();
        }
        return graphicsPrimitive;
    }

    public static synchronized GraphicsPrimitive locatePrim(String string, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        PrimitiveSpec primitiveSpec = new PrimitiveSpec(null);
        primitiveSpec.methodSignature = string;
        primitiveSpec.destType = surfaceType2;
        while (primitiveSpec.destType != null) {
            primitiveSpec.sourceType = surfaceType;
            while (primitiveSpec.sourceType != null) {
                primitiveSpec.compType = compositeType;
                while (primitiveSpec.compType != null) {
                    GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(primitiveSpec);
                    if (graphicsPrimitive != null) {
                        return graphicsPrimitive;
                    }
                    primitiveSpec.compType = primitiveSpec.compType.getSuperType();
                }
                primitiveSpec.sourceType = primitiveSpec.sourceType.getSuperType();
            }
            primitiveSpec.destType = primitiveSpec.destType.getSuperType();
        }
        return null;
    }

    private static native void initIDs(Class var0, Class var1, Class var2, Class var3, Class var4, Class var5, Class var6);

    private static class PrimitiveSpec {
        String methodSignature;
        SurfaceType sourceType;
        CompositeType compType;
        SurfaceType destType;

        private PrimitiveSpec() {
        }

        PrimitiveSpec(1 var1_1) {
            this();
        }
    }
}

