/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class ByteComponentRaster
extends SunWritableRaster {
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected byte[] data;
    int type;
    private int maxX;
    private int maxY;

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    static {
        NativeLibLoader.loadLibraries();
        ByteComponentRaster.initIDs();
    }

    private static native void initIDs();

    public byte[] getDataStorage() {
        this.notifyChanged();
        return this.data;
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    public void putByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(byArray, 0, this.data, n7, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(byArray, n8, this.data, n7, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    this.data[n11] = byArray[n8++];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n5];
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(this.data, n7, byArray, 0, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(this.data, n7, byArray, n8, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    byArray[n8++] = this.data[n11];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void putByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.numDataElements == 1) {
            n6 += this.dataOffsets[0];
            if (this.pixelStride == 1) {
                if (this.scanlineStride == n4) {
                    System.arraycopy(byArray, 0, this.data, n6, n4 * n5);
                } else {
                    int n8 = 0;
                    while (n8 < n5) {
                        System.arraycopy(byArray, n7, this.data, n6, n4);
                        n7 += n4;
                        n6 += this.scanlineStride;
                        ++n8;
                    }
                }
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    int n10 = n6;
                    int n11 = 0;
                    while (n11 < n4) {
                        this.data[n10] = byArray[n7++];
                        ++n11;
                        n10 += this.pixelStride;
                    }
                    ++n9;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n6;
                int n14 = 0;
                while (n14 < n4) {
                    int n15 = 0;
                    while (n15 < this.numDataElements) {
                        this.data[this.dataOffsets[n15] + n13] = byArray[n7++];
                        ++n15;
                    }
                    ++n14;
                    n13 += this.pixelStride;
                }
                ++n12;
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n5];
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numDataElements) {
                    byArray[n7++] = this.data[this.dataOffsets[n11] + n9];
                    ++n11;
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return byArray;
    }

    private void verify(boolean bl2) {
        int n2 = 0;
        while (n2 < this.dataOffsets.length) {
            if (this.dataOffsets[n2] < 0) {
                throw new RasterFormatException("Data offsets for band " + n2 + "(" + this.dataOffsets[n2] + ") must be >= 0");
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numDataElements) {
            int n5 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[n4];
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        if (this.data.length < n3) {
            throw new RasterFormatException("Data array too small (should be " + n3 + " )");
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
        return writableRaster;
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteComponentRaster) {
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
            byte[] byArray = byteComponentRaster.getDataStorage();
            if (this.numDataElements == 1) {
                int n8 = byteComponentRaster.getDataOffset(0);
                int n9 = byteComponentRaster.getScanlineStride();
                int n10 = n8;
                int n11 = this.dataOffsets[0] + (n3 - this.minY) * this.scanlineStride + (n2 - this.minX);
                if (this.pixelStride == byteComponentRaster.getPixelStride()) {
                    n4 *= this.pixelStride;
                    int n12 = 0;
                    while (n12 < n5) {
                        System.arraycopy(byArray, n10, this.data, n11, n4);
                        n10 += n9;
                        n11 += this.scanlineStride;
                        ++n12;
                    }
                    this.notifyChanged();
                    return;
                }
            }
        }
        int n13 = 0;
        while (n13 < n5) {
            object = raster.getDataElements(n6, n7 + n13, n4, 1, object);
            this.setDataElements(n2, n3 + n13, n4, 1, object);
            ++n13;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = raster.getMinX() + n2;
        int n5 = raster.getMinY() + n3;
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new ByteComponentRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new ByteComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        if (this.numDataElements == 1) {
            int n8 = 0;
            int n9 = n6 + this.dataOffsets[0];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n6;
                System.arraycopy(byArray, n8, this.data, n9, n4);
                n8 += n4;
                n9 += this.scanlineStride;
                ++n10;
            }
            this.notifyChanged();
            return;
        }
        int n12 = 0;
        while (n12 < n5) {
            int n13 = n6;
            int n14 = 0;
            while (n14 < n4) {
                int n15 = 0;
                while (n15 < this.numDataElements) {
                    this.data[this.dataOffsets[n15] + n13] = byArray[n7++];
                    ++n15;
                }
                ++n14;
                n13 += this.pixelStride;
            }
            ++n12;
            n6 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            this.data[this.dataOffsets[n5] + n4] = byArray[n5];
            ++n5;
        }
        this.notifyChanged();
    }

    public String toString() {
        return new String("ByteComponentRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    public ByteComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[n4 * n5 * this.numDataElements] : (byte[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numDataElements) {
                    byArray[n7++] = this.data[this.dataOffsets[n11] + n9];
                    ++n11;
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return byArray;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numDataElements) {
            byArray[n5] = this.data[this.dataOffsets[n5] + n4];
            ++n5;
        }
        return byArray;
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteComponentRaster byteComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteComponentRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteComponentRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for ByteComponentRasters must only have 1 bank.");
        }
        int n2 = dataBufferByte.getOffset();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.type = 1;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n3 = rectangle.x - point.x;
            int n4 = rectangle.y - point.y;
            int n5 = 0;
            while (n5 < this.getNumDataElements()) {
                int n6 = n5++;
                this.dataOffsets[n6] = this.dataOffsets[n6] + (n2 + n3 * this.pixelStride + n4 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.type = 7;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = n2;
            int n7 = rectangle.x - point.x;
            int n8 = rectangle.y - point.y;
            this.dataOffsets[0] = this.dataOffsets[0] + (n7 * this.pixelStride + n8 * this.scanlineStride);
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have ComponentSampleModel or SinglePixelPackedSampleModel");
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify(false);
    }
}

