/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import sun.awt.font.Decoration;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.StandardGlyphVector;
import sun.awt.font.TextLineComponent;
import sun.awt.font.TextSource;

class ExtendedTextSourceLabel
extends ExtendedTextLabel
implements Decoration.Label {
    TextSource source;
    private Decoration decorator;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    StandardGlyphVector gv;
    float[] charinfo;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;

    public float getItalicAngle() {
        return this.source.getFont().getItalicAngle();
    }

    public int getNumCharacters() {
        return this.source.getLength();
    }

    public int getNumJustificationInfos() {
        return this.getGV().getNumGlyphs();
    }

    protected float[] createCharinfo() {
        int n2;
        boolean bl2;
        int n3;
        StandardGlyphVector standardGlyphVector = this.getGV();
        float[] fArray = standardGlyphVector.getGlyphInfo();
        int n4 = standardGlyphVector.getNumGlyphs();
        int[] nArray = standardGlyphVector.getGlyphCharIndices(0, n4, null);
        boolean bl3 = false;
        if (bl3) {
            System.err.println("number of glyphs: " + n4);
            n3 = 0;
            while (n3 < n4) {
                System.err.println("g: " + n3 + ", x: " + fArray[n3 * 8 + 0] + ", a: " + fArray[n3 * 8 + 2] + ", n: " + nArray[n3]);
                ++n3;
            }
        }
        int n5 = n3 = nArray[0];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n4;
        int n12 = 8;
        int n13 = 1;
        boolean bl4 = bl2 = (this.source.getLayoutFlags() & 1) == 0;
        if (!bl2) {
            n5 = n3 = nArray[n4 - 1];
            n6 = 0;
            n7 = fArray.length - 8;
            n8 = 0;
            n9 = fArray.length - 8;
            n10 = n4 - 1;
            n11 = -1;
            n12 = -8;
            n13 = -1;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        boolean bl5 = false;
        while (n10 != n11) {
            boolean bl6 = false;
            n2 = 0;
            n5 = n3 = nArray[n10];
            n10 += n13;
            n9 += n12;
            while (n10 != n11 && (fArray[n9 + 2] == 0.0f || n3 != n6 || nArray[n10] <= n5 || n5 - n3 > n2)) {
                float f9;
                if (!bl6) {
                    int n14 = n9 - n12;
                    f2 = fArray[n14 + 0];
                    f3 = f2 + fArray[n14 + 2];
                    f4 = fArray[n14 + 4];
                    f5 = fArray[n14 + 5];
                    f6 = f4 + fArray[n14 + 6];
                    f7 = f5 + fArray[n14 + 7];
                    bl6 = true;
                }
                ++n2;
                float f10 = fArray[n9 + 2];
                if (f10 != 0.0f) {
                    f9 = fArray[n9 + 0];
                    f2 = Math.min(f2, f9);
                    f3 = Math.max(f3, f9 + f10);
                }
                if ((f9 = fArray[n9 + 6]) != 0.0f) {
                    float f11 = fArray[n9 + 4];
                    float f12 = fArray[n9 + 5];
                    f4 = Math.min(f4, f11);
                    f5 = Math.min(f5, f12);
                    f6 = Math.max(f6, f11 + f9);
                    f7 = Math.max(f7, f12 + fArray[n9 + 7]);
                }
                n3 = Math.min(n3, nArray[n10]);
                n5 = Math.max(n5, nArray[n10]);
                n10 += n13;
                n9 += n12;
            }
            if (bl3) {
                System.out.println("minIndex = " + n3 + ", maxIndex = " + n5);
            }
            n6 = n5 + 1;
            fArray[n7 + 1] = f8;
            fArray[n7 + 3] = 0.0f;
            if (bl6) {
                fArray[n7 + 0] = f2;
                fArray[n7 + 2] = f3 - f2;
                fArray[n7 + 4] = f4;
                fArray[n7 + 5] = f5;
                fArray[n7 + 6] = f6 - f4;
                fArray[n7 + 7] = f7 - f5;
                if (n5 - n3 < n2) {
                    bl5 = true;
                }
                if (n3 < n5) {
                    if (!bl2) {
                        f3 = f2;
                    }
                    f6 -= f4;
                    f7 -= f5;
                    int n15 = n3;
                    int n16 = n7 / 8;
                    while (n3 < n5) {
                        ++n3;
                        n8 += n13;
                        if ((n7 += n12) < 0 || n7 >= fArray.length) {
                            System.out.println("minIndex = " + n15 + ", maxIndex = " + n5 + ", cp = " + n16);
                        }
                        fArray[n7 + 0] = f3;
                        fArray[n7 + 1] = f8;
                        fArray[n7 + 2] = 0.0f;
                        fArray[n7 + 3] = 0.0f;
                        fArray[n7 + 4] = f4;
                        fArray[n7 + 5] = f5;
                        fArray[n7 + 6] = f6;
                        fArray[n7 + 7] = f7;
                    }
                }
                bl6 = false;
            } else if (bl5) {
                int n17 = n9 - n12;
                fArray[n7 + 0] = fArray[n17 + 0];
                fArray[n7 + 2] = fArray[n17 + 2];
                fArray[n7 + 4] = fArray[n17 + 4];
                fArray[n7 + 5] = fArray[n17 + 5];
                fArray[n7 + 6] = fArray[n17 + 6];
                fArray[n7 + 7] = fArray[n17 + 7];
            }
            n7 += n12;
            n8 += n13;
        }
        if (bl5 && !bl2) {
            System.arraycopy(fArray, n7 -= n12, fArray, 0, fArray.length - n7);
        }
        if (bl3) {
            char[] cArray = this.source.getChars();
            n2 = this.source.getStart();
            int n18 = this.source.getLength();
            System.out.println("char info for " + n18 + " characters");
            int n19 = 0;
            while (n19 < n18 * 8) {
                System.out.println(" ch: " + Integer.toHexString(cArray[n2 + this.v2l(n19 / 8)]) + " x: " + fArray[n19++] + " y: " + fArray[n19++] + " xa: " + fArray[n19++] + " ya: " + fArray[n19++] + " l: " + fArray[n19++] + " t: " + fArray[n19++] + " w: " + fArray[n19++] + " h: " + fArray[n19++]);
            }
        }
        return fArray;
    }

    private final float[] getCharinfo() {
        if (this.charinfo == null) {
            this.charinfo = this.createCharinfo();
        }
        return this.charinfo;
    }

    public float getCharAdvance(int n2) {
        this.validate(n2);
        return this.getCharinfo()[this.l2v(n2) * 8 + 2];
    }

    public float getCharX(int n2) {
        this.validate(n2);
        return this.getCharinfo()[this.l2v(n2) * 8 + 0];
    }

    public float getCharY(int n2) {
        this.validate(n2);
        return this.getCharinfo()[this.l2v(n2) * 8 + 1];
    }

    protected int l2v(int n2) {
        return (this.source.getLayoutFlags() & 1) == 0 ? n2 : this.source.getLength() - 1 - n2;
    }

    public int logicalToVisual(int n2) {
        this.validate(n2);
        return this.l2v(n2);
    }

    protected int v2l(int n2) {
        return (this.source.getLayoutFlags() & 1) == 0 ? n2 : this.source.getLength() - 1 - n2;
    }

    public int visualToLogical(int n2) {
        this.validate(n2);
        return this.v2l(n2);
    }

    private void validate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index " + n2 + " < 0");
        }
        if (n2 >= this.source.getLength()) {
            throw new IllegalArgumentException("index " + n2 + " < " + this.source.getLength());
        }
    }

    public boolean caretAtOffsetIsValid(int n2) {
        if (n2 == 0 || n2 == this.source.getLength()) {
            return true;
        }
        char c2 = this.source.getChars()[this.source.getStart() + n2];
        if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
            return true;
        }
        int n3 = this.l2v(n2);
        return this.getCharinfo()[n3 * 8 + 2] != 0.0f;
    }

    public int getLineBreakIndex(int n2, float f2) {
        float[] fArray = this.getCharinfo();
        int n3 = this.source.getLength();
        --n2;
        while (f2 >= 0.0f && ++n2 < n3) {
            float f3 = fArray[this.l2v(n2) * 8 + 2];
            f2 -= f3;
        }
        return n2;
    }

    public float getAdvanceBetween(int n2, int n3) {
        float f2 = 0.0f;
        float[] fArray = this.getCharinfo();
        --n2;
        while (++n2 < n3) {
            f2 += fArray[this.l2v(n2) * 8 + 2];
        }
        return f2;
    }

    public void draw(Graphics2D graphics2D, float f2, float f3) {
        this.decorator.drawTextAndDecorations(this, graphics2D, f2, f3);
    }

    public void handleDraw(Graphics2D graphics2D, float f2, float f3) {
        graphics2D.drawGlyphVector(this.getGV(), f2, f3);
    }

    public Shape getOutline(float f2, float f3) {
        return this.decorator.getOutline(this, f2, f3);
    }

    public Shape handleGetOutline(float f2, float f3) {
        return this.getGV().getOutline(f2, f3);
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n2, int n3, int n4) {
        boolean bl2;
        StandardGlyphVector standardGlyphVector = this.getGV();
        float[] fArray = this.getCharinfo();
        float f2 = standardGlyphVector.getFont().getSize2D();
        GlyphJustificationInfo glyphJustificationInfo = new GlyphJustificationInfo(0.0f, false, 3, 0.0f, 0.0f, false, 3, 0.0f, 0.0f);
        GlyphJustificationInfo glyphJustificationInfo2 = new GlyphJustificationInfo(f2, true, 1, 0.0f, f2, true, 1, 0.0f, f2 / 4.0f);
        GlyphJustificationInfo glyphJustificationInfo3 = new GlyphJustificationInfo(f2, true, 2, f2, f2, false, 3, 0.0f, 0.0f);
        char[] cArray = this.source.getChars();
        int n5 = this.source.getStart();
        int n6 = standardGlyphVector.getNumGlyphs();
        int n7 = 0;
        int n8 = n6;
        boolean bl3 = bl2 = (this.source.getLayoutFlags() & 1) == 0;
        if (n3 != 0 || n4 != this.source.getLength()) {
            if (bl2) {
                n7 = n3;
                n8 = n4;
            } else {
                n7 = n6 - n4;
                n8 = n6 - n3;
            }
        }
        int n9 = 0;
        while (n9 < n6) {
            GlyphJustificationInfo glyphJustificationInfo4 = null;
            if (n9 >= n7 && n9 < n8) {
                int n10;
                char c2;
                glyphJustificationInfo4 = fArray[n9 * 8 + 2] == 0.0f ? glyphJustificationInfo : (Character.isWhitespace(c2 = cArray[n5 + (n10 = this.v2l(n9))]) ? glyphJustificationInfo2 : (c2 >= '\u4e00' && c2 < '\ua000' || c2 >= '\uac00' && c2 < '\ud7b0' || c2 >= '\uf900' && c2 < '\ufb00' ? glyphJustificationInfo3 : glyphJustificationInfo));
            }
            glyphJustificationInfoArray[n2 + n9] = glyphJustificationInfo4;
            ++n9;
        }
    }

    public LineMetrics getLineMetrics() {
        return this.source.getLineMetrics();
    }

    protected Rectangle2D createAlignBounds() {
        LineMetrics lineMetrics = this.source.getLineMetrics();
        float[] fArray = this.getCharinfo();
        float f2 = 0.0f;
        float f3 = -lineMetrics.getAscent();
        float f4 = 0.0f;
        float f5 = lineMetrics.getAscent() + lineMetrics.getDescent();
        boolean bl2 = (this.source.getLayoutFlags() & 8) == 0;
        int n2 = fArray.length - 8;
        if (bl2) {
            while (n2 > 0 && fArray[n2 + 6] == 0.0f) {
                n2 -= 8;
            }
        }
        if (n2 >= 0) {
            int n3 = 0;
            while (n3 < n2 && (fArray[n3 + 2] == 0.0f || !bl2 && fArray[n3 + 6] == 0.0f)) {
                n3 += 8;
            }
            f2 = Math.max(0.0f, fArray[n3 + 0]);
            f4 = fArray[n2 + 0] + fArray[n2 + 2] - f2;
        }
        return new Rectangle2D.Float(f2, f3, f4, f5);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    public Rectangle2D getLogicalBounds() {
        return this.getLogicalBounds(0.0f, 0.0f);
    }

    public Rectangle2D handleGetVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    public Rectangle2D getAlignBounds(float f2, float f3) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f2), (float)(this.ab.getY() + (double)f3), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    public Rectangle2D getLogicalBounds(float f2, float f3) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f2), (float)(this.lb.getY() + (double)f3), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public Rectangle2D getVisualBounds(float f2, float f3) {
        if (this.vb == null) {
            this.vb = this.decorator.getVisualBounds(this);
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f2), (float)(this.vb.getY() + (double)f3), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    public Rectangle2D handleGetCharVisualBounds(int n2) {
        this.validate(n2);
        float[] fArray = this.getCharinfo();
        n2 = this.l2v(n2) * 8;
        return new Rectangle2D.Float(fArray[n2 + 4], fArray[n2 + 5], fArray[n2 + 6], fArray[n2 + 7]);
    }

    public Rectangle2D getCharVisualBounds(int n2, float f2, float f3) {
        Rectangle2D rectangle2D = this.decorator.getCharVisualBounds(this, n2);
        if (f2 != 0.0f || f3 != 0.0f) {
            rectangle2D.setRect(rectangle2D.getX() + (double)f2, rectangle2D.getY() + (double)f3, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    public String toString() {
        return this.source.toString(false);
    }

    protected StandardGlyphVector createGV() {
        Font font = this.source.getFont();
        FontRenderContext fontRenderContext = this.source.getFRC();
        int n2 = this.source.getLayoutFlags();
        char[] cArray = this.source.getChars();
        int n3 = this.source.getStart();
        int n4 = this.source.getLength();
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(font, cArray, n3, n4, n2, fontRenderContext);
        return standardGlyphVector;
    }

    private final StandardGlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    public TextLineComponent getSubset(int n2, int n3, int n4) {
        return new ExtendedTextSourceLabel(this.source.getSubSource(n2, n3 - n2, n4), this.decorator);
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n2, boolean[] blArray) {
        float[] fArray2 = (float[])this.getCharinfo().clone();
        blArray[0] = false;
        StandardGlyphVector standardGlyphVector = (StandardGlyphVector)this.getGV().clone();
        float[] fArray3 = standardGlyphVector.getGlyphPositions(null);
        int n3 = standardGlyphVector.getNumGlyphs();
        char[] cArray = this.source.getChars();
        int n4 = this.source.getStart();
        float f2 = 0.0f;
        int n5 = 0;
        while (n5 < n3) {
            if (Character.isWhitespace(cArray[n4 + this.v2l(n5)])) {
                int n6 = n5 * 2;
                fArray3[n6] = fArray3[n6] + f2;
                float f3 = fArray[n2 + n5 * 2] + fArray[n2 + n5 * 2 + 1];
                int n7 = n5 * 8 + 0;
                fArray2[n7] = fArray2[n7] + f2;
                int n8 = n5 * 8 + 4;
                fArray2[n8] = fArray2[n8] + f2;
                int n9 = n5 * 8 + 2;
                fArray2[n9] = fArray2[n9] + f3;
                f2 += f3;
            } else {
                int n10 = n5 * 2;
                fArray3[n10] = fArray3[n10] + (f2 += fArray[n2 + n5 * 2]);
                int n11 = n5 * 8 + 0;
                fArray2[n11] = fArray2[n11] + f2;
                int n12 = n5 * 8 + 4;
                fArray2[n12] = fArray2[n12] + f2;
                f2 += fArray[n2 + n5 * 2 + 1];
            }
            ++n5;
        }
        int n13 = n3 * 2;
        fArray3[n13] = fArray3[n13] + f2;
        standardGlyphVector.setGlyphPositions(fArray3);
        ExtendedTextSourceLabel extendedTextSourceLabel = new ExtendedTextSourceLabel(this.source, this.decorator);
        extendedTextSourceLabel.gv = standardGlyphVector;
        extendedTextSourceLabel.charinfo = fArray2;
        return extendedTextSourceLabel;
    }

    public ExtendedTextSourceLabel(TextSource textSource, Decoration decoration) {
        this.source = textSource;
        this.decorator = decoration;
    }

    public ExtendedTextSourceLabel(TextSource textSource, ExtendedTextSourceLabel extendedTextSourceLabel, int n2) {
        this.source = textSource;
        this.decorator = extendedTextSourceLabel.decorator;
    }
}

