/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsConfig;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.security.action.GetPropertyAction;

public class Win32GraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    ColorModel dynamicColorModel;
    ColorModel colorModel;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    boolean offscreenAccelerationEnabled = true;
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private static boolean ddDisabled;
    private static boolean ddUsed;
    private static boolean ddInitialized;
    private static boolean pfDisabled;
    private static AWTPermission fullScreenExclusivePermission;

    public int getAvailableAcceleratedMemory() {
        return this.getDeviceMemoryNative(this.screen);
    }

    public int getScreen() {
        return this.screen;
    }

    public int getType() {
        return 0;
    }

    static {
        Win32OffScreenSurfaceData.initD3D();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        ddDisabled = string != null && string.length() > 0 && string.charAt(0) == 't';
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.awt.nopixfmt"));
        pfDisabled = string2 != null;
        Win32GraphicsDevice.initIDs();
    }

    public void displayChanged() {
        this.dynamicColorModel = null;
        this.defaultConfig = null;
        this.configs = null;
        this.topLevels.notifyListeners();
    }

    private static native void initIDs();

    public void paletteChanged() {
    }

    public static boolean isDirectDrawEnabled() {
        if (ddDisabled) {
            return false;
        }
        if (!ddInitialized) {
            ddUsed = Win32GraphicsDevice.isDirectDrawUsed();
            ddInitialized = true;
        }
        return ddUsed;
    }

    private static native boolean isDirectDrawUsed();

    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    public boolean isFullScreenSupported() {
        return this.screen == 0 || Win32GraphicsDevice.isDirectDrawEnabled();
    }

    public boolean isOffscreenAccelerationEnabled() {
        return this.offscreenAccelerationEnabled;
    }

    protected int getDefaultPixID(int n2) {
        if (pfDisabled) {
            return 0;
        }
        return this.getDefaultPixIDImpl(n2);
    }

    private native int getDefaultPixIDImpl(int var1);

    private native int getDeviceMemoryNative(int var1);

    protected int getMaxConfigs(int n2) {
        if (pfDisabled) {
            return 1;
        }
        return this.getMaxConfigsImpl(n2);
    }

    private native int getMaxConfigsImpl(int var1);

    public Win32GraphicsDevice(int n2) {
        this.screen = n2;
        this.initDevice(n2);
    }

    native void initDevice(int var1);

    protected native boolean isPixFmtSupported(int var1, int var2);

    private native boolean isDisplayModeAvailable(int var1, int var2, int var3, int var4, int var5);

    public synchronized DisplayMode getDisplayMode() {
        DisplayMode displayMode = this.getCurrentDisplayMode(this.screen, Win32GraphicsDevice.isDirectDrawEnabled());
        return displayMode;
    }

    public synchronized DisplayMode[] getDisplayModes() {
        ArrayList arrayList = new ArrayList();
        this.enumDisplayModes(this.screen, arrayList, Win32GraphicsDevice.isDirectDrawEnabled());
        int n2 = arrayList.size();
        DisplayMode[] displayModeArray = new DisplayMode[n2];
        int n3 = 0;
        while (n3 < n2) {
            displayModeArray[n3] = (DisplayMode)arrayList.get(n3);
            ++n3;
        }
        return displayModeArray;
    }

    private native DisplayMode getCurrentDisplayMode(int var1, boolean var2);

    public synchronized void setDisplayMode(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(displayMode);
            return;
        }
        if (displayMode == null && !this.isDisplayModeAvailable(displayMode)) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        Window window = this.getFullScreenWindow();
        if (window == null) {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
        this.configDisplayMode(this.screen, wWindowPeer, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate(), Win32GraphicsDevice.isDirectDrawEnabled());
    }

    public synchronized boolean isDisplayModeAvailable(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            return false;
        }
        if (Win32GraphicsDevice.isDirectDrawEnabled()) {
            return this.isDisplayModeAvailable(this.screen, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        }
        DisplayMode[] displayModeArray = this.getDisplayModes();
        int n2 = 0;
        while (n2 < displayModeArray.length) {
            if (displayMode.equals(displayModeArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            this.defaultConfig = Win32GraphicsConfig.getConfig(this, 0);
        }
        return this.defaultConfig;
    }

    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            int n2 = this.getMaxConfigs(this.screen);
            int n3 = this.getDefaultPixID(this.screen);
            Vector vector = new Vector(n2);
            if (n3 == 0) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, n3);
                vector.addElement(this.defaultConfig);
            } else {
                int n4 = 1;
                while (n4 <= n2) {
                    if (this.isPixFmtSupported(n4, this.screen)) {
                        if (n4 == n3) {
                            this.defaultConfig = Win32GraphicsConfig.getConfig(this, n4);
                            vector.addElement(this.defaultConfig);
                        } else {
                            vector.addElement(Win32GraphicsConfig.getConfig(this, n4));
                        }
                    }
                    ++n4;
                }
            }
            this.configs = new GraphicsConfiguration[vector.size()];
            vector.copyInto(this.configs);
        }
        return this.configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFullScreenWindow(Window window) {
        WWindowPeer wWindowPeer;
        Object object;
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        if (Win32GraphicsDevice.isDirectDrawEnabled() && window2 != null && (object = (WWindowPeer)window2.getPeer()) != null) {
            wWindowPeer = object;
            synchronized (wWindowPeer) {
                ((WComponentPeer)object).destroyBuffers();
                this.exitFullScreenExclusive(this.screen, (WindowPeer)object);
            }
        }
        super.setFullScreenWindow(window);
        if (this.isFullScreenSupported() && Win32GraphicsDevice.isDirectDrawEnabled() && window != null) {
            object = System.getSecurityManager();
            if (object != null) {
                if (fullScreenExclusivePermission == null) {
                    fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
                }
                ((SecurityManager)object).checkPermission(fullScreenExclusivePermission);
            }
            WWindowPeer wWindowPeer2 = wWindowPeer = (WWindowPeer)window.getPeer();
            synchronized (wWindowPeer2) {
                this.enterFullScreenExclusive(this.screen, wWindowPeer);
            }
        }
    }

    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen, false);
        }
        return this.colorModel;
    }

    public ColorModel getDynamicColorModel() {
        if (this.dynamicColorModel == null) {
            this.dynamicColorModel = this.makeColorModel(this.screen, true);
        }
        return this.dynamicColorModel;
    }

    private native ColorModel makeColorModel(int var1, boolean var2);

    private native void enterFullScreenExclusive(int var1, WindowPeer var2);

    private native void exitFullScreenExclusive(int var1, WindowPeer var2);

    private native void configDisplayMode(int var1, WindowPeer var2, int var3, int var4, int var5, int var6, boolean var7);

    public String getIDstring() {
        return "\\Display" + this.screen;
    }

    public String toString() {
        return "Win32GraphicsDevice[screen=" + this.screen + "]";
    }

    private native void enumDisplayModes(int var1, ArrayList var2, boolean var3);

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }
}

