/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import sun.awt.SunToolkit;

public abstract class GlobalCursorManager {
    private final NativeUpdater nativeUpdater = new NativeUpdater(this);
    private long lastUpdateMillis;
    private final Object lastUpdateLock = new Object();
    private final Object treeLock = new Container().getTreeLock();

    protected GlobalCursorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately() {
        NativeUpdater nativeUpdater = this.nativeUpdater;
        synchronized (nativeUpdater) {
            this.nativeUpdater.pending = false;
        }
        this._updateCursor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateCursor(boolean bl2) {
        Object object = this.lastUpdateLock;
        synchronized (object) {
            this.lastUpdateMillis = System.currentTimeMillis();
        }
        Point point = null;
        Point point2 = null;
        try {
            Component component = this.findHeavyweightUnderCursor(bl2);
            if (component == null) {
                return;
            }
            if (component instanceof Window) {
                point2 = component.getLocation();
            } else if (component instanceof Container) {
                point2 = this.getLocationOnScreen(component);
            }
            if (point2 != null) {
                point = new Point();
                this.getCursorPos(point);
                Component component2 = this.findComponentAt((Container)component, point.x - point2.x, point.y - point2.y);
                if (component2 != null) {
                    component = component2;
                }
            }
            this.setCursor(component, component.getCursor(), bl2);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {}
    }

    public void updateCursorLater(Component component) {
        this.nativeUpdater.postIfNotPending(component, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), this.nativeUpdater));
    }

    protected abstract Component findHeavyweightUnderCursor(boolean var1);

    protected abstract void getCursorPos(Point var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately(InputEvent inputEvent) {
        boolean bl2;
        Object object = this.lastUpdateLock;
        synchronized (object) {
            bl2 = inputEvent.getWhen() >= this.lastUpdateMillis;
        }
        if (bl2) {
            this._updateCursor(true);
        }
    }

    static void access$000(GlobalCursorManager globalCursorManager, boolean bl2) {
        globalCursorManager._updateCursor(bl2);
    }

    protected abstract Component findComponentAt(Container var1, int var2, int var3);

    protected abstract void setCursor(Component var1, Cursor var2, boolean var3);

    protected abstract Point getLocationOnScreen(Component var1);

    class NativeUpdater
    implements Runnable {
        boolean pending;
        private final GlobalCursorManager this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl2 = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (this.pending) {
                    this.pending = false;
                    bl2 = true;
                }
            }
            if (bl2) {
                GlobalCursorManager.access$000(this.this$0, false);
            }
        }

        NativeUpdater(GlobalCursorManager globalCursorManager) {
            this.this$0 = globalCursorManager;
            this.pending = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postIfNotPending(Component component, InvocationEvent invocationEvent) {
            boolean bl2 = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (!this.pending) {
                    bl2 = true;
                    this.pending = true;
                }
            }
            if (bl2) {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(component), invocationEvent);
            }
        }
    }
}

