/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.ref.DTMSafeStringPool;
import org.apache.xml.dtm.ref.DTMStringPool;

public class ExpandedNameTable {
    private DTMStringPool m_locNamesPool;
    private DTMStringPool m_namespaceNames;
    public static int BITS_PER_LOCALNAME = 16;
    public static int BITS_PER_NAMESPACE = 10;
    public static int MASK_LOCALNAME = 65535;
    public static int MASK_NAMESPACE = 0x3FF0000;
    public static int MASK_NODETYPE = -67108864;
    public static int MASK_NODEHANDLE = 1048575;
    public static final int ROTAMOUNT_TYPE = BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
    public static final int ELEMENT = 1 << ROTAMOUNT_TYPE;
    public static final int ATTRIBUTE = 2 << ROTAMOUNT_TYPE;
    public static final int TEXT = 3 << ROTAMOUNT_TYPE;
    public static final int CDATA_SECTION = 4 << ROTAMOUNT_TYPE;
    public static final int ENTITY_REFERENCE = 5 << ROTAMOUNT_TYPE;
    public static final int ENTITY = 6 << ROTAMOUNT_TYPE;
    public static final int PROCESSING_INSTRUCTION = 7 << ROTAMOUNT_TYPE;
    public static final int COMMENT = 8 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT = 9 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_TYPE = 10 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_FRAGMENT = 11 << ROTAMOUNT_TYPE;
    public static final int NOTATION = 12 << ROTAMOUNT_TYPE;
    public static final int NAMESPACE = 13 << ROTAMOUNT_TYPE;

    public ExpandedNameTable() {
        this.m_locNamesPool = new DTMSafeStringPool();
        this.m_namespaceNames = new DTMSafeStringPool();
    }

    public int getExpandedTypeID(int n2) {
        int n3 = n2 << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
        return n3;
    }

    public static final int getLocalNameID(int n2) {
        return n2 & MASK_LOCALNAME;
    }

    public static final int getNamespaceID(int n2) {
        return (n2 & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
    }

    public static final short getType(int n2) {
        return (short)(n2 >> ROTAMOUNT_TYPE);
    }

    public String getLocalName(int n2) {
        return this.m_locNamesPool.indexToString(n2 & MASK_LOCALNAME);
    }

    public String getNamespace(int n2) {
        int n3 = (n2 & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
        return 0 == n3 ? null : this.m_namespaceNames.indexToString(n3);
    }

    public int getExpandedTypeID(String string, String string2, int n2) {
        int n3 = null != string ? this.m_namespaceNames.stringToIndex(string) : 0;
        int n4 = this.m_locNamesPool.stringToIndex(string2);
        int n5 = n2 << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME | n3 << BITS_PER_LOCALNAME | n4;
        return n5;
    }

    public ExpandedNameTable(DTMStringPool dTMStringPool, DTMStringPool dTMStringPool2) {
        this.m_locNamesPool = dTMStringPool;
        this.m_namespaceNames = dTMStringPool2;
    }
}

