/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xalan.res.XSLMessages;

public final class WriterToUTF8Buffered
extends Writer {
    private OutputStream m_os;
    private byte[] buf;
    private int count;

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(int n2) throws IOException {
        if (n2 < 128) {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)n2;
        } else if (n2 < 2048) {
            if (this.count + 1 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(192 + (n2 >> 6));
            this.buf[this.count++] = (byte)(128 + (n2 & 0x3F));
        } else {
            if (this.count + 2 >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)(224 + (n2 >> 12));
            this.buf[this.count++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (n2 & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        int n4 = (n3 << 1) + n3;
        if (n4 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(cArray, n2, n3);
            return;
        }
        if (n4 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n5 = n3 + n2;
        int n6 = n2;
        while (n6 < n5) {
            char c2 = cArray[n6];
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
            } else if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c2 >> 12));
                this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n6;
        }
    }

    private final void writeDirect(char[] cArray, int n2, int n3) throws IOException {
        OutputStream outputStream = this.m_os;
        int n4 = n3 + n2;
        int n5 = n2;
        while (n5 < n4) {
            char c2 = cArray[n5];
            if (c2 < '\u0080') {
                outputStream.write(c2);
            } else if (c2 < '\u0800') {
                outputStream.write(192 + (c2 >> 6));
                outputStream.write(128 + (c2 & 0x3F));
            } else {
                outputStream.write(224 + (c2 >> 12));
                outputStream.write(128 + (c2 >> 6 & 0x3F));
                outputStream.write(128 + (c2 & 0x3F));
            }
            ++n5;
        }
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this(outputStream, 8192);
    }

    public WriterToUTF8Buffered(OutputStream outputStream, int n2) {
        this.m_os = outputStream;
        if (n2 <= 0) {
            throw new IllegalArgumentException(XSLMessages.createMessage(136, null));
        }
        this.buf = new byte[n2];
        this.count = 0;
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        int n3 = (n2 << 1) + n2;
        if (n3 >= this.buf.length) {
            this.flushBuffer();
            this.writeDirect(string);
            return;
        }
        if (n3 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        OutputStream outputStream = this.m_os;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = string.charAt(n4);
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
            } else if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c2 >> 12));
                this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n4;
        }
    }

    private final void writeDirect(String string) throws IOException {
        int n2 = string.length();
        OutputStream outputStream = this.m_os;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 < '\u0080') {
                outputStream.write(c2);
            } else if (c2 < '\u0800') {
                outputStream.write(192 + (c2 >> 6));
                outputStream.write(128 + (c2 & 0x3F));
            } else {
                outputStream.write(224 + (c2 >> 12));
                outputStream.write(128 + (c2 >> 6 & 0x3F));
                outputStream.write(128 + (c2 & 0x3F));
            }
            ++n3;
        }
    }
}

