/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.util;

import org.apache.crimson.util.XmlChars;

public class XmlNames {
    public static final String SPEC_XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String SPEC_XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    private XmlNames() {
    }

    public static boolean isNCNmtoken(String string) {
        return XmlNames.isNmtoken(string) && string.indexOf(58) < 0;
    }

    public static boolean isName(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!XmlChars.isLetter(c2) && c2 != '_' && c2 != ':') {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            if (!XmlChars.isNameChar(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNmtoken(String string) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (!XmlChars.isNameChar(string.charAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isQualifiedName(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(58);
        if (n2 <= 0) {
            return XmlNames.isUnqualifiedName(string);
        }
        int n3 = string.lastIndexOf(58);
        if (n3 != n2) {
            return false;
        }
        return XmlNames.isUnqualifiedName(string.substring(0, n2)) && XmlNames.isUnqualifiedName(string.substring(n2 + 1));
    }

    public static boolean isUnqualifiedName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!XmlChars.isLetter(c2) && c2 != '_') {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            if (!XmlChars.isNCNameChar(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getLocalPart(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return string;
        }
        if (n2 == string.length() - 1) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    public static String getPrefix(String string) {
        int n2 = string.indexOf(58);
        return n2 <= 0 ? null : string.substring(0, n2);
    }
}

