/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Locale;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.PINode;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.EntityReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XmlDocumentBuilder
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected XmlDocument document;
    protected Locator locator;
    private Locale locale = Locale.getDefault();
    private ElementFactory factory;
    private Vector attrTmp = new Vector();
    protected ParentNode[] elementStack;
    protected int topOfStack;
    private boolean inDTD;
    private boolean inCDataSection;
    private Doctype doctype;
    private boolean disableNamespaces = true;
    private boolean ignoreWhitespace = false;
    private boolean expandEntityRefs = true;
    private boolean ignoreComments = false;
    private boolean putCDATAIntoText = false;
    static Class class$org$apache$crimson$tree$TextNode;

    public void endCDATA() throws SAXException {
        this.inCDataSection = false;
    }

    public void endDTD() throws SAXException {
        this.document.appendChild(this.doctype);
        this.inDTD = false;
    }

    public void endDocument() throws SAXException {
        if (this.topOfStack != 0) {
            throw new IllegalStateException(this.getMessage("XDB-000"));
        }
        this.document.trimToSize();
    }

    public void startCDATA() throws SAXException {
        if (this.putCDATAIntoText) {
            return;
        }
        CDATASection cDATASection = this.document.createCDATASection("");
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = true;
            parentNode.appendChild(cDATASection);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        if (this.locator != null) {
            this.document.setSystemId(this.locator.getSystemId());
        }
        this.elementStack = new ParentNode[200];
        this.topOfStack = 0;
        this.elementStack[this.topOfStack] = this.document;
        this.inDTD = false;
    }

    public boolean getDisableNamespaces() {
        return this.disableNamespaces;
    }

    public boolean isIgnoringLexicalInfo() {
        return this.ignoreWhitespace && this.expandEntityRefs && this.ignoreComments && this.putCDATAIntoText;
    }

    public void setDisableNamespaces(boolean bl2) {
        this.disableNamespaces = bl2;
    }

    public void setExpandEntityReferences(boolean bl2) {
        this.expandEntityRefs = bl2;
    }

    public void setIgnoreComments(boolean bl2) {
        this.ignoreComments = bl2;
    }

    public void setIgnoreWhitespace(boolean bl2) {
        this.ignoreWhitespace = bl2;
    }

    public void setIgnoringLexicalInfo(boolean bl2) {
        this.ignoreWhitespace = bl2;
        this.expandEntityRefs = bl2;
        this.ignoreComments = bl2;
        this.putCDATAIntoText = bl2;
    }

    public void setPutCDATAIntoText(boolean bl2) {
        this.putCDATAIntoText = bl2;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String string = new String(cArray, n2, n3);
            CDATASection cDATASection = (CDATASection)parentNode.getLastChild();
            cDATASection.appendData(string);
            return;
        }
        try {
            NodeBase nodeBase = (NodeBase)parentNode.getLastChild();
            if (nodeBase != null && nodeBase.getClass() == (class$org$apache$crimson$tree$TextNode == null ? (class$org$apache$crimson$tree$TextNode = XmlDocumentBuilder.class$("org.apache.crimson.tree.TextNode")) : class$org$apache$crimson$tree$TextNode)) {
                String string = new String(cArray, n2, n3);
                ((TextNode)nodeBase).appendData(string);
            } else {
                TextNode textNode = this.document.newText(cArray, n2, n3);
                parentNode.appendChild(textNode);
            }
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        if (this.ignoreComments || this.inDTD) {
            return;
        }
        String string = new String(cArray, n2, n3);
        Comment comment = this.document.createComment(string);
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            parentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.ignoreWhitespace) {
            return;
        }
        this.characters(cArray, n2, n3);
    }

    public void endEntity(String string) throws SAXException {
        if (this.inDTD) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        if (!(parentNode instanceof EntityReference)) {
            return;
        }
        parentNode.setReadonly(true);
        this.elementStack[this.topOfStack--] = null;
        if (!string.equals(parentNode.getNodeName())) {
            throw new SAXParseException(this.getMessage("XDB-011", new Object[]{string, parentNode.getNodeName()}), this.locator);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        if (this.expandEntityRefs || this.inDTD) {
            return;
        }
        EntityReference entityReference = this.document.createEntityReference(string);
        this.elementStack[this.topOfStack++].appendChild(entityReference);
        this.elementStack[this.topOfStack] = (ParentNode)((Object)entityReference);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public final void setElementFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    public XmlDocument createDocument() {
        XmlDocument xmlDocument = new XmlDocument();
        if (this.factory != null) {
            xmlDocument.setElementFactory(this.factory);
        }
        return xmlDocument;
    }

    public XmlDocument getDocument() {
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (!string.startsWith("%")) {
            this.doctype.addEntityNode(string, string2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        ParentNode parentNode = this.elementStack[this.topOfStack];
        try {
            PINode pINode = (PINode)this.document.createProcessingInstruction(string, string2);
            parentNode.appendChild(pINode);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = XmlDocument.catalog.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    String getMessage(String string, Object[] objectArray) {
        if (this.locale == null) {
            this.getLocale();
        }
        return XmlDocument.catalog.getMessage(this.locale, string, objectArray);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        ParentNode parentNode = this.elementStack[this.topOfStack];
        this.elementStack[this.topOfStack--] = null;
        parentNode.reduceWaste();
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (!string.startsWith("%")) {
            this.doctype.addEntityNode(string, string2, string3, null);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.doctype.addNotation(string, string2, string3);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        DOMImplementation dOMImplementation = this.document.getImplementation();
        this.doctype = (Doctype)dOMImplementation.createDocumentType(string, string2, string3);
        this.doctype.setOwnerDocument(this.document);
        this.inDTD = true;
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.doctype.addEntityNode(string, string2, string3, string4);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        AttributeSet attributeSet = null;
        int n2 = attributes.getLength();
        if (n2 != 0) {
            try {
                attributeSet = AttributeSet.createAttributeSet1(attributes);
            }
            catch (DOMException dOMException) {
                throw new SAXParseException(this.getMessage("XDB-002", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
            }
        }
        ElementNode elementNode = null;
        try {
            elementNode = (ElementNode)this.document.createElementEx(string3);
        }
        catch (DOMException dOMException) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{dOMException.getMessage()}), this.locator, dOMException);
        }
        if (attributes instanceof AttributesEx) {
            elementNode.setIdAttributeName(((AttributesEx)attributes).getIdAttributeName());
        }
        if (n2 != 0) {
            elementNode.setAttributes(attributeSet);
        }
        this.elementStack[this.topOfStack++].appendChild(elementNode);
        this.elementStack[this.topOfStack] = elementNode;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }
}

