/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;

    float getLongestWordSpan() {
        float f2;
        block5: {
            f2 = 0.0f;
            try {
                Document document = this.getDocument();
                int n2 = this.getStartOffset();
                int n3 = this.getEndOffset();
                if (n3 <= n2) break block5;
                Segment segment = new Segment();
                document.getText(n2, n3 - n2, segment);
                int n4 = n2;
                int n5 = n2;
                Container container = this.getContainer();
                BreakIterator breakIterator = container != null ? BreakIterator.getWordInstance(container.getLocale()) : BreakIterator.getWordInstance();
                breakIterator.setText(segment);
                int n6 = breakIterator.first();
                int n7 = breakIterator.next();
                while (n7 != -1) {
                    if (n7 - n6 > n5 - n4) {
                        n4 = n6;
                        n5 = n7;
                    }
                    n6 = n7;
                    n7 = breakIterator.next();
                }
                if (n5 - n4 > 0) {
                    FontMetrics fontMetrics = this.getFontMetrics();
                    int n8 = segment.offset + n4 - segment.getBeginIndex();
                    f2 = fontMetrics.charsWidth(segment.array, n8, n5 - n4);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return f2;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl2 = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl2);
        boolean bl3 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl3);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl3 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl3);
        bl3 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl3);
        Object object3 = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object3 != null && object3.equals("nowrap");
    }

    public int getBreakWeight(int n2, float f2, float f3) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(n2, f2, f3);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
    }
}

