/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.AccessibleHTML;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CommentView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.HiddenTagView;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.IsindexView;
import javax.swing.text.html.LineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.Map;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NoFramesView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.ResourceLoader;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit
implements Accessible {
    private JEditorPane theEditor;
    public static final String DEFAULT_CSS = "default.css";
    private AccessibleContext accessibleContext;
    private static final Cursor MoveCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(0);
    private static final ViewFactory defaultFactory = new HTMLFactory();
    MutableAttributeSet input;
    private static StyleSheet defaultStyles = null;
    private LinkController linkHandler = new LinkController();
    private static Parser defaultParser = null;
    private Cursor defaultCursor = DefaultCursor;
    private Cursor linkCursor = MoveCursor;
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final String INSERT_TABLE_HTML = "<table border=1><tr><td></td></tr></table>";
    private static final String INSERT_UL_HTML = "<ul><li></li></ul>";
    private static final String INSERT_OL_HTML = "<ol><li></li></ol>";
    private static final String INSERT_HR_HTML = "<hr>";
    private static final String INSERT_PRE_HTML = "<pre></pre>";
    private static NavigateLinkAction nextLinkAction = new NavigateLinkAction("next-link-action");
    private static NavigateLinkAction previousLinkAction = new NavigateLinkAction("previous-link-action");
    private static ActivateLinkAction activateLinkAction = new ActivateLinkAction("activate-link-action");
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableDataCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL), new InsertHRAction(), new InsertHTMLTextAction("InsertPre", "<pre></pre>", HTML.Tag.BODY, HTML.Tag.PRE), nextLinkAction, previousLinkAction, activateLinkAction};
    static Class class$javax$swing$text$html$HTMLEditorKit;

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public Object clone() {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)super.clone();
        if (hTMLEditorKit != null) {
            hTMLEditorKit.input = null;
            hTMLEditorKit.linkHandler = new LinkController();
        }
        return hTMLEditorKit;
    }

    public String getContentType() {
        return "text/html";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.theEditor == null) {
            return null;
        }
        if (this.accessibleContext == null) {
            AccessibleHTML accessibleHTML = new AccessibleHTML(this.theEditor);
            this.accessibleContext = accessibleHTML.getAccessibleContext();
        }
        return this.accessibleContext;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeMouseListener(this.linkHandler);
        jEditorPane.removeMouseMotionListener(this.linkHandler);
        super.deinstall(jEditorPane);
        this.theEditor = null;
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.linkHandler);
        jEditorPane.addMouseMotionListener(this.linkHandler);
        jEditorPane.addCaretListener(nextLinkAction);
        super.install(jEditorPane);
        this.theEditor = jEditorPane;
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(styleSheet2);
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    public MutableAttributeSet getInputAttributes() {
        if (this.input == null) {
            this.input = this.getStyleSheet().addStyle(null, null);
        }
        return this.input;
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    protected Parser getParser() {
        block2: {
            if (defaultParser != null) break block2;
            try {
                Class clazz = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (Parser)clazz.newInstance();
            }
            catch (Throwable throwable) {}
        }
        return defaultParser;
    }

    public StyleSheet getStyleSheet() {
        block2: {
            if (defaultStyles != null) break block2;
            defaultStyles = new StyleSheet();
            try {
                InputStream inputStream = HTMLEditorKit.getResourceAsStream(DEFAULT_CSS);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                defaultStyles.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
            catch (Throwable throwable) {}
        }
        return defaultStyles;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        defaultStyles = styleSheet;
    }

    static InputStream getResourceAsStream(String string) {
        try {
            return ResourceLoader.getResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return (class$javax$swing$text$html$HTMLEditorKit == null ? (class$javax$swing$text$html$HTMLEditorKit = HTMLEditorKit.class$("javax.swing.text.html.HTMLEditorKit")) : class$javax$swing$text$html$HTMLEditorKit).getResourceAsStream(string);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            Parser parser = this.getParser();
            if (parser == null) {
                throw new IOException("Can't load parser");
            }
            if (n2 > document.getLength()) {
                throw new BadLocationException("Invalid location", n2);
            }
            ParserCallback parserCallback = hTMLDocument.getReader(n2);
            Boolean bl2 = (Boolean)document.getProperty("IgnoreCharsetDirective");
            parser.parse(reader, parserCallback, bl2 == null ? false : bl2);
            parserCallback.flush();
        } else {
            super.read(reader, document, n2);
        }
    }

    public void write(Writer writer, Document document, int n2, int n3) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLWriter hTMLWriter = new HTMLWriter(writer, (HTMLDocument)document, n2, n3);
            hTMLWriter.write();
        } else if (document instanceof StyledDocument) {
            MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n2, n3);
            minimalHTMLWriter.write();
        } else {
            super.write(writer, document, n2, n3);
        }
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
        mutableAttributeSet.removeAttribute(StyleConstants.ComposedTextAttribute);
        Object object = mutableAttributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            if (tag == HTML.Tag.IMG) {
                mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
                mutableAttributeSet.removeAttribute(HTML.Attribute.HEIGHT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.WIDTH);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.HR || tag == HTML.Tag.BR) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.COMMENT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.COMMENT);
            } else if (tag == HTML.Tag.INPUT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Tag.INPUT);
            } else if (tag instanceof HTML.UnknownTag) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.ENDTAG);
            }
        }
    }

    static Object access$000(AttributeSet attributeSet, HTML.Attribute attribute) {
        return HTMLEditorKit.getAttrValue(attributeSet, attribute);
    }

    private static Object getAttrValue(AttributeSet attributeSet, HTML.Attribute attribute) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = attributeSet.getAttribute(object);
            if (object2 instanceof AttributeSet) {
                Object object3 = HTMLEditorKit.getAttrValue((AttributeSet)object2, attribute);
                if (object3 == null) continue;
                return object3;
            }
            if (object != attribute) continue;
            return object2;
        }
        return null;
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n2, String string, int n3, int n4, HTML.Tag tag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (parser == null) {
            throw new IOException("Can't load parser");
        }
        if (n2 > hTMLDocument.getLength()) {
            throw new BadLocationException("Invalid location", n2);
        }
        ParserCallback parserCallback = hTMLDocument.getReader(n2, n3, n4, tag);
        Boolean bl2 = (Boolean)hTMLDocument.getProperty("IgnoreCharsetDirective");
        parser.parse(new StringReader(string), parserCallback, bl2 == null ? false : bl2);
        parserCallback.flush();
    }

    static class ActivateLinkAction
    extends TextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable() || !(jTextComponent instanceof JEditorPane)) {
                return;
            }
            JEditorPane jEditorPane = (JEditorPane)jTextComponent;
            Document document = jEditorPane.getDocument();
            if (document == null || !(document instanceof HTMLDocument)) {
                return;
            }
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            ElementIterator elementIterator = new ElementIterator(hTMLDocument);
            int n2 = jEditorPane.getCaretPosition();
            Object var8_8 = null;
            Object var9_9 = null;
            Element element = null;
            while ((element = elementIterator.next()) != null) {
                Object object;
                String string = element.getName();
                AttributeSet attributeSet = element.getAttributes();
                Object object2 = HTMLEditorKit.access$000(attributeSet, HTML.Attribute.HREF);
                if (object2 != null) {
                    if (n2 < element.getStartOffset() || n2 > element.getEndOffset()) continue;
                    this.activateLink((String)object2, hTMLDocument, jEditorPane, n2);
                    return;
                }
                if (!string.equals(HTML.Tag.OBJECT.toString()) || (object = HTMLEditorKit.access$000(attributeSet, HTML.Attribute.CLASSID)) == null || n2 < element.getStartOffset() || n2 > element.getEndOffset()) continue;
                this.doObjectAction(jEditorPane, element);
                return;
            }
        }

        private void unlock(Object object) {
            if (object != null) {
                ((AbstractDocument)object).readUnlock();
            }
        }

        public ActivateLinkAction(String string) {
            super(string);
        }

        private Object lock(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
                return document;
            }
            return null;
        }

        private void doObjectAction(JEditorPane jEditorPane, Element element) {
            AccessibleAction accessibleAction;
            AccessibleContext accessibleContext;
            Component component;
            View view = this.getView(jEditorPane, element);
            if (view != null && view instanceof ObjectView && (component = ((ObjectView)view).getComponent()) != null && component instanceof Accessible && (accessibleContext = ((Accessible)((Object)component)).getAccessibleContext()) != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                accessibleAction.doAccessibleAction(0);
            }
        }

        private View getRootView(JEditorPane jEditorPane) {
            return jEditorPane.getUI().getRootView(jEditorPane);
        }

        private void activateLink(String string, HTMLDocument hTMLDocument, JEditorPane jEditorPane, int n2) {
            try {
                URL uRL = (URL)hTMLDocument.getProperty("stream");
                URL uRL2 = new URL(uRL, string);
                HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL2, uRL2.toExternalForm(), hTMLDocument.getCharacterElement(n2));
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
            catch (MalformedURLException malformedURLException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private View getView(JEditorPane jEditorPane, Element element) {
            Object object;
            block3: {
                object = this.lock(jEditorPane);
                try {
                    View view = this.getRootView(jEditorPane);
                    int n2 = element.getStartOffset();
                    if (view == null) break block3;
                    View view2 = this.getView(view, element, n2);
                    Object var8_8 = null;
                    this.unlock(object);
                    return view2;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.unlock(object);
                    throw throwable;
                }
            }
            View view = null;
            Object var8_9 = null;
            this.unlock(object);
            return view;
        }

        private View getView(View view, Element element, int n2) {
            if (view.getElement() == element) {
                return view;
            }
            int n3 = view.getViewIndex(n2, Position.Bias.Forward);
            if (n3 != -1 && n3 < view.getViewCount()) {
                return this.getView(view.getView(n3), element, n2);
            }
            return null;
        }
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            Object object;
            Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object2 instanceof HTML.Tag) {
                object = (HTML.Tag)object2;
                if (object == HTML.Tag.CONTENT) {
                    return new InlineView(element);
                }
                if (object == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string != null && string.equals("pre")) {
                        return new LineView(element);
                    }
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.P || object == HTML.Tag.H1 || object == HTML.Tag.H2 || object == HTML.Tag.H3 || object == HTML.Tag.H4 || object == HTML.Tag.H5 || object == HTML.Tag.H6 || object == HTML.Tag.DT) {
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.MENU || object == HTML.Tag.DIR || object == HTML.Tag.UL || object == HTML.Tag.OL) {
                    return new ListView(element);
                }
                if (object == HTML.Tag.BODY) {
                    return new BodyBlockView(element);
                }
                if (object == HTML.Tag.HTML) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.LI || object == HTML.Tag.CENTER || object == HTML.Tag.DL || object == HTML.Tag.DD || object == HTML.Tag.DIV || object == HTML.Tag.BLOCKQUOTE || object == HTML.Tag.PRE || object == HTML.Tag.FORM) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.NOFRAMES) {
                    return new NoFramesView(element, 1);
                }
                if (object == HTML.Tag.IMG) {
                    return new ImageView(element);
                }
                if (object == HTML.Tag.ISINDEX) {
                    return new IsindexView(element);
                }
                if (object == HTML.Tag.HR) {
                    return new HRuleView(element);
                }
                if (object == HTML.Tag.BR) {
                    return new BRView(element);
                }
                if (object == HTML.Tag.TABLE) {
                    return new TableView(element);
                }
                if (object == HTML.Tag.INPUT || object == HTML.Tag.SELECT || object == HTML.Tag.TEXTAREA) {
                    return new FormView(element);
                }
                if (object == HTML.Tag.OBJECT) {
                    return new ObjectView(element);
                }
                if (object == HTML.Tag.FRAMESET) {
                    if (element.getAttributes().isDefined(HTML.Attribute.ROWS)) {
                        return new FrameSetView(element, 1);
                    }
                    if (element.getAttributes().isDefined(HTML.Attribute.COLS)) {
                        return new FrameSetView(element, 0);
                    }
                    throw new RuntimeException("Can't build a" + object + ", " + element + ":" + "no ROWS or COLS defined.");
                }
                if (object == HTML.Tag.FRAME) {
                    return new FrameView(element);
                }
                if (object instanceof HTML.UnknownTag) {
                    return new HiddenTagView(element);
                }
                if (object == HTML.Tag.COMMENT) {
                    return new CommentView(element);
                }
                if (object == HTML.Tag.HEAD) {
                    return new BlockView(this, element, 0){
                        private final HTMLFactory this$0;

                        public float getMaximumSpan(int n2) {
                            return 0.0f;
                        }

                        public float getMinimumSpan(int n2) {
                            return 0.0f;
                        }

                        public float getPreferredSpan(int n2) {
                            return 0.0f;
                        }

                        protected void loadChildren(ViewFactory viewFactory) {
                        }
                        {
                            this.this$0 = hTMLFactory;
                            super(element, n2);
                        }

                        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
                            return shape;
                        }

                        public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) {
                            return this.getElement().getEndOffset();
                        }
                    };
                }
                if (object == HTML.Tag.TITLE || object == HTML.Tag.META || object == HTML.Tag.LINK || object == HTML.Tag.STYLE || object == HTML.Tag.SCRIPT || object == HTML.Tag.AREA || object == HTML.Tag.MAP || object == HTML.Tag.PARAM || object == HTML.Tag.APPLET) {
                    return new HiddenTagView(element);
                }
            }
            if ((object = element.getName()) != null) {
                if (((String)object).equals("content")) {
                    return new LabelView(element);
                }
                if (((String)object).equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (((String)object).equals("section")) {
                    return new BoxView(element, 1);
                }
                if (((String)object).equals("component")) {
                    return new ComponentView(element);
                }
                if (((String)object).equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }

        private static class BodyBlockView
        extends BlockView
        implements ComponentListener {
            private Reference cachedViewPort = null;
            private boolean isListening = false;
            private int viewVisibleWidth = Integer.MAX_VALUE;
            private int componentVisibleWidth = Integer.MAX_VALUE;

            protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
                Container container;
                Container container2 = this.getContainer();
                if (container2 != null && container2 instanceof JEditorPane && (container = container2.getParent()) != null && container instanceof JViewport) {
                    JViewport jViewport = (JViewport)container;
                    if (this.cachedViewPort != null) {
                        Object object = this.cachedViewPort.get();
                        if (object != null) {
                            if (object != jViewport) {
                                ((JComponent)object).removeComponentListener(this);
                            }
                        } else {
                            this.cachedViewPort = null;
                        }
                    }
                    if (this.cachedViewPort == null) {
                        jViewport.addComponentListener(this);
                        this.cachedViewPort = new WeakReference(jViewport);
                    }
                    int n4 = this.getViewCount();
                    this.componentVisibleWidth = jViewport.getExtentSize().width;
                    Insets insets = container2.getInsets();
                    this.viewVisibleWidth = this.componentVisibleWidth - insets.left - this.getLeftInset();
                    n2 = Math.min(n2, this.viewVisibleWidth);
                    CSS.Attribute attribute = n3 == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
                    int n5 = 0;
                    while (n5 < n4) {
                        View view = this.getView(n5);
                        int n6 = (int)view.getMinimumSpan(n3);
                        int n7 = (int)view.getMaximumSpan(n3);
                        AttributeSet attributeSet = view.getAttributes();
                        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
                        if (lengthValue != null && lengthValue.isPercentage()) {
                            n7 = n6 = Math.max((int)lengthValue.getValue(n2), n6);
                        }
                        if (n7 < n2) {
                            float f2 = view.getAlignment(n3);
                            nArray[n5] = (int)((float)(n2 - n7) * f2);
                            nArray2[n5] = n7;
                        } else {
                            nArray[n5] = 0;
                            nArray2[n5] = Math.max(n6, n2);
                        }
                        ++n5;
                    }
                } else {
                    if (this.cachedViewPort != null) {
                        Object object = this.cachedViewPort.get();
                        if (object != null) {
                            ((JComponent)object).removeComponentListener(this);
                        }
                        this.cachedViewPort = null;
                    }
                    super.layoutMinorAxis(n2, n3, nArray, nArray2);
                }
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent componentEvent) {
                Document document;
                if (!(componentEvent.getSource() instanceof JViewport)) {
                    return;
                }
                JViewport jViewport = (JViewport)componentEvent.getSource();
                if (this.componentVisibleWidth != jViewport.getExtentSize().width && (document = this.getDocument()) instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
                    abstractDocument.readLock();
                    try {
                        this.layoutChanged(0);
                        this.preferenceChanged(null, true, true);
                        Object var6_5 = null;
                        abstractDocument.readUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        abstractDocument.readUnlock();
                        throw throwable;
                    }
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public BodyBlockView(Element element) {
                super(element, 1);
            }

            public void setParent(View view) {
                if (view == null && this.cachedViewPort != null) {
                    Object object = this.cachedViewPort.get();
                    if (object != null) {
                        ((JComponent)object).removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.setParent(view);
            }

            protected SizeRequirements calculateMajorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
                sizeRequirements = super.calculateMajorAxisRequirements(n2, sizeRequirements);
                sizeRequirements.maximum = Integer.MAX_VALUE;
                return sizeRequirements;
            }
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
            super(string);
        }

        private Element[] getElementsAt(Element element, int n2, int n3) {
            if (element.isLeaf()) {
                Element[] elementArray = new Element[n3 + 1];
                elementArray[n3] = element;
                return elementArray;
            }
            Element[] elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n2)), n2, n3 + 1);
            elementArray[n3] = element;
            return elementArray;
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n2) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n2, 0);
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n2, HTML.Tag tag) {
            int n3 = -1;
            Element element = hTMLDocument.getCharacterElement(n2);
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
                element = element.getParentElement();
                ++n3;
            }
            if (element == null) {
                return -1;
            }
            return n3;
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("document must be HTMLDocument");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be HTMLEditorKit");
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n2, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            Element element2 = null;
            while (element != null) {
                if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == tag) {
                    element2 = element;
                }
                element = element.getElement(element.getElementIndex(n2));
            }
            return element2;
        }
    }

    static class InsertHRAction
    extends InsertHTMLTextAction {
        InsertHRAction() {
            super("InsertHR", HTMLEditorKit.INSERT_HR_HTML, null, HTML.Tag.IMPLIED, null, null, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            HTMLDocument hTMLDocument;
            Element element;
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null && (element = (hTMLDocument = this.getHTMLDocument(jEditorPane)).getParagraphElement(n2 = jEditorPane.getSelectionStart())).getParentElement() != null) {
                this.parentTag = (HTML.Tag)element.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected HTML.Tag parentTag;
        protected HTML.Tag addTag;
        protected HTML.Tag alternateParentTag;
        protected HTML.Tag alternateAddTag;
        boolean adjustSelection;

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                HTMLDocument hTMLDocument = this.getHTMLDocument(jEditorPane);
                int n2 = jEditorPane.getSelectionStart();
                int n3 = hTMLDocument.getLength();
                boolean bl2 = !this.insertIntoTag(jEditorPane, hTMLDocument, n2, this.parentTag, this.addTag) && this.alternateParentTag != null ? this.insertIntoTag(jEditorPane, hTMLDocument, n2, this.alternateParentTag, this.alternateAddTag) : true;
                if (this.adjustSelection && bl2) {
                    this.adjustSelection(jEditorPane, hTMLDocument, n2, n3);
                }
            }
        }

        void adjustSelection(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n2, int n3) {
            int n4 = hTMLDocument.getLength();
            if (n4 != n3 && n2 < n4) {
                if (n2 > 0) {
                    String string;
                    try {
                        string = hTMLDocument.getText(n2 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        string = null;
                    }
                    if (string != null && string.length() > 0 && string.charAt(0) == '\n') {
                        jEditorPane.select(n2, n2);
                    } else {
                        jEditorPane.select(n2 + 1, n2 + 1);
                    }
                } else {
                    jEditorPane.select(1, 1);
                }
            }
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n2, String string, int n3, int n4, HTML.Tag tag) {
            try {
                this.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n2, string, n3, n4, tag);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to insert: " + iOException);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Unable to insert: " + badLocationException);
            }
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        boolean insertIntoTag(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n2, HTML.Tag tag, HTML.Tag tag2) {
            int n3;
            Element element = this.findElementMatchingTag(hTMLDocument, n2, tag);
            if (element != null && element.getStartOffset() == n2) {
                this.insertAtBoundary(jEditorPane, hTMLDocument, n2, element, this.html, tag, tag2);
                return true;
            }
            if (n2 > 0 && (n3 = this.elementCountToTag(hTMLDocument, n2 - 1, tag)) != -1) {
                this.insertHTML(jEditorPane, hTMLDocument, n2, this.html, n3, 0, tag2);
                return true;
            }
            return false;
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n2, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            this.insertAtBoundry(jEditorPane, hTMLDocument, n2, element, string, tag, tag2);
        }

        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n2, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            Element element2;
            Element element3;
            boolean bl2;
            boolean bl3 = bl2 = n2 == 0;
            if (n2 > 0 || element == null) {
                element3 = hTMLDocument.getDefaultRootElement();
                while (element3 != null && element3.getStartOffset() != n2 && !element3.isLeaf()) {
                    element3 = element3.getElement(element3.getElementIndex(n2));
                }
                element2 = element3 != null ? element3.getParentElement() : null;
            } else {
                element2 = element;
            }
            if (element2 != null) {
                int n3 = 0;
                int n4 = 0;
                if (bl2 && element != null) {
                    element3 = element2;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n2));
                        ++n3;
                    }
                } else {
                    element3 = element2;
                    --n2;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n2));
                        ++n3;
                    }
                    element3 = element2;
                    ++n2;
                    while (element3 != null && element3 != element) {
                        element3 = element3.getElement(element3.getElementIndex(n2));
                        ++n4;
                    }
                }
                n3 = Math.max(0, n3 - 1);
                this.insertHTML(jEditorPane, hTMLDocument, n2, string, n3, n4, tag2);
            }
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            this(string, string2, tag, tag2, tag3, tag4, true);
        }

        InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4, boolean bl2) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
            this.adjustSelection = bl2;
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element curElem = null;
        private boolean curElemImage = false;
        private String href = null;
        private Position.Bias[] bias = new Position.Bias[1];
        private int curOffset;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n2;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && (n2 = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                this.activateLink(n2, jEditorPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            boolean bl2 = true;
            Cursor cursor = hTMLEditorKit.getDefaultCursor();
            if (!jEditorPane.isEditable()) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n2 = jEditorPane.getUI().viewToModel(jEditorPane, point, this.bias);
                if (this.bias[0] == Position.Bias.Backward && n2 > 0) {
                    --n2;
                }
                if (n2 >= 0 && jEditorPane.getDocument() instanceof HTMLDocument) {
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    Element element = hTMLDocument.getCharacterElement(n2);
                    if (!this.doesElementContainLocation(jEditorPane, element, n2, mouseEvent.getX(), mouseEvent.getY())) {
                        element = null;
                    }
                    if (this.curElem != element || this.curElemImage) {
                        Element element2 = this.curElem;
                        this.curElem = element;
                        String string = null;
                        this.curElemImage = false;
                        if (element != null) {
                            AttributeSet attributeSet = element.getAttributes();
                            AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                            if (attributeSet2 == null) {
                                boolean bl3 = this.curElemImage = attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMG;
                                if (this.curElemImage) {
                                    string = this.getMapHREF(jEditorPane, hTMLDocument, element, attributeSet, n2, mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else {
                                string = (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                            }
                        }
                        if (string != this.href) {
                            this.fireEvents(jEditorPane, hTMLDocument, string, element2);
                            this.href = string;
                            if (string != null) {
                                cursor = hTMLEditorKit.getLinkCursor();
                            }
                        } else {
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                    }
                    this.curOffset = n2;
                }
            }
            if (bl2 && jEditorPane.getCursor() != cursor) {
                jEditorPane.setCursor(cursor);
            }
        }

        protected void activateLink(int n2, JEditorPane jEditorPane) {
            this.activateLink(n2, jEditorPane, -1, -1);
        }

        void activateLink(int n2, JEditorPane jEditorPane, int n3, int n4) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n2);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                HyperlinkEvent hyperlinkEvent = null;
                this.href = attributeSet2 == null ? this.getMapHREF(jEditorPane, hTMLDocument, element, attributeSet, n2, n3, n4) : (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                if (this.href != null) {
                    hyperlinkEvent = this.createHyperlinkEvent(jEditorPane, hTMLDocument, this.href, attributeSet2, element);
                }
                if (hyperlinkEvent != null) {
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
            }
        }

        private boolean doesElementContainLocation(JEditorPane jEditorPane, Element element, int n2, int n3, int n4) {
            if (element != null && n2 > 0 && element.getStartOffset() == n2) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, n2, Position.Bias.Forward);
                    Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                    Rectangle rectangle3 = textUI.modelToView(jEditorPane, element.getEndOffset(), Position.Bias.Backward);
                    Rectangle rectangle4 = rectangle3 instanceof Rectangle ? rectangle3 : rectangle3.getBounds();
                    rectangle2.add(rectangle4);
                    return rectangle2.contains(n3, n4);
                }
                catch (BadLocationException badLocationException) {
                }
            }
            return true;
        }

        void fireEvents(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, Element element) {
            HyperlinkEvent hyperlinkEvent;
            URL uRL;
            if (this.href != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), this.href);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.EXITED, uRL, this.href, element);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
            if (string != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ENTERED, uRL, string, this.curElem);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
        }

        private String getMapHREF(JEditorPane jEditorPane, HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet, int n2, int n3, int n4) {
            Map map;
            Object object = attributeSet.getAttribute(HTML.Attribute.USEMAP);
            if (object != null && object instanceof String && (map = hTMLDocument.getMap((String)object)) != null && n2 < hTMLDocument.getLength()) {
                Rectangle rectangle;
                Object object2;
                TextUI textUI = jEditorPane.getUI();
                try {
                    object2 = textUI.modelToView(jEditorPane, n2, Position.Bias.Forward);
                    Rectangle rectangle2 = textUI.modelToView(jEditorPane, n2 + 1, Position.Bias.Backward);
                    rectangle = object2.getBounds();
                    rectangle.add(rectangle2 instanceof Rectangle ? rectangle2 : rectangle2.getBounds());
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null && (object2 = map.getArea(n3 - rectangle.x, n4 - rectangle.y, rectangle.width, rectangle.height)) != null) {
                    return (String)object2.getAttribute(HTML.Attribute.HREF);
                }
            }
            return null;
        }

        HyperlinkEvent createHyperlinkEvent(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, AttributeSet attributeSet, Element element) {
            String string2;
            URL uRL;
            Serializable serializable;
            try {
                serializable = hTMLDocument.getBase();
                uRL = new URL((URL)serializable, string);
                if (string != null && "file".equals(uRL.getProtocol()) && string.startsWith("#")) {
                    string2 = ((URL)serializable).getFile();
                    String string3 = uRL.getFile();
                    if (string2 != null && string3 != null && !string3.startsWith(string2)) {
                        uRL = new URL((URL)serializable, string2 + string);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            serializable = null;
            if (!hTMLDocument.isFrameDocument()) {
                serializable = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element);
            } else {
                String string4 = string2 = attributeSet != null ? (String)attributeSet.getAttribute(HTML.Attribute.TARGET) : null;
                if (string2 == null || string2.equals("")) {
                    string2 = "_self";
                }
                serializable = new HTMLFrameHyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element, string2);
            }
            return serializable;
        }
    }

    static class NavigateLinkAction
    extends TextAction
    implements CaretListener {
        private static int prevHypertextOffset = -1;
        private static boolean foundLink = false;
        private FocusHighlightPainter focusPainter = new FocusHighlightPainter(this, null);
        private Object selectionTag;
        private boolean focusBack = false;

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent == null || jTextComponent.isEditable()) {
                return;
            }
            Document document = jTextComponent.getDocument();
            if (document == null) {
                return;
            }
            ElementIterator elementIterator = new ElementIterator(document);
            int n2 = jTextComponent.getCaretPosition();
            int n3 = -1;
            int n4 = -1;
            Element element = null;
            while ((element = elementIterator.next()) != null) {
                String string = element.getName();
                AttributeSet attributeSet = element.getAttributes();
                Object object = HTMLEditorKit.access$000(attributeSet, HTML.Attribute.HREF);
                if (!string.equals(HTML.Tag.OBJECT.toString()) && object == null) continue;
                int n5 = element.getStartOffset();
                if (this.focusBack) {
                    if (n5 >= n2 && n3 >= 0) {
                        foundLink = true;
                        jTextComponent.setCaretPosition(n3);
                        this.moveCaretPosition(jTextComponent, n3, n4);
                        prevHypertextOffset = n3;
                        return;
                    }
                } else if (n5 > n2) {
                    foundLink = true;
                    jTextComponent.setCaretPosition(n5);
                    this.moveCaretPosition(jTextComponent, n5, element.getEndOffset());
                    prevHypertextOffset = n5;
                    return;
                }
                n3 = element.getStartOffset();
                n4 = element.getEndOffset();
            }
        }

        public NavigateLinkAction(String string) {
            super(string);
            if ("previous-link-action".equals(string)) {
                this.focusBack = true;
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (foundLink) {
                foundLink = false;
                Object object = caretEvent.getSource();
                if (object instanceof JTextComponent) {
                    ((JTextComponent)object).getAccessibleContext().firePropertyChange("AccessibleHypertextOffset", new Integer(prevHypertextOffset), new Integer(caretEvent.getDot()));
                }
            }
        }

        private void moveCaretPosition(JTextComponent jTextComponent, int n2, int n3) {
            block3: {
                Highlighter highlighter = jTextComponent.getHighlighter();
                if (highlighter == null) break block3;
                int n4 = Math.min(n3, n2);
                int n5 = Math.max(n3, n2);
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n4, n5);
                        break block3;
                    }
                    FocusHighlightPainter focusHighlightPainter = this.focusPainter;
                    this.selectionTag = highlighter.addHighlight(n4, n5, focusHighlightPainter);
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            private final NavigateLinkAction this$0;

            FocusHighlightPainter(NavigateLinkAction navigateLinkAction, Color color) {
                this.this$0 = navigateLinkAction;
                super(color);
            }

            public Shape paintLayer(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent, View view) {
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (n2 == view.getStartOffset() && n3 == view.getEndOffset()) {
                    Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                try {
                    Shape shape2 = view.modelToView(n2, Position.Bias.Forward, n3, Position.Bias.Backward, shape);
                    Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] cArray, int n2) {
        }

        public void handleText(char[] cArray, int n2) {
        }

        public void handleEndOfLineString(String string) {
        }

        public void handleError(String string, int n2) {
        }

        public void handleEndTag(HTML.Tag tag, int n2) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
        }
    }
}

