/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    FontMetrics metrics;
    Segment lineBuffer;
    boolean widthChanging;
    int tabBase;
    int tabSize;
    boolean wordWrap;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    protected int getTabSize() {
        Integer n2 = (Integer)this.getDocument().getProperty("tabSize");
        int n3 = n2 != null ? n2 : 8;
        return n3;
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public void setSize(float f2, float f3) {
        this.updateMetrics();
        if ((int)f2 != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f2, f3);
        this.widthChanging = false;
    }

    public float nextTabStop(float f2, int n2) {
        int n3 = ((int)f2 - this.tabBase) / this.tabSize;
        return this.tabBase + (n3 + 1) * this.tabSize;
    }

    public float getMaximumSpan(int n2) {
        this.updateMetrics();
        return super.getMaximumSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        this.updateMetrics();
        return super.getMinimumSpan(n2);
    }

    public float getPreferredSpan(int n2) {
        this.updateMetrics();
        return super.getPreferredSpan(n2);
    }

    protected int calculateBreakPosition(int n2, int n3) {
        Segment segment = SegmentCache.getSharedSegment();
        this.loadText(segment, n2, n3);
        int n4 = this.wordWrap ? n2 + Utilities.getBreakLocation(segment, this.metrics, this.tabBase, this.tabBase + this.getWidth(), this, n2) : n2 + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, this.tabBase + this.getWidth(), this, n2);
        SegmentCache.releaseSharedSegment(segment);
        return n4;
    }

    protected void drawLine(int n2, int n3, Graphics graphics, int n4, int n5) {
        Element element = this.getElement();
        Element element2 = element.getElement(element.getElementIndex(n2));
        try {
            if (element2.isLeaf()) {
                this.drawText(element2, n2, n3, graphics, n4, n5);
            } else {
                int n6 = element2.getElementIndex(n2);
                int n7 = element2.getElementIndex(n3);
                while (n6 <= n7) {
                    Element element3 = element2.getElement(n6);
                    int n8 = Math.max(element3.getStartOffset(), n2);
                    int n9 = Math.min(element3.getEndOffset(), n3);
                    n4 = this.drawText(element3, n8, n9, graphics, n4, n5);
                    ++n6;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render: " + n2 + "," + n3);
        }
    }

    protected int drawSelectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    protected int drawUnselectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    public WrappedPlainView(Element element) {
        this(element, false);
    }

    public WrappedPlainView(Element element, boolean bl2) {
        super(element, 1);
        this.wordWrap = bl2;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    final void loadText(Segment segment, int n2, int n3) {
        try {
            Document document = this.getDocument();
            document.getText(n2, n3 - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't get line text");
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n2 = element.getElementCount();
        if (n2 > 0) {
            View[] viewArray = new View[n2];
            int n3 = 0;
            while (n3 < n2) {
                viewArray[n3] = new WrappedLine(this, element.getElement(n3));
                ++n3;
            }
            this.replace(0, 0, viewArray);
        }
    }

    private int drawText(Element element, int n2, int n3, Graphics graphics, int n4, int n5) throws BadLocationException {
        n3 = Math.min(this.getDocument().getLength(), n3);
        AttributeSet attributeSet = element.getAttributes();
        if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
            graphics.setColor(this.unselected);
            n4 = Utilities.drawComposedText(attributeSet, graphics, n4, n5, n2 - element.getStartOffset(), n3 - element.getStartOffset());
        } else if (this.sel0 == this.sel1) {
            n4 = this.drawUnselectedText(graphics, n4, n5, n2, n3);
        } else if (n2 >= this.sel0 && n2 <= this.sel1 && n3 >= this.sel0 && n3 <= this.sel1) {
            n4 = this.drawSelectedText(graphics, n4, n5, n2, n3);
        } else if (this.sel0 >= n2 && this.sel0 <= n3) {
            if (this.sel1 >= n2 && this.sel1 <= n3) {
                n4 = this.drawUnselectedText(graphics, n4, n5, n2, this.sel0);
                n4 = this.drawSelectedText(graphics, n4, n5, this.sel0, this.sel1);
                n4 = this.drawUnselectedText(graphics, n4, n5, this.sel1, n3);
            } else {
                n4 = this.drawUnselectedText(graphics, n4, n5, n2, this.sel0);
                n4 = this.drawSelectedText(graphics, n4, n5, this.sel0, n3);
            }
        } else if (this.sel1 >= n2 && this.sel1 <= n3) {
            n4 = this.drawSelectedText(graphics, n4, n5, n2, this.sel1);
            n4 = this.drawUnselectedText(graphics, n4, n5, this.sel1, n3);
        } else {
            n4 = this.drawUnselectedText(graphics, n4, n5, n2, n3);
        }
        return n4;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            int n2 = 0;
            while (n2 < elementArray2.length) {
                viewArray[n2] = new WrappedLine(this, elementArray2[n2]);
                ++n2;
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n2 = documentEvent.getOffset();
        View view = this.getViewAtPosition(n2, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n2 = documentEvent.getOffset();
        View view = this.getViewAtPosition(n2, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    class WrappedLine
    extends View {
        int nlines;
        private final WrappedPlainView this$0;

        final int calculateLineCount() {
            int n2 = 0;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                ++n2;
                int n5 = this.this$0.calculateBreakPosition(n4, n3);
                int n6 = n4 = n5 == n4 ? n3 : n5;
            }
            return n2;
        }

        public float getPreferredSpan(int n2) {
            switch (n2) {
                case 0: {
                    float f2 = this.this$0.getWidth();
                    if (f2 == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return f2;
                }
                case 1: {
                    if (this.nlines == 0 || this.this$0.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    int n3 = this.nlines * this.this$0.metrics.getHeight();
                    return n3;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n2);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            int n2 = rectangle.y + this.this$0.metrics.getAscent();
            int n3 = rectangle.x;
            JTextComponent jTextComponent = (JTextComponent)this.getContainer();
            Highlighter highlighter = jTextComponent.getHighlighter();
            LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
            int n4 = this.getEndOffset();
            int n5 = this.getStartOffset();
            while (n5 < n4) {
                int n6 = this.this$0.calculateBreakPosition(n5, n4);
                if (layeredHighlighter != null) {
                    if (n6 == n4) {
                        layeredHighlighter.paintLayeredHighlights(graphics, n5, n6 - 1, shape, jTextComponent, this);
                    } else {
                        layeredHighlighter.paintLayeredHighlights(graphics, n5, n6, shape, jTextComponent, this);
                    }
                }
                this.this$0.drawLine(n5, n6, graphics, n3, n2);
                n5 = n6 == n5 ? n4 : n6;
                n2 += this.this$0.metrics.getHeight();
            }
        }

        WrappedLine(WrappedPlainView wrappedPlainView, Element element) {
            this.this$0 = wrappedPlainView;
            super(element);
        }

        public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            Document document = this.getDocument();
            int n2 = (int)f2;
            int n3 = (int)f3;
            if (n3 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n3 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            rectangle.height = this.this$0.metrics.getHeight();
            int n4 = this.getEndOffset();
            int n5 = this.getStartOffset();
            while (n5 < n4) {
                int n6 = this.this$0.calculateBreakPosition(n5, n4);
                if (n3 >= rectangle.y && n3 < rectangle.y + rectangle.height) {
                    if (n2 < rectangle.x) {
                        return n5;
                    }
                    if (n2 > rectangle.x + rectangle.width) {
                        return n6;
                    }
                    Segment segment = SegmentCache.getSharedSegment();
                    this.this$0.loadText(segment, n5, n4);
                    int n7 = Utilities.getTabbedTextOffset(segment, this.this$0.metrics, rectangle.x, n2, this.this$0, n5);
                    SegmentCache.releaseSharedSegment(segment);
                    return Math.min(n5 + n7, n4 - 1);
                }
                n5 = n6 == n5 ? n4 : n6;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            rectangle.height = this.this$0.metrics.getHeight();
            rectangle.width = 1;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            int n5 = bias == Position.Bias.Forward ? n2 : Math.max(n4, n2 - 1);
            while (n4 < n3) {
                int n6 = this.this$0.calculateBreakPosition(n4, n3);
                if (n2 >= n4 && n5 < n6) {
                    Segment segment = SegmentCache.getSharedSegment();
                    this.this$0.loadText(segment, n4, n2);
                    rectangle.x += Utilities.getTabbedTextWidth(segment, this.this$0.metrics, rectangle.x, this.this$0, n4);
                    SegmentCache.releaseSharedSegment(segment);
                    return rectangle;
                }
                if (n6 == n3 && n2 == n3) {
                    if (n2 > n4) {
                        Segment segment = SegmentCache.getSharedSegment();
                        this.this$0.loadText(segment, n4, n2);
                        rectangle.x += Utilities.getTabbedTextWidth(segment, this.this$0.metrics, rectangle.x, this.this$0, n4);
                        SegmentCache.releaseSharedSegment(segment);
                    }
                    return rectangle;
                }
                n4 = n6 == n4 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n2);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n2 = this.calculateLineCount();
            if (this.nlines != n2) {
                this.nlines = n2;
                this.this$0.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n2 = this.calculateLineCount();
            if (this.nlines != n2) {
                this.nlines = n2;
                this.this$0.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

