/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char DIGIT_KEY = '#';
    private static final char LITERAL_KEY = '\'';
    private static final char UPPERCASE_KEY = 'U';
    private static final char LOWERCASE_KEY = 'L';
    private static final char ALPHA_NUMERIC_KEY = 'A';
    private static final char CHARACTER_KEY = '?';
    private static final char ANYTHING_KEY = '*';
    private static final char HEX_KEY = 'H';
    private static final MaskCharacter[] EmptyMaskChars = new MaskCharacter[0];
    private String mask;
    private transient MaskCharacter[] maskChars;
    private String validCharacters;
    private String invalidCharacters;
    private String placeholderString;
    private char placeholder;
    private boolean containsLiteralChars;

    public char getPlaceholderCharacter() {
        return this.placeholder;
    }

    private int getMaxLength() {
        return this.maskChars.length;
    }

    public MaskFormatter() {
        this.setAllowsInvalid(false);
        this.containsLiteralChars = true;
        this.maskChars = EmptyMaskChars;
        this.placeholder = (char)32;
    }

    private void updateInternalMask() throws ParseException {
        ArrayList arrayList;
        String string = this.getMask();
        ArrayList arrayList2 = arrayList = new ArrayList();
        if (string != null) {
            int n2 = 0;
            int n3 = string.length();
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                switch (c2) {
                    case '#': {
                        arrayList2.add(new DigitMaskCharacter(this, null));
                        break;
                    }
                    case '\'': {
                        if (++n2 >= n3) break;
                        c2 = string.charAt(n2);
                        arrayList2.add(new LiteralCharacter(this, c2));
                        break;
                    }
                    case 'U': {
                        arrayList2.add(new UpperCaseCharacter(this, null));
                        break;
                    }
                    case 'L': {
                        arrayList2.add(new LowerCaseCharacter(this, null));
                        break;
                    }
                    case 'A': {
                        arrayList2.add(new AlphaNumericCharacter(this, null));
                        break;
                    }
                    case '?': {
                        arrayList2.add(new CharCharacter(this, null));
                        break;
                    }
                    case '*': {
                        arrayList2.add(new MaskCharacter(this, null));
                        break;
                    }
                    case 'H': {
                        arrayList2.add(new HexCharacter(this, null));
                        break;
                    }
                    default: {
                        arrayList2.add(new LiteralCharacter(this, c2));
                    }
                }
                ++n2;
            }
        }
        if (arrayList.size() == 0) {
            this.maskChars = EmptyMaskChars;
        } else {
            this.maskChars = new MaskCharacter[arrayList.size()];
            arrayList.toArray(this.maskChars);
        }
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.containsLiteralChars;
    }

    public void setPlaceholderCharacter(char c2) {
        this.placeholder = c2;
    }

    private char getLiteral(int n2) {
        return this.getMaskCharacter(n2).getChar('\u0000');
    }

    private boolean isLiteral(int n2) {
        return this.getMaskCharacter(n2).isLiteral();
    }

    boolean isNavigatable(int n2) {
        if (!this.getAllowsInvalid()) {
            return n2 < this.getMaxLength() && !this.isLiteral(n2);
        }
        return true;
    }

    private char getCharacter(int n2, char c2) {
        return this.getMaskCharacter(n2).getChar(c2);
    }

    private boolean isPlaceholder(int n2, char c2) {
        return this.getPlaceholderCharacter() == c2;
    }

    private boolean isValidCharacter(int n2, char c2) {
        return this.getMaskCharacter(n2).isValidCharacter(c2);
    }

    public void setValueContainsLiteralCharacters(boolean bl2) {
        this.containsLiteralChars = bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.updateInternalMask();
        }
        catch (ParseException parseException) {}
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public String getMask() {
        return this.mask;
    }

    public String getPlaceholder() {
        return this.placeholderString;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public MaskFormatter(String string) throws ParseException {
        this();
        this.setMask(string);
    }

    public void setInvalidCharacters(String string) {
        this.invalidCharacters = string;
    }

    public void setMask(String string) throws ParseException {
        this.mask = string;
        this.updateInternalMask();
    }

    public void setPlaceholder(String string) {
        this.placeholderString = string;
    }

    public void setValidCharacters(String string) {
        this.validCharacters = string;
    }

    private int getInvalidOffset(String string, boolean bl2) {
        int n2 = string.length();
        if (n2 != this.getMaxLength()) {
            return n2;
        }
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            char c2 = string.charAt(n3);
            if (!(this.isValidCharacter(n3, c2) || !bl2 && this.isPlaceholder(n3, c2))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void install(JFormattedTextField jFormattedTextField) {
        block2: {
            super.install(jFormattedTextField);
            if (jFormattedTextField == null) break block2;
            Object object = jFormattedTextField.getValue();
            try {
                this.stringToValue(this.valueToString(object));
            }
            catch (ParseException parseException) {
                this.setEditValid(false);
            }
        }
    }

    boolean canReplace(DefaultFormatter.ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            int n2;
            StringBuffer stringBuffer = null;
            String string = replaceHolder.text;
            int n3 = n2 = string != null ? string.length() : 0;
            if (n2 == 0 && replaceHolder.length == 1 && this.getFormattedTextField().getSelectionStart() != replaceHolder.offset) {
                while (replaceHolder.offset > 0 && this.isLiteral(replaceHolder.offset)) {
                    --replaceHolder.offset;
                }
            }
            int n4 = Math.min(this.getMaxLength() - replaceHolder.offset, Math.max(n2, replaceHolder.length));
            int n5 = 0;
            int n6 = 0;
            while (n5 < n4) {
                if (n6 < n2 && this.isValidCharacter(replaceHolder.offset + n5, string.charAt(n6))) {
                    char c2 = string.charAt(n6);
                    if (c2 != this.getCharacter(replaceHolder.offset + n5, c2) && stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        if (n6 > 0) {
                            stringBuffer.append(string.substring(0, n6));
                        }
                    }
                    if (stringBuffer != null) {
                        stringBuffer.append(this.getCharacter(replaceHolder.offset + n5, c2));
                    }
                    ++n6;
                } else if (this.isLiteral(replaceHolder.offset + n5)) {
                    if (stringBuffer != null) {
                        stringBuffer.append(this.getLiteral(replaceHolder.offset + n5));
                    } else if (n6 > 0) {
                        stringBuffer = new StringBuffer(n4);
                        stringBuffer.append(string.substring(0, n6));
                        stringBuffer.append(this.getLiteral(replaceHolder.offset + n5));
                        if (n6 < n2) {
                            n4 = Math.min(n4 + 1, this.getMaxLength() - replaceHolder.offset);
                        } else if (replaceHolder.cursorPosition == -1) {
                            replaceHolder.cursorPosition = replaceHolder.offset + n5;
                        }
                    } else {
                        ++replaceHolder.offset;
                        --replaceHolder.length;
                        --n5;
                        --n4;
                    }
                } else if (n6 >= n2) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        if (string != null) {
                            stringBuffer.append(string);
                        }
                    }
                    stringBuffer.append(this.getPlaceholderCharacter());
                    if (n2 > 0 && replaceHolder.cursorPosition == -1) {
                        replaceHolder.cursorPosition = replaceHolder.offset + n5;
                    }
                } else {
                    return false;
                }
                ++n5;
            }
            if (stringBuffer != null) {
                replaceHolder.text = stringBuffer.toString();
            } else if (string != null && replaceHolder.offset + n2 > this.getMaxLength()) {
                replaceHolder.text = string.substring(0, this.getMaxLength() - replaceHolder.offset);
            }
            if (this.getOverwriteMode() && replaceHolder.text != null) {
                replaceHolder.length = replaceHolder.text.length();
            }
        }
        return super.canReplace(replaceHolder);
    }

    boolean isValidEdit(DefaultFormatter.ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            String string = this.getReplaceString(replaceHolder.offset, replaceHolder.length, replaceHolder.text);
            try {
                replaceHolder.value = this.stringToValue(string, false);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    private MaskCharacter getMaskCharacter(int n2) {
        if (n2 >= this.maskChars.length) {
            return null;
        }
        return this.maskChars[n2];
    }

    public Object stringToValue(String string) throws ParseException {
        return this.stringToValue(string, true);
    }

    private Object stringToValue(String string, boolean bl2) throws ParseException {
        int n2 = -1;
        n2 = this.getInvalidOffset(string, bl2);
        if (n2 == -1) {
            if (!this.getValueContainsLiteralCharacters()) {
                string = this.stripLiteralChars(string);
            }
            return super.stringToValue(string);
        }
        throw new ParseException("stringToValue passed invalid value", n2);
    }

    public String valueToString(Object object) throws ParseException {
        String string = object == null ? "" : object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getPlaceholder();
        int[] nArray = new int[]{0};
        this.append(stringBuffer, string, nArray, string2, this.maskChars);
        return stringBuffer.toString();
    }

    private String stripLiteralChars(String string) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            if (this.isLiteral(n3)) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    if (n3 > 0) {
                        stringBuffer.append(string.substring(0, n3));
                    }
                    n2 = n3 + 1;
                } else if (n2 != n3) {
                    stringBuffer.append(string.substring(n2, n3));
                }
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (stringBuffer == null) {
            return string;
        }
        if (n2 != string.length()) {
            if (stringBuffer == null) {
                return string.substring(n2);
            }
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private void append(StringBuffer stringBuffer, String string, int[] nArray, String string2, MaskCharacter[] maskCharacterArray) throws ParseException {
        int n2 = 0;
        int n3 = maskCharacterArray.length;
        while (n2 < n3) {
            maskCharacterArray[n2].append(stringBuffer, string, nArray, string2);
            ++n2;
        }
    }

    class 1 {
    }

    private class AlphaNumericCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public boolean isValidCharacter(char c2) {
            return Character.isLetterOrDigit(c2) && super.isValidCharacter(c2);
        }

        private AlphaNumericCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        AlphaNumericCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }

    private class CharCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public boolean isValidCharacter(char c2) {
            return Character.isLetter(c2) && super.isValidCharacter(c2);
        }

        private CharCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        CharCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }

    private class DigitMaskCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public boolean isValidCharacter(char c2) {
            return Character.isDigit(c2) && super.isValidCharacter(c2);
        }

        private DigitMaskCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        DigitMaskCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }

    private class HexCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public char getChar(char c2) {
            if (Character.isDigit(c2)) {
                return c2;
            }
            return Character.toUpperCase(c2);
        }

        public boolean isValidCharacter(char c2) {
            return (c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9' || c2 == 'a' || c2 == 'A' || c2 == 'b' || c2 == 'B' || c2 == 'c' || c2 == 'C' || c2 == 'd' || c2 == 'D' || c2 == 'e' || c2 == 'E' || c2 == 'f' || c2 == 'F') && super.isValidCharacter(c2);
        }

        private HexCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        HexCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }

    private class LiteralCharacter
    extends MaskCharacter {
        private char fixedChar;
        private final MaskFormatter this$0;

        public boolean isLiteral() {
            return true;
        }

        public char getChar(char c2) {
            return this.fixedChar;
        }

        public LiteralCharacter(MaskFormatter maskFormatter, char c2) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
            this.fixedChar = c2;
        }
    }

    private class LowerCaseCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public char getChar(char c2) {
            return Character.toLowerCase(c2);
        }

        public boolean isValidCharacter(char c2) {
            return Character.isLetter(c2) && super.isValidCharacter(c2);
        }

        private LowerCaseCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        LowerCaseCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }

    private class MaskCharacter {
        private final MaskFormatter this$0;

        public boolean isLiteral() {
            return false;
        }

        public char getChar(char c2) {
            return c2;
        }

        public boolean isValidCharacter(char c2) {
            if (this.isLiteral()) {
                return this.getChar(c2) == c2;
            }
            c2 = this.getChar(c2);
            String string = this.this$0.getValidCharacters();
            if (string != null && string.indexOf(c2) == -1) {
                return false;
            }
            string = this.this$0.getInvalidCharacters();
            return string == null || string.indexOf(c2) == -1;
        }

        private MaskCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
        }

        MaskCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }

        public void append(StringBuffer stringBuffer, String string, int[] nArray, String string2) throws ParseException {
            char c2;
            boolean bl2 = nArray[0] < string.length();
            char c3 = c2 = bl2 ? string.charAt(nArray[0]) : (char)'\u0000';
            if (this.isLiteral()) {
                stringBuffer.append(this.getChar(c2));
                if (this.this$0.getValueContainsLiteralCharacters()) {
                    if (bl2 && c2 != this.getChar(c2)) {
                        throw new ParseException("Invalid character: " + c2, nArray[0]);
                    }
                    nArray[0] = nArray[0] + 1;
                }
            } else if (nArray[0] >= string.length()) {
                if (string2 != null && nArray[0] < string2.length()) {
                    stringBuffer.append(string2.charAt(nArray[0]));
                } else {
                    stringBuffer.append(this.this$0.getPlaceholderCharacter());
                }
                nArray[0] = nArray[0] + 1;
            } else if (this.isValidCharacter(c2)) {
                stringBuffer.append(this.getChar(c2));
                nArray[0] = nArray[0] + 1;
            } else {
                throw new ParseException("Invalid character: " + c2, nArray[0]);
            }
        }
    }

    private class UpperCaseCharacter
    extends MaskCharacter {
        private final MaskFormatter this$0;

        public char getChar(char c2) {
            return Character.toUpperCase(c2);
        }

        public boolean isValidCharacter(char c2) {
            return Character.isLetter(c2) && super.isValidCharacter(c2);
        }

        private UpperCaseCharacter(MaskFormatter maskFormatter) {
            this.this$0 = maskFormatter;
            super(maskFormatter, null);
        }

        UpperCaseCharacter(MaskFormatter maskFormatter, 1 var2_2) {
            this(maskFormatter);
        }
    }
}

