/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

class BumpBuffer {
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize = new Dimension(64, 64);
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;
    private GraphicsConfiguration gc;

    private void createImage() {
        if (this.gc != null) {
            this.image = this.gc.createCompatibleImage(64, 64);
        } else {
            int[] nArray = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 3, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
        }
    }

    private void fillBumpBuffer() {
        int n2;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        int n3 = 0;
        while (n3 < 64) {
            n2 = 0;
            while (n2 < 64) {
                graphics.drawLine(n3, n2, n3, n2);
                graphics.drawLine(n3 + 2, n2 + 2, n3 + 2, n2 + 2);
                n2 += 4;
            }
            n3 += 4;
        }
        graphics.setColor(this.shadowColor);
        n2 = 0;
        while (n2 < 64) {
            int n4 = 0;
            while (n4 < 64) {
                graphics.drawLine(n2 + 1, n4 + 1, n2 + 1, n4 + 1);
                graphics.drawLine(n2 + 3, n4 + 3, n2 + 3, n4 + 3);
                n4 += 4;
            }
            n2 += 4;
        }
        graphics.dispose();
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    public Image getImage() {
        return this.image;
    }

    public BumpBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        this.gc = graphicsConfiguration;
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.createImage();
        this.fillBumpBuffer();
    }

    public boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.gc != null ? !this.gc.equals(graphicsConfiguration) : graphicsConfiguration != null) {
            return false;
        }
        return this.topColor.equals(color) && this.shadowColor.equals(color2) && this.backColor.equals(color3);
    }
}

